/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.editor.listeners;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.javaee.editor.listeners.ComponentUpdateUtil;
import com.ibm.etools.javaee.editor.listeners.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class EditorArchiveNameFieldSyncListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String PROJECT_COMPONENT_UPDATE_JOB_FAMILY = "org.eclipse.jst.j2ee.refactor.component";
    private IFile appDDFile = null;
    private final ComponentUpdateJob componentUpdateJob = new ComponentUpdateJob();
    private static final int COMPONENT_UPDATE_DELAY = 30;

    public EditorArchiveNameFieldSyncListener(IFile curApplicationDDFile) {
        this.appDDFile = curApplicationDDFile;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                J2eePlugin.logError(e);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 2: {
                return resource.getFullPath().isPrefixOf(this.appDDFile.getFullPath());
            }
            case 4: {
                return resource.getName().equals(this.appDDFile.getProject().getName());
            }
            case 1: {
                if (resource.getName().equals(this.appDDFile.getName())) {
                    this.componentUpdateJob.setResourceToUpdate(resource);
                    this.componentUpdateJob.schedule(30L);
                }
                return false;
            }
        }
        return false;
    }

    public class ComponentUpdateJob
    extends Job {
        private IResource resourceToUpdate;

        public ComponentUpdateJob() {
            super(Messages.EditorArchiveNameFieldSyncListener_0);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return ComponentUpdateUtil.updateComponentFile(this.resourceToUpdate, monitor);
        }

        public void setResourceToUpdate(IResource resource) {
            this.resourceToUpdate = resource;
        }
    }
}

