/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.EjbRef;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.web.WebFragment;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class ReferenceDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String OWNER = "ReferenceDataModel.OWNER";
    public static final String REF_NAME = "ReferenceDataModel.REF_NAME";
    public static final String DESCRIPTION = "ReferenceDataModel.DESCRIPTION";
    public static final String MODULE_TYPE = "ReferenceDataModel.MODULE_TYPE";
    public static final String J2EE_VERSION = "ReferenceDataModel.J2EE_VERSION";
    public static final int EJB_TYPE = 0;
    public static final int APP_CLIENT_TYPE = 1;
    public static final int WEB_TYPE = 2;
    public static final int WEB_FRAGMENT = 3;
    protected int ownerType;

    protected void init() {
        super.init();
    }

    protected void initializeOwnerNature() {
        IProject ownerProject;
        EObject owner = (EObject)this.getProperty(OWNER);
        if (owner != null && (ownerProject = ProjectUtilities.getProject((EObject)owner)) != null) {
            if (owner instanceof EnterpriseBean) {
                this.ownerType = 0;
            } else if (owner instanceof ApplicationClient) {
                this.ownerType = 1;
            } else if (owner instanceof WebApp) {
                this.ownerType = 2;
            } else if (owner instanceof WebFragment) {
                this.ownerType = 3;
            }
        }
    }

    @Override
    protected void initValidBaseProperties() {
        this.addValidBaseProperty(OWNER);
        this.addValidBaseProperty(REF_NAME);
        this.addValidBaseProperty(DESCRIPTION);
        this.addValidBaseProperty(J2EE_VERSION);
        this.addValidBaseProperty(MODULE_TYPE);
        super.initValidBaseProperties();
    }

    @Override
    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean doSet = super.doSetProperty(propertyName, propertyValue);
        if (OWNER.equals(propertyName)) {
            try {
                this.initializeOwnerNature();
                this.notifyDefaultChange(MODULE_TYPE);
                this.notifyDefaultChange(J2EE_VERSION);
            }
            catch (Exception e) {
                J2eePlugin.logError(e);
            }
        }
        return doSet;
    }

    @Override
    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(MODULE_TYPE)) {
            return this.calculateOwnerModuleType();
        }
        if (propertyName.equals(J2EE_VERSION)) {
            int version = this.calculateJ2EEVersionForOwnerModule();
            return new Integer(version);
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object calculateOwnerModuleType() {
        IProject ownerProject;
        EObject owner = (EObject)this.getProperty(OWNER);
        if (owner != null && (ownerProject = ProjectUtilities.getProject((EObject)owner)) != null) {
            if (owner instanceof EnterpriseBean) {
                return "ejb-jar_ID";
            }
            if (owner instanceof ApplicationClient) {
                return "Application-client_ID";
            }
            if (owner instanceof WebApp) {
                return "WebApp_ID";
            }
            if (owner instanceof WebFragment) {
                return "WebFragment_ID";
            }
        }
        return null;
    }

    private int calculateJ2EEVersionForOwnerModule() {
        String moduleType = this.getStringProperty(MODULE_TYPE);
        if (moduleType == null) {
            return -1;
        }
        if (moduleType.equals("ejb-jar_ID")) {
            switch (((EnterpriseBean)this.getProperty(OWNER)).getVersionID()) {
                case 10: {
                    return 12;
                }
                case 11: {
                    return 12;
                }
                case 20: {
                    return 13;
                }
                case 21: {
                    return 14;
                }
                case 30: {
                    return 50;
                }
                case 31: {
                    return 60;
                }
            }
            return 14;
        }
        if (moduleType.equals("WebApp_ID")) {
            switch (((WebApp)this.getProperty(OWNER)).getVersionID()) {
                case 22: {
                    return 12;
                }
                case 23: {
                    return 13;
                }
                case 24: {
                    return 14;
                }
                case 25: {
                    return 50;
                }
                case 30: {
                    return 60;
                }
            }
            return 14;
        }
        if (moduleType.equals("Application-client_ID")) {
            return ((ApplicationClient)this.getProperty(OWNER)).getVersionID();
        }
        if (moduleType.equals("WebFragment_ID")) {
            return 60;
        }
        return -1;
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        if (OWNER.equals(propertyName) && this.getProperty(OWNER) == null) {
            return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.ReferenceDataModel_UI_3);
        }
        if (REF_NAME.equals(propertyName)) {
            String nameValue = this.getStringProperty(propertyName);
            if (nameValue == null || nameValue.trim().equals("")) {
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.ReferenceDataModel_UI_5);
            }
            if (!this.validateReferenceDoesNotExist(nameValue.trim())) {
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.ReferenceDataModel_UI_6);
            }
        }
        return super.doValidateProperty(propertyName);
    }

    public boolean validateReferenceDoesNotExist(String nameValue) {
        if (this.ownerType == 0) {
            Object bean = this.getProperty(OWNER);
            if (bean instanceof EnterpriseBean) {
                if (this.checkResourceRefExists(((EnterpriseBean)bean).getResourceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkResourceEnvRefExists(((EnterpriseBean)bean).getResourceEnvRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBLocalRefExists(((EnterpriseBean)bean).getEjbLocalRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBRefExists(((EnterpriseBean)bean).getEjbRefs(), nameValue)) {
                    return false;
                }
                if (this.checkSecurityRoleRefExists(((EnterpriseBean)bean).getSecurityRoleRefs(), nameValue)) {
                    return false;
                }
                if (((EnterpriseBean)bean).eResource() != null && ((EnterpriseBean)bean).getVersionID() >= 21) {
                    if (this.checkServiceRefExists((List)((EnterpriseBean)bean).getServiceRefs(), nameValue)) {
                        return false;
                    }
                    if (this.checkMessageDestRefExists(((EnterpriseBean)bean).getMessageDestinationRefs(), nameValue)) {
                        return false;
                    }
                } else {
                    WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
                    List temp = serviceHelper.get13ServiceRefs((EObject)((EnterpriseBean)bean));
                    if (temp != null && !temp.isEmpty() && this.checkServiceRefExists(temp, nameValue)) {
                        return false;
                    }
                }
            } else if (bean instanceof EntityBean) {
                if (this.checkResourceRefExists((EList)((EntityBean)bean).getResourceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkResourceEnvRefExists((EList)((EntityBean)bean).getResourceEnvRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBLocalRefExists((EList)((EntityBean)bean).getEjbLocalRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBRefExists((EList)((EntityBean)bean).getEjbRefs(), nameValue)) {
                    return false;
                }
                if (this.checkSecurityRoleRefExists((EList)((EntityBean)bean).getSecurityRoleRefs(), nameValue)) {
                    return false;
                }
                if (this.checkServiceRefExists(((EntityBean)bean).getServiceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkMessageDestRefExists((EList)((EntityBean)bean).getMessageDestinationRefs(), nameValue)) {
                    return false;
                }
            } else if (bean instanceof SessionBean) {
                if (this.checkResourceRefExists((EList)((SessionBean)bean).getResourceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkResourceEnvRefExists((EList)((SessionBean)bean).getResourceEnvRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBLocalRefExists((EList)((SessionBean)bean).getEjbLocalRefs(), nameValue)) {
                    return false;
                }
                if (this.checkEJBRefExists((EList)((SessionBean)bean).getEjbRefs(), nameValue)) {
                    return false;
                }
                if (this.checkSecurityRoleRefExists((EList)((SessionBean)bean).getSecurityRoleRefs(), nameValue)) {
                    return false;
                }
                if (this.checkServiceRefExists(((SessionBean)bean).getServiceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkMessageDestRefExists((EList)((SessionBean)bean).getMessageDestinationRefs(), nameValue)) {
                    return false;
                }
            }
        } else if (this.ownerType == 1) {
            ApplicationClient appClient = (ApplicationClient)this.getProperty(OWNER);
            if (this.checkResourceRefExists(appClient.getResourceRefs(), nameValue)) {
                return false;
            }
            if (this.checkResourceEnvRefExists(appClient.getResourceEnvRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBRefExists(appClient.getEjbReferences(), nameValue)) {
                return false;
            }
            if (appClient.getVersionID() >= 14) {
                if (this.checkServiceRefExists((List)appClient.getServiceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkMessageDestRefExists(appClient.getMessageDestinationRefs(), nameValue)) {
                    return false;
                }
            } else {
                WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
                List temp = serviceHelper.get13ServiceRefs((EObject)appClient);
                if (temp != null && !temp.isEmpty() && this.checkServiceRefExists(temp, nameValue)) {
                    return false;
                }
            }
        } else if (this.ownerType == 2) {
            WebApp webApp = (WebApp)this.getProperty(OWNER);
            if (this.checkResourceRefExists(webApp.getResourceRefs(), nameValue)) {
                return false;
            }
            if (this.checkResourceEnvRefExists(webApp.getResourceEnvRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBLocalRefExists(webApp.getEjbLocalRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBRefExists(webApp.getEjbRefs(), nameValue)) {
                return false;
            }
            if (webApp.getVersionID() >= 24) {
                if (this.checkServiceRefExists((List)webApp.getServiceRefs(), nameValue)) {
                    return false;
                }
                if (this.checkMessageDestRefExists(webApp.getMessageDestinationRefs(), nameValue)) {
                    return false;
                }
            } else {
                WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
                List temp = serviceHelper.get13ServiceRefs((EObject)webApp);
                if (temp != null && !temp.isEmpty() && this.checkServiceRefExists(temp, nameValue)) {
                    return false;
                }
            }
        } else if (this.ownerType == 3) {
            WebFragment webfrag = (WebFragment)this.getProperty(OWNER);
            if (this.checkResourceRefExists((EList)webfrag.getResourceRefs(), nameValue)) {
                return false;
            }
            if (this.checkResourceEnvRefExists((EList)webfrag.getResourceEnvRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBLocalRefExists((EList)webfrag.getEjbLocalRefs(), nameValue)) {
                return false;
            }
            if (this.checkEJBRefExists((EList)webfrag.getEjbRefs(), nameValue)) {
                return false;
            }
            if (this.checkServiceRefExists(webfrag.getServiceRefs(), nameValue)) {
                return false;
            }
            if (this.checkMessageDestRefExists((EList)webfrag.getMessageDestinationRefs(), nameValue)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkSecurityRoleRefExists(EList list, String refName) {
        if (list != null) {
            String secRef = null;
            for (int i = 0; i < list.size(); ++i) {
                SecurityRoleRef ref;
                if (list.get(i) instanceof SecurityRoleRef) {
                    ref = (SecurityRoleRef)list.get(i);
                    secRef = ref.getName();
                } else if (list.get(i) instanceof org.eclipse.jst.javaee.core.SecurityRoleRef) {
                    ref = (org.eclipse.jst.javaee.core.SecurityRoleRef)list.get(i);
                    secRef = ref.getRoleName();
                }
                if (secRef == null || !secRef.equals(refName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkEJBRefExists(EList list, String refName) {
        if (list != null) {
            String ejbRefName = null;
            for (int i = 0; i < list.size(); ++i) {
                org.eclipse.jst.j2ee.common.EjbRef ref;
                if (list.get(i) instanceof org.eclipse.jst.j2ee.common.EjbRef) {
                    ref = (org.eclipse.jst.j2ee.common.EjbRef)list.get(i);
                    ejbRefName = ref.getName();
                } else if (list.get(i) instanceof EjbRef) {
                    ref = (EjbRef)list.get(i);
                    ejbRefName = ref.getEjbRefName();
                }
                if (ejbRefName == null || !ejbRefName.equals(refName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkEJBLocalRefExists(EList list, String refName) {
        if (list != null) {
            String ejbRefName = null;
            for (int i = 0; i < list.size(); ++i) {
                EJBLocalRef ref;
                if (list.get(i) instanceof EJBLocalRef) {
                    ref = (EJBLocalRef)list.get(i);
                    ejbRefName = ref.getName();
                } else if (list.get(i) instanceof EjbLocalRef) {
                    ref = (EjbLocalRef)list.get(i);
                    ejbRefName = ref.getEjbRefName();
                }
                if (ejbRefName == null || !ejbRefName.equals(refName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkServiceRefExists(List list, String refName) {
        if (list != null) {
            String servRef = null;
            for (int i = 0; i < list.size(); ++i) {
                ServiceRef ref;
                if (list.get(i) instanceof ServiceRef) {
                    ref = (ServiceRef)list.get(i);
                    servRef = ref.getServiceRefName();
                } else if (list.get(i) instanceof org.eclipse.jst.javaee.core.ServiceRef) {
                    ref = (org.eclipse.jst.javaee.core.ServiceRef)list.get(i);
                    servRef = ref.getServiceRefName();
                }
                if (servRef == null || !servRef.equals(refName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkResourceEnvRefExists(EList list, String refName) {
        if (list != null) {
            String resRef = null;
            for (int i = 0; i < list.size(); ++i) {
                ResourceEnvRef ref;
                if (list.get(i) instanceof ResourceEnvRef) {
                    ref = (ResourceEnvRef)list.get(i);
                    resRef = ref.getName();
                } else if (list.get(i) instanceof org.eclipse.jst.javaee.core.ResourceEnvRef) {
                    ref = (org.eclipse.jst.javaee.core.ResourceEnvRef)list.get(i);
                    resRef = ref.getResourceEnvRefName();
                }
                if (resRef == null || !resRef.equals(refName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkResourceRefExists(EList list, String refName) {
        if (list != null) {
            String resRef = null;
            for (int i = 0; i < list.size(); ++i) {
                org.eclipse.jst.j2ee.common.ResourceRef ref;
                if (list.get(i) instanceof org.eclipse.jst.j2ee.common.ResourceRef) {
                    ref = (org.eclipse.jst.j2ee.common.ResourceRef)list.get(i);
                    resRef = ref.getName();
                } else if (list.get(i) instanceof ResourceRef) {
                    ref = (ResourceRef)list.get(i);
                    resRef = ref.getResRefName();
                }
                if (resRef == null || !resRef.equals(refName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMessageDestRefExists(EList list, String refName) {
        if (list != null) {
            String mdRef = null;
            for (int i = 0; i < list.size(); ++i) {
                MessageDestinationRef ref;
                if (list.get(i) instanceof MessageDestinationRef) {
                    ref = (MessageDestinationRef)list.get(i);
                    mdRef = ref.getName();
                } else if (list.get(i) instanceof org.eclipse.jst.javaee.core.MessageDestinationRef) {
                    ref = (org.eclipse.jst.javaee.core.MessageDestinationRef)list.get(i);
                    mdRef = ref.getMessageDestinationRefName();
                }
                if (mdRef == null || !mdRef.equals(refName)) continue;
                return true;
            }
        }
        return false;
    }
}

