/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.manifest;

import com.ibm.etools.j2ee.J2eePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.internal.modulecore.util.IJavaComponentDiscerner;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ClasspathDependenciesDiscerner
implements IJavaComponentDiscerner {
    public IProject[] findParentProjects(IProject child) {
        return new IProject[0];
    }

    public IVirtualReference[] findPossibleManifestEntries(IProject parentProject, IProject childProject) {
        if (EarUtilities.isEARProject((IProject)parentProject)) {
            ArrayList<IVirtualReference> allPossible = this.getClasspathDependenciesAsRefs(parentProject, childProject);
            IVirtualReference[] alreadyReferenced = this.findCurrentManifestEntries(parentProject, childProject, allPossible);
            allPossible.removeAll(Arrays.asList(alreadyReferenced));
            return allPossible.toArray(new IVirtualReference[allPossible.size()]);
        }
        return new IVirtualReference[0];
    }

    public IVirtualReference[] findPossibleManifestEntries(IProject parentProject, IProject childProject, IVirtualReference[] currentEntries) {
        if (EarUtilities.isEARProject((IProject)parentProject)) {
            ArrayList<IVirtualReference> allPossible = this.getClasspathDependenciesAsRefs(parentProject, childProject);
            allPossible.removeAll(Arrays.asList(currentEntries));
            return allPossible.toArray(new IVirtualReference[allPossible.size()]);
        }
        return new IVirtualReference[0];
    }

    public IVirtualReference[] findCurrentManifestEntries(IProject parentProject, IProject childProject) {
        return this.findCurrentManifestEntries(parentProject, childProject, this.getClasspathDependenciesAsRefs(parentProject, childProject));
    }

    protected IVirtualReference[] findCurrentManifestEntries(IProject parentProject, IProject childProject, ArrayList<IVirtualReference> allPossibleEntries) {
        ArrayList<IVirtualReference> currentEntries = new ArrayList<IVirtualReference>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)childProject);
        List<String> entries = Arrays.asList(ManifestUtilities.getManifestClasspath((IVirtualComponent)component, (IPath)new Path("META-INF/MANIFEST.MF")));
        for (IVirtualReference currentI : allPossibleEntries) {
            String currentEntry = currentI.getRuntimePath().append((IPath)new Path(currentI.getArchiveName())).toString();
            if (!entries.contains(currentEntry)) continue;
            currentEntries.add(currentI);
        }
        return currentEntries.toArray(new IVirtualReference[currentEntries.size()]);
    }

    protected ArrayList<IVirtualReference> getClasspathDependenciesAsRefs(IProject parentProject, IProject childProject) {
        ArrayList<IVirtualReference> retval = new ArrayList<IVirtualReference>();
        IVirtualComponent earComponent = ComponentCore.createComponent((IProject)parentProject);
        IVirtualComponent childComponent = ComponentCore.createComponent((IProject)childProject);
        Map<IClasspathEntry, IClasspathEntry> classpathEntries = ClasspathDependenciesDiscerner.getClasspathDependencies(earComponent, childComponent, true);
        for (IClasspathEntry resolvedEntry : classpathEntries.keySet()) {
            IClasspathEntry unresolvedEntry;
            IPath runtimePath;
            IVirtualReference classpathRef = ClasspathDependenciesDiscerner.convertClasspathEntry(childComponent, resolvedEntry, runtimePath = ClasspathDependencyUtil.getRuntimePath((IClasspathEntry)(unresolvedEntry = classpathEntries.get(resolvedEntry))).removeFirstSegments(1));
            if (classpathRef == null) continue;
            retval.add(classpathRef);
        }
        return retval;
    }

    public static Map<IClasspathEntry, IClasspathEntry> getClasspathDependencies(IVirtualComponent earComponent, IVirtualComponent childComponent, boolean resolveContainer) {
        HashMap<IClasspathEntry, IClasspathEntry> resolvedToUnresolved = new HashMap<IClasspathEntry, IClasspathEntry>();
        ArrayList<IClasspathEntry> unresolvedVariables = new ArrayList<IClasspathEntry>();
        IJavaProjectLite lite = JavaCoreLite.create((IProject)childComponent.getProject());
        if (lite != null) {
            IClasspathEntry[] entries = lite.readRawClasspath();
            String libDir = EarUtilities.getEARLibDir((IVirtualComponent)earComponent);
            for (IClasspathEntry entry : entries) {
                IClasspathAttribute[] attributes = entry.getExtraAttributes();
                for (int i = 0; i < attributes.length; ++i) {
                    IPath runtimePath;
                    boolean isInLibDir;
                    IClasspathAttribute attribute = attributes[i];
                    String name = attribute.getName();
                    if (!name.equals("org.eclipse.jst.component.dependency") || !ClasspathDependencyUtil.isMappedIntoContainer((String)attribute.getValue()) || (isInLibDir = ClasspathDependenciesDiscerner.isInLibDir(earComponent, childComponent, runtimePath = new Path(attribute.getValue()).removeFirstSegments(1), libDir))) continue;
                    if (entry.getEntryKind() == 5) {
                        if (resolveContainer) {
                            IJavaProject javaProj = JavaCore.create((IProject)childComponent.getProject());
                            try {
                                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProj);
                                if (container == null) continue;
                                for (int j = 0; j < container.getClasspathEntries().length; ++j) {
                                    IClasspathEntry childEntry = container.getClasspathEntries()[j];
                                    resolvedToUnresolved.put(childEntry, entry);
                                }
                                continue;
                            }
                            catch (JavaModelException e) {
                                J2eePlugin.logError((CoreException)((Object)e));
                                continue;
                            }
                        }
                        resolvedToUnresolved.put(entry, entry);
                        continue;
                    }
                    if (entry.getEntryKind() == 4) {
                        unresolvedVariables.add(entry);
                        continue;
                    }
                    resolvedToUnresolved.put(entry, entry);
                }
            }
        }
        if (!unresolvedVariables.isEmpty()) {
            Map<IClasspathEntry, IClasspathEntry> resolvedVariables = ClasspathDependenciesDiscerner.getResolvedVarEntries(childComponent.getProject(), unresolvedVariables);
            resolvedToUnresolved.putAll(resolvedVariables);
        }
        return resolvedToUnresolved;
    }

    public static Map<IClasspathEntry, IClasspathEntry> getResolvedVarEntries(IProject childProject, ArrayList<IClasspathEntry> validVarEntries) {
        HashMap<IClasspathEntry, IClasspathEntry> resolvedToUnresolved = new HashMap<IClasspathEntry, IClasspathEntry>();
        IJavaProject javaProject = JavaCore.create((IProject)childProject);
        try {
            IPackageFragmentRoot[] roots;
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            HashMap<IPath, IClasspathEntry> pathToResolvedEntry = new HashMap<IPath, IClasspathEntry>();
            for (int j = 0; j < entries.length; ++j) {
                pathToResolvedEntry.put(entries[j].getPath(), entries[j]);
            }
            for (IPackageFragmentRoot root : roots = javaProject.getPackageFragmentRoots()) {
                IClasspathEntry rawEntry = root.getRawClasspathEntry();
                if (!validVarEntries.contains(rawEntry)) continue;
                IPath pkgFragPath = root.getPath();
                IClasspathEntry resolvedEntry = (IClasspathEntry)pathToResolvedEntry.get(pkgFragPath);
                resolvedToUnresolved.put(resolvedEntry, rawEntry);
            }
        }
        catch (JavaModelException e) {
            J2eePlugin.logError((CoreException)((Object)e));
        }
        return resolvedToUnresolved;
    }

    public static IClasspathEntry getResolvedVarEntry(IProject childProject, IClasspathEntry unresolvedEntry) {
        IJavaProject javaProject = JavaCore.create((IProject)childProject);
        try {
            IPackageFragmentRoot[] roots;
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            HashMap<IPath, IClasspathEntry> pathToResolvedEntry = new HashMap<IPath, IClasspathEntry>();
            for (int j = 0; j < entries.length; ++j) {
                pathToResolvedEntry.put(entries[j].getPath(), entries[j]);
            }
            for (IPackageFragmentRoot root : roots = javaProject.getPackageFragmentRoots()) {
                IClasspathEntry rawEntry = root.getRawClasspathEntry();
                if (!unresolvedEntry.equals((Object)rawEntry)) continue;
                IPath pkgFragPath = root.getPath();
                IClasspathEntry resolvedEntry = (IClasspathEntry)pathToResolvedEntry.get(pkgFragPath);
                return resolvedEntry;
            }
        }
        catch (JavaModelException e) {
            J2eePlugin.logError((CoreException)((Object)e));
        }
        return null;
    }

    public static boolean isInLibDir(IVirtualComponent earComponent, IVirtualComponent childComponent, IPath runtimePath, String libDir) {
        if (libDir != null && libDir.length() > 0) {
            IVirtualReference targetRef = earComponent.getReference(childComponent.getName());
            IPath libDirPath = new Path(libDir).makeRelative();
            IPath targetPath = targetRef.getRuntimePath().append(runtimePath).makeRelative();
            return libDirPath.equals((Object)targetPath);
        }
        return false;
    }

    public static IVirtualReference convertClasspathEntry(IVirtualComponent tmp, IClasspathEntry entry, IPath runtimePath) {
        IPath entryLocation = ClasspathDependencyUtil.getEntryLocation((IClasspathEntry)entry);
        if (entryLocation != null && !ClasspathDependencyUtil.isClassFolderEntry((IClasspathEntry)entry)) {
            String componentPath = "cpe/" + entryLocation.toPortableString();
            ClasspathDependencyVirtualComponent entryComponent = new ClasspathDependencyVirtualComponent(tmp.getProject(), componentPath, false);
            IVirtualReference entryReference = ComponentCore.createReference((IVirtualComponent)tmp, (IVirtualComponent)entryComponent, (IPath)runtimePath);
            ((VirtualReference)entryReference).setDerived(true);
            entryReference.setArchiveName(ClasspathDependencyUtil.getArchiveName((IClasspathEntry)entry));
            return entryReference;
        }
        return null;
    }
}

