/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.java.codegen;

import com.ibm.etools.j2ee.internal.codegen.GenerationException;
import com.ibm.etools.j2ee.internal.codegen.IGenerationBuffer;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberGenerator;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberHistoryDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaTypeDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.MergeResults;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMType;

public abstract class JavaTypeGenerator
extends JavaMemberGenerator {
    private boolean fPrepared = false;
    static final String EXTENDS = " extends ";
    static final String BEGIN_BRACE = "{";
    static final String END_BRACE = "}";

    @Override
    protected MergeResults calculateMergeResults(JavaMemberHistoryDescriptor memberHistory, JavaMemberDescriptor desc) throws GenerationException {
        return this.calculateMergeResults(memberHistory, (JavaTypeDescriptor)desc);
    }

    protected MergeResults calculateMergeResults(JavaMemberHistoryDescriptor typeHistory, JavaTypeDescriptor desc) throws GenerationException {
        MergeResults mr;
        String source = null;
        IDOMType newType = null;
        if (!typeHistory.isDeleteOnly()) {
            IGenerationBuffer typeBuf = this.getGenerationBuffer();
            this.generateType(desc, typeBuf, typeHistory.getCollisionMember() == null);
            source = typeBuf.toString();
            newType = JavaTypeGenerator.getDOMFactory().createType(source);
        }
        if ((mr = this.dispatchToMergeStrategy(typeHistory, newType)).isMerged()) {
            source = mr.getSource();
        }
        mr.setSource(source);
        return mr;
    }

    protected final JavaMemberHistoryDescriptor createDefaultHistoryDescriptor(JavaMemberDescriptor desc) throws GenerationException {
        JavaMemberHistoryDescriptor historyDesc = new JavaMemberHistoryDescriptor();
        historyDesc.setName(desc.getName());
        this.getMatchingMember(historyDesc);
        historyDesc.setCollisionMember(historyDesc.getOldMember());
        return historyDesc;
    }

    @Override
    protected JavaMemberHistoryDescriptor createHistoryDescriptor(JavaMemberDescriptor desc) throws GenerationException {
        JavaMemberHistoryDescriptor historyDesc = this.getHistoryDescriptor();
        if (historyDesc == null) {
            historyDesc = this.createDefaultHistoryDescriptor(desc);
        } else {
            this.getMatchingMember(historyDesc);
            if (!historyDesc.isDeleteOnly()) {
                if (historyDesc.getName().equals(desc.getName())) {
                    historyDesc.setCollisionMember(historyDesc.getOldMember());
                } else {
                    IType oldType = (IType)historyDesc.getOldMember();
                    if (!this.isInner() && oldType != null) {
                        ICompilationUnit oldCU = oldType.getCompilationUnit();
                        String oldCUMainTypeName = oldCU.getElementName();
                        oldCUMainTypeName = oldCUMainTypeName.substring(0, oldCUMainTypeName.length() - 5);
                        if (oldType.getElementName().equals(oldCUMainTypeName)) {
                            throw new GenerationException(JavaCodeGenResourceHandler.Renames_of_main_types_are__EXC_);
                        }
                    }
                    historyDesc.setCollisionMember(this.createDefaultHistoryDescriptor(desc).getCollisionMember());
                }
            }
        }
        return historyDesc;
    }

    @Override
    protected JavaMemberDescriptor createMemberDescriptor() throws GenerationException {
        return this.createTypeDescriptor();
    }

    protected abstract JavaTypeDescriptor createTypeDescriptor() throws GenerationException;

    private IType createTypeInCU(String source, IJavaElement sibling) throws GenerationException {
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        IType type = null;
        try {
            type = compilationUnit.createType(source, sibling, false, this.getTargetContext().getProgressMonitor());
        }
        catch (JavaModelException exc) {
            throw new GenerationException(this.getExceptionIndicator(exc), (Exception)((Object)exc));
        }
        return type;
    }

    private IType createTypeInType(String source, IJavaElement sibling) throws GenerationException {
        IType outerType = this.getDeclaringType();
        IType type = null;
        try {
            type = outerType.createType(source, sibling, false, this.getTargetContext().getProgressMonitor());
        }
        catch (JavaModelException exc) {
            throw new GenerationException(this.getExceptionIndicator(exc), (Exception)((Object)exc));
        }
        return type;
    }

    private String getExceptionIndicator(JavaModelException e) {
        StringBuffer b = new StringBuffer();
        try {
            b.append(this.getName());
            b.append(" :: ");
        }
        catch (GenerationException generationException) {
            // empty catch block
        }
        b.append(e.getMessage());
        return b.toString();
    }

    protected MergeResults dispatchToMergeStrategy(JavaMemberHistoryDescriptor typeHistory, IDOMType newType) throws GenerationException {
        return this.getCompilationUnitGenerator().getMergeStrategy().merge(typeHistory, newType);
    }

    @Override
    void generateTarget(IJavaElement sibling, MergeResults mr) throws GenerationException {
        IType type = null;
        type = this.isInner() ? this.createTypeInType(mr.getSource(), sibling) : this.createTypeInCU(mr.getSource(), sibling);
        this.setTargetElement(type);
    }

    protected void generateType(JavaTypeDescriptor desc, IGenerationBuffer typeBuf, boolean isNew) throws GenerationException {
        if (isNew) {
            typeBuf.append("\n");
        }
        this.appendComment(typeBuf, desc.getComment());
        String temp = this.formatFlags(desc.getFlags());
        if (temp != null && temp.length() > 0) {
            typeBuf.appendWithMargin(temp);
            typeBuf.append(" ");
        } else {
            typeBuf.margin();
        }
        this.primTypeKindDecl(desc, typeBuf);
        typeBuf.append(" {\n");
        this.getBody(typeBuf);
        typeBuf.appendWithMargin("}\n");
    }

    protected String getBody() throws GenerationException {
        return null;
    }

    protected void getBody(IGenerationBuffer bodyBuf) throws GenerationException {
        bodyBuf.indent();
        String body = this.getBody();
        if (body == null) {
            this.runDependents(bodyBuf);
        } else {
            bodyBuf.appendWithMargin(body);
        }
        bodyBuf.unindent();
    }

    @Override
    protected String getComment() throws GenerationException {
        return this.getName() + "\n";
    }

    private ICompilationUnit getCompilationUnit() throws GenerationException {
        return this.getCompilationUnitGenerator().getCompilationUnit();
    }

    @Override
    protected IType getDeclaringType() throws GenerationException {
        IType declType = null;
        if (this.isInner()) {
            declType = super.getDeclaringType();
        }
        return declType;
    }

    @Override
    public JavaTypeGenerator getDeclaringTypeGenerator() throws GenerationException {
        JavaTypeGenerator declTypeGen = null;
        if (this.isInner()) {
            declTypeGen = super.getDeclaringTypeGenerator();
        }
        return declTypeGen;
    }

    @Override
    protected void getMatchingMember(JavaMemberHistoryDescriptor memberHistory) throws GenerationException {
        IType type = null;
        if (this.isInner()) {
            IType declType = this.getDeclaringType();
            if (declType != null) {
                type = declType.getType(memberHistory.getName());
            }
        } else {
            ICompilationUnit cu = this.getCompilationUnit();
            if (cu != null) {
                type = cu.getType(memberHistory.getName());
            }
        }
        if (type != null && type.exists()) {
            memberHistory.setOldMember((IMember)type);
        } else {
            memberHistory.setOldMember(null);
        }
    }

    protected String[] getSuperInterfaceNames() throws GenerationException {
        return null;
    }

    IType getType() throws GenerationException {
        IType type = (IType)this.getTargetElement();
        if (type == null) {
            if (this.isInner()) {
                IType declType = this.getDeclaringType();
                if (declType != null) {
                    type = declType.getType(this.getName().trim());
                }
            } else {
                ICompilationUnit cu = this.getCompilationUnit();
                if (cu != null) {
                    type = cu.getType(this.getName().trim());
                }
            }
            if (type != null && type.exists()) {
                this.setTargetElement(type);
            }
        }
        return (IType)this.getTargetElement();
    }

    public boolean isClass() {
        return false;
    }

    public boolean isCompilationUnitPrepared() throws GenerationException {
        return this.getCompilationUnitGenerator().isPrepared();
    }

    public boolean isInner() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isPrepared() throws GenerationException {
        return this.fPrepared;
    }

    protected void populateTypeDescriptor(JavaTypeDescriptor desc) throws GenerationException {
        super.populateMemberDescriptor(desc);
        desc.setSuperInterfaceNames(this.getSuperInterfaceNames());
    }

    @Override
    public void prepare() throws GenerationException {
        if (!this.fPrepared) {
            if (this.isInner()) {
                if (!this.getDeclaringTypeGenerator().isPrepared()) {
                    this.getDeclaringTypeGenerator().prepare();
                }
            } else if (!this.isCompilationUnitPrepared()) {
                this.prepareCompilationUnit();
            }
            this.setTargetElement(null);
            this.fPrepared = true;
        }
    }

    public void prepareCompilationUnit() throws GenerationException {
        this.getCompilationUnitGenerator().prepare();
    }

    protected abstract void primTypeKindDecl(JavaTypeDescriptor var1, IGenerationBuffer var2);

    @Override
    IMember reaccess(IMember oldMember) throws GenerationException {
        IType result = null;
        if (oldMember != null) {
            if (this.isInner()) {
                IType declType = this.getDeclaringType();
                if (declType != null) {
                    result = declType.getType(oldMember.getElementName());
                }
            } else {
                ICompilationUnit cu = this.getCompilationUnit();
                if (cu != null) {
                    result = cu.getType(oldMember.getElementName());
                }
            }
            if (result != null && !result.exists()) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public void run() throws GenerationException {
        super.run();
        this.getCompilationUnitGenerator().getMergeStrategy().postProcess(this);
        if (this.isNew()) {
            this.formatContents();
        }
    }

    protected void formatContents() throws GenerationException {
        IType type = this.getType();
        if (type != null && !type.isBinary()) {
            try {
                IOpenable openable = this.getType().getOpenable();
                IBuffer buffer = openable.getBuffer();
                if (buffer != null) {
                    String formatted = this.format(buffer.getContents());
                    int start = formatted.indexOf(BEGIN_BRACE);
                    int end = formatted.indexOf(END_BRACE);
                    if (end - start == 1) {
                        buffer.setContents(formatted.substring(0, start + 1));
                        buffer.append("\n");
                        buffer.append(formatted.substring(end));
                    } else {
                        buffer.setContents(formatted);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }
}

