/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.java.codegen;

import com.ibm.etools.j2ee.internal.codegen.GenerationBuffer;
import com.ibm.etools.j2ee.internal.codegen.GenerationException;
import com.ibm.etools.j2ee.internal.codegen.IGenerationBuffer;
import com.ibm.etools.j2ee.internal.java.codegen.JavaGenerationBuffer;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberGenerator;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberHistoryDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMethodDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMethodHistoryDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaParameterDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaParameterListGenerator;
import com.ibm.etools.j2ee.internal.java.codegen.MergeResults;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;

public abstract class JavaMethodGenerator
extends JavaMemberGenerator {
    private static final String WITH_RETURN_TEMPLATE = "%0 %1";
    private static final String THROWS = " throws ";
    private static final String ABSTRACT_METHOD_BODY = ";\n";

    protected void addUserCodePoint(IGenerationBuffer buffer, String codePointName, String content) throws GenerationException {
        ((JavaGenerationBuffer)buffer).addUserCodePoint(codePointName, content, this.getCompilationUnitGenerator().getMergeStrategy());
    }

    @Override
    protected MergeResults calculateMergeResults(JavaMemberHistoryDescriptor memberHistory, JavaMemberDescriptor desc) throws GenerationException {
        return this.calculateMergeResults((JavaMethodHistoryDescriptor)memberHistory, (JavaMethodDescriptor)desc);
    }

    protected MergeResults calculateMergeResults(JavaMethodHistoryDescriptor methodHistory, JavaMethodDescriptor desc) throws GenerationException {
        MergeResults mr;
        String source = null;
        IDOMMethod newMethod = null;
        if (!methodHistory.isDeleteOnly()) {
            IGenerationBuffer methodBuf = this.getGenerationBuffer();
            this.generateMethod(desc, methodBuf, methodHistory.getCollisionMember() == null);
            source = methodBuf.toString();
            newMethod = JavaMethodGenerator.getDOMFactory().createMethod(source);
        }
        if ((mr = this.dispatchToMergeStrategy(methodHistory, newMethod)).isMerged()) {
            source = mr.getSource();
        }
        mr.setSource(source);
        return mr;
    }

    protected final JavaMethodHistoryDescriptor createDefaultHistoryDescriptor(JavaMethodDescriptor desc) throws GenerationException {
        JavaMethodHistoryDescriptor historyDesc = new JavaMethodHistoryDescriptor();
        historyDesc.setName(desc.getName());
        JavaParameterDescriptor[] parmDescs = desc.getParameterDescriptors();
        String[] parmTypes = null;
        if (parmDescs != null && parmDescs.length > 0) {
            parmTypes = new String[parmDescs.length];
            for (int i = 0; i < parmTypes.length; ++i) {
                parmTypes[i] = parmDescs[i].getType();
            }
        }
        historyDesc.setParameterTypes(parmTypes);
        this.getMatchingMember(historyDesc);
        historyDesc.setCollisionMember(historyDesc.getOldMember());
        return historyDesc;
    }

    @Override
    protected JavaMemberHistoryDescriptor createHistoryDescriptor(JavaMemberDescriptor desc) throws GenerationException {
        JavaMethodHistoryDescriptor historyDesc = (JavaMethodHistoryDescriptor)this.getHistoryDescriptor();
        if (historyDesc == null) {
            historyDesc = this.createDefaultHistoryDescriptor((JavaMethodDescriptor)desc);
        } else {
            IType type = this.getDeclaringType();
            if (type != null) {
                this.getMatchingMember(historyDesc);
                if (!historyDesc.isDeleteOnly()) {
                    if (this.doDescriptorsMatch(type, historyDesc, (JavaMethodDescriptor)desc)) {
                        historyDesc.setCollisionMember(historyDesc.getOldMember());
                    } else {
                        historyDesc.setCollisionMember(this.createDefaultHistoryDescriptor((JavaMethodDescriptor)desc).getCollisionMember());
                    }
                }
            }
        }
        return historyDesc;
    }

    @Override
    protected JavaMemberDescriptor createMemberDescriptor() throws GenerationException {
        return this.createMethodDescriptor();
    }

    protected JavaMethodDescriptor createMethodDescriptor() throws GenerationException {
        JavaMethodDescriptor desc = new JavaMethodDescriptor();
        this.populateMethodDescriptor(desc);
        return desc;
    }

    protected MergeResults dispatchToMergeStrategy(JavaMethodHistoryDescriptor methodHistory, IDOMMethod newMethod) throws GenerationException {
        return this.getCompilationUnitGenerator().getMergeStrategy().merge(methodHistory, newMethod);
    }

    protected final boolean doDescriptorsMatch(IType type, JavaMethodHistoryDescriptor historyDesc, JavaMethodDescriptor desc) throws GenerationException {
        boolean doMatch = true;
        if (!historyDesc.getName().equals(desc.getName())) {
            doMatch = false;
        } else {
            int dpLen;
            String[] historyTypes = historyDesc.getParameterTypes();
            int htLen = historyTypes == null ? 0 : historyTypes.length;
            JavaParameterDescriptor[] descParms = desc.getParameterDescriptors();
            int n = dpLen = descParms == null ? 0 : descParms.length;
            if (htLen != dpLen) {
                doMatch = false;
            } else if (historyTypes != null && descParms != null) {
                String historyTypeSig = null;
                String descParmTypeSig = null;
                for (int i = 0; doMatch && i < htLen; doMatch &= this.matchTypeSignatures(type, historyTypeSig, descParmTypeSig), ++i) {
                    historyTypeSig = Signature.createTypeSignature((String)historyTypes[i], (boolean)false);
                    descParmTypeSig = Signature.createTypeSignature((String)descParms[i].getType(), (boolean)false);
                }
            }
        }
        return doMatch;
    }

    protected void generateMethod(JavaMethodDescriptor desc, IGenerationBuffer methodBuf, boolean isNew) throws GenerationException {
        this.appendComment(methodBuf, desc.getComment());
        String flags = this.formatFlags(desc.getFlags());
        if (flags.length() > 0) {
            methodBuf.appendWithMargin(flags);
            methodBuf.append(" ");
        } else {
            methodBuf.margin();
        }
        String template = this.getDeclarationTemplate();
        String[] parms = new String[]{desc.getReturnType(), desc.getName()};
        methodBuf.format(template, parms);
        JavaParameterListGenerator parmsGen = this.getParameterListGenerator();
        parmsGen.initialize(desc.getParameterDescriptors());
        parmsGen.run(methodBuf);
        String[] exceptions = desc.getExceptions();
        if (exceptions != null && exceptions.length > 0) {
            methodBuf.append(THROWS);
            methodBuf.append(exceptions);
        }
        if (this.getDeclaringTypeGenerator().isInterface() || Flags.isAbstract((int)desc.getFlags()) || Flags.isNative((int)desc.getFlags())) {
            methodBuf.append(ABSTRACT_METHOD_BODY);
        } else {
            methodBuf.append(" {\n");
            this.getBody(methodBuf);
            methodBuf.appendWithMargin("}\n");
        }
    }

    @Override
    void generateTarget(IJavaElement sibling, MergeResults mr) throws GenerationException {
        try {
            IMethod method = this.getDeclaringType().createMethod(this.formatIfNecessary(mr.getSource(), 1), sibling, false, this.getTargetContext().getProgressMonitor());
            this.setTargetElement(method);
        }
        catch (JavaModelException exc) {
            throw new GenerationException(this.getExceptionIndicator(exc), (Exception)((Object)exc));
        }
    }

    private String getExceptionIndicator(JavaModelException e) {
        GenerationBuffer b = new GenerationBuffer();
        try {
            b.append(this.getDeclaringTypeGenerator().getName());
            b.append("#");
        }
        catch (GenerationException generationException) {
            // empty catch block
        }
        try {
            b.append(this.getName());
            JavaParameterListGenerator parmsGen = this.getParameterListGenerator();
            parmsGen.initialize(this.getParameterDescriptors());
            parmsGen.run(b);
            b.append(" :: ");
        }
        catch (GenerationException generationException) {
            // empty catch block
        }
        b.append(e.getMessage());
        return b.toString();
    }

    protected String getBody() throws GenerationException {
        return null;
    }

    protected void getBody(IGenerationBuffer bodyBuf) throws GenerationException {
        bodyBuf.indent();
        String body = this.getBody();
        if (body == null) {
            this.runDependents(bodyBuf);
        } else {
            bodyBuf.appendWithMargin(body);
        }
        bodyBuf.unindent();
    }

    @Override
    protected String getComment() throws GenerationException {
        return this.getName() + "\n";
    }

    String getDeclarationTemplate() {
        return WITH_RETURN_TEMPLATE;
    }

    protected String[] getExceptions() throws GenerationException {
        return null;
    }

    @Override
    protected void getMatchingMember(JavaMemberHistoryDescriptor memberHistory) throws GenerationException {
        IType type = this.getDeclaringType();
        if (type != null) {
            String[] parmTypes = ((JavaMethodHistoryDescriptor)memberHistory).getParameterTypes();
            String[] parmSigs = null;
            if (parmTypes != null && parmTypes.length > 0) {
                parmSigs = new String[parmTypes.length];
                for (int i = 0; i < parmSigs.length; ++i) {
                    parmSigs[i] = Signature.createTypeSignature((String)parmTypes[i], (boolean)false);
                }
            }
            IMethod method = type.getMethod(memberHistory.getName(), parmSigs);
            memberHistory.setOldMember(null);
            if (method.exists()) {
                memberHistory.setOldMember((IMember)method);
            } else {
                this.searchForMatchingMethod(type, (JavaMethodHistoryDescriptor)memberHistory, parmSigs);
            }
        } else {
            memberHistory.setOldMember(null);
        }
    }

    protected JavaParameterDescriptor[] getParameterDescriptors() throws GenerationException {
        return null;
    }

    protected JavaParameterListGenerator getParameterListGenerator() {
        return new JavaParameterListGenerator();
    }

    protected String getReturnType() throws GenerationException {
        return null;
    }

    protected boolean matchTypeSignatures(IType type, String signature1, String signature2) throws GenerationException {
        try {
            return JDOMSearchHelper.matchTypeSignatures((IType)type, (String)signature1, (String)signature2, (Map)this.getTargetContext().getNavigator().getDictionary());
        }
        catch (JavaModelException e) {
            throw new GenerationException((Exception)((Object)e));
        }
    }

    protected void populateMethodDescriptor(JavaMethodDescriptor desc) throws GenerationException {
        super.populateMemberDescriptor(desc);
        String temp = this.getReturnType();
        if (temp != null) {
            temp = temp.trim();
        }
        desc.setReturnType(temp);
        desc.setParameterDescriptors(this.getParameterDescriptors());
        desc.setExceptions(this.getExceptions());
    }

    @Override
    IMember reaccess(IMember oldMember) throws GenerationException {
        IMethod result = null;
        if (oldMember != null) {
            IType type = this.getDeclaringType();
            if (type != null) {
                result = this.getDeclaringType().getMethod(oldMember.getElementName(), ((IMethod)oldMember).getParameterTypes());
            }
            if (result != null && !result.exists()) {
                result = null;
            }
        }
        return result;
    }

    protected void searchForMatchingMethod(IType type, JavaMethodHistoryDescriptor historyDesc, String[] parmSigs) throws GenerationException {
        String methodName = historyDesc.getName();
        try {
            IMethod foundMethod = JDOMSearchHelper.searchForMatchingMethod((IType)type, (String)methodName, (String[])parmSigs, (Map)this.getTargetContext().getNavigator().getDictionary());
            historyDesc.setOldMember((IMember)foundMethod);
        }
        catch (JavaModelException exc) {
            throw new GenerationException((Exception)((Object)exc));
        }
    }
}

