/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.java.codegen;

import com.ibm.etools.j2ee.internal.codegen.GenerationException;
import com.ibm.etools.j2ee.internal.codegen.IGenerationBuffer;
import com.ibm.etools.j2ee.internal.java.codegen.JavaFieldDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberGenerator;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberHistoryDescriptor;
import com.ibm.etools.j2ee.internal.java.codegen.MergeResults;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMField;

public abstract class JavaFieldGenerator
extends JavaMemberGenerator {
    private static final String WITH_INIT_TEMPLATE = "%0 %1 = %2;\n";
    private static final String WITHOUT_INIT_TEMPLATE = "%0 %1;\n";

    protected MergeResults calculateMergeResults(JavaMemberHistoryDescriptor fieldHistory, JavaFieldDescriptor desc) throws GenerationException {
        MergeResults mr;
        String source = null;
        IDOMField newField = null;
        if (!fieldHistory.isDeleteOnly()) {
            IGenerationBuffer fieldBuf = this.getGenerationBuffer();
            this.generateField(desc, fieldBuf);
            source = fieldBuf.toString();
            newField = JavaFieldGenerator.getDOMFactory().createField(source);
        }
        if ((mr = this.dispatchToMergeStrategy(fieldHistory, newField)).isMerged()) {
            source = mr.getSource();
        }
        mr.setSource(source);
        return mr;
    }

    @Override
    protected MergeResults calculateMergeResults(JavaMemberHistoryDescriptor memberHistory, JavaMemberDescriptor desc) throws GenerationException {
        return this.calculateMergeResults(memberHistory, (JavaFieldDescriptor)desc);
    }

    protected final JavaMemberHistoryDescriptor createDefaultHistoryDescriptor(JavaMemberDescriptor desc) throws GenerationException {
        JavaMemberHistoryDescriptor historyDesc = new JavaMemberHistoryDescriptor();
        historyDesc.setName(desc.getName());
        this.getMatchingMember(historyDesc);
        historyDesc.setCollisionMember(historyDesc.getOldMember());
        return historyDesc;
    }

    protected JavaFieldDescriptor createFieldDescriptor() throws GenerationException {
        JavaFieldDescriptor desc = new JavaFieldDescriptor();
        this.populateFieldDescriptor(desc);
        return desc;
    }

    @Override
    protected JavaMemberHistoryDescriptor createHistoryDescriptor(JavaMemberDescriptor desc) throws GenerationException {
        JavaMemberHistoryDescriptor historyDesc = this.getHistoryDescriptor();
        if (historyDesc == null) {
            historyDesc = this.createDefaultHistoryDescriptor(desc);
        } else {
            this.getMatchingMember(historyDesc);
            if (!historyDesc.isDeleteOnly()) {
                if (historyDesc.getName().equals(desc.getName())) {
                    historyDesc.setCollisionMember(historyDesc.getOldMember());
                } else {
                    historyDesc.setCollisionMember(this.createDefaultHistoryDescriptor(desc).getCollisionMember());
                }
            }
        }
        return historyDesc;
    }

    @Override
    protected JavaMemberDescriptor createMemberDescriptor() throws GenerationException {
        return this.createFieldDescriptor();
    }

    @Override
    protected int deriveFlags() throws GenerationException {
        return 2;
    }

    protected MergeResults dispatchToMergeStrategy(JavaMemberHistoryDescriptor fieldHistory, IDOMField newField) throws GenerationException {
        return this.getCompilationUnitGenerator().getMergeStrategy().merge(fieldHistory, newField);
    }

    protected void generateField(JavaFieldDescriptor desc, IGenerationBuffer fieldBuf) throws GenerationException {
        this.appendComment(fieldBuf, desc.getComment());
        String flags = this.formatFlags(desc.getFlags());
        if (flags.length() > 0) {
            fieldBuf.appendWithMargin(flags);
            fieldBuf.append(" ");
        } else {
            fieldBuf.margin();
        }
        String template = null;
        String fieldInitializer = desc.getInitializer();
        template = fieldInitializer != null && fieldInitializer.length() > 0 ? WITH_INIT_TEMPLATE : WITHOUT_INIT_TEMPLATE;
        String[] parms = new String[]{desc.getType(), desc.getName(), fieldInitializer};
        fieldBuf.format(template, parms);
    }

    @Override
    void generateTarget(IJavaElement sibling, MergeResults mr) throws GenerationException {
        try {
            IField field = this.getDeclaringType().createField(this.formatIfNecessary(mr.getSource(), 1), sibling, false, this.getTargetContext().getProgressMonitor());
            this.setTargetElement(field);
        }
        catch (JavaModelException exc) {
            throw new GenerationException(this.getExceptionIndicator(exc), (Exception)((Object)exc));
        }
    }

    private String getExceptionIndicator(JavaModelException e) {
        StringBuffer b = new StringBuffer();
        try {
            b.append(this.getDeclaringTypeGenerator().getName());
            b.append("#");
        }
        catch (GenerationException generationException) {
            // empty catch block
        }
        try {
            b.append(this.getName());
            b.append(" :: ");
        }
        catch (GenerationException generationException) {
            // empty catch block
        }
        b.append(e.getMessage());
        return b.toString();
    }

    protected String getInitializer() throws GenerationException {
        return null;
    }

    @Override
    protected void getMatchingMember(JavaMemberHistoryDescriptor memberHistory) throws GenerationException {
        IType declType = this.getDeclaringType();
        IField field = null;
        if (declType != null) {
            field = declType.getField(memberHistory.getName());
        }
        if (field != null && field.exists()) {
            memberHistory.setOldMember((IMember)field);
        } else {
            memberHistory.setOldMember(null);
        }
    }

    @Override
    protected IJavaElement getNextSibling(IMember sibling) throws GenerationException {
        IJavaElement nextSibling = null;
        if (sibling != null) {
            nextSibling = super.getNextSibling(sibling);
        } else {
            try {
                IType declType = this.getDeclaringType();
                IField[] fields = declType.getFields();
                if (fields != null && fields.length > 0) {
                    nextSibling = super.getNextSibling((IMember)fields[fields.length - 1]);
                } else {
                    IJavaElement[] members = declType.getChildren();
                    if (members != null && members.length > 0) {
                        nextSibling = members[0];
                    }
                }
            }
            catch (JavaModelException exc) {
                throw new GenerationException((Exception)((Object)exc));
            }
        }
        return nextSibling;
    }

    protected abstract String getType() throws GenerationException;

    protected void populateFieldDescriptor(JavaFieldDescriptor desc) throws GenerationException {
        super.populateMemberDescriptor(desc);
        String temp = this.getType();
        if (temp != null) {
            temp = temp.trim();
        }
        desc.setType(temp);
        temp = this.getInitializer();
        if (temp != null) {
            temp = temp.trim();
        }
        desc.setInitializer(temp);
    }

    @Override
    IMember reaccess(IMember oldMember) throws GenerationException {
        IField result = null;
        if (oldMember != null) {
            IType type = this.getDeclaringType();
            if (type != null) {
                result = this.getDeclaringType().getField(oldMember.getElementName());
            }
            if (result != null && !result.exists()) {
                result = null;
            }
        }
        return result;
    }
}

