/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.codegen;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.internal.codegen.Generator;
import com.ibm.etools.j2ee.internal.codegen.GeneratorDictionaryEntry;
import com.ibm.etools.j2ee.internal.codegen.GeneratorNotFoundException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.j2ee.internal.xml.GeneralXmlDocumentReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class GeneratorDictionary {
    private Map fDictionary = new HashMap();
    private ClassLoader classLoader;
    private static final String PATH_SEPARATOR = "/";
    private static final String CODEGEN_DICT_NODE_NAME = "CodegenDictionary";
    private static final String INCLUDE_NODE_NAME = "include";
    private static final String HREF_NODE_NAME = "href";
    private static final String GENERATOR_NODE_NAME = "generator";
    private static final String GENERATOR_NAME_ITEM_NAME = "name";
    private static final String GENERATOR_CODE_ITEM_NAME = "code";
    private static final String TEXT_NODE_NAME = "#text";
    private static final String COMMENT_NODE_NAME = "#comment";

    public GeneratorDictionary(String dictionaryName, ClassLoader loader) throws FileNotFoundException {
        this.classLoader = loader;
        this.parseFile(dictionaryName);
    }

    public Generator get(String logicalName) throws GeneratorNotFoundException {
        Generator result = null;
        try {
            Class genClass = ((GeneratorDictionaryEntry)this.fDictionary.get(logicalName)).getGenClass(this.classLoader);
            result = (Generator)genClass.newInstance();
        }
        catch (Exception x) {
            throw new GeneratorNotFoundException(logicalName);
        }
        return result;
    }

    private void parseFile(String filename) throws FileNotFoundException {
        InputStream is = this.classLoader.getResourceAsStream(filename);
        if (is == null) {
            is = this.classLoader.getResourceAsStream(PATH_SEPARATOR + filename);
        }
        if (is == null) {
            is = new FileInputStream(filename);
        }
        try {
            GeneralXmlDocumentReader reader = new GeneralXmlDocumentReader();
            reader.setInputSource(new InputSource(is));
            Element root = reader.getDocument().getDocumentElement();
            NodeList elements = root.getChildNodes();
            for (int i = 0; i < elements.getLength(); ++i) {
                NamedNodeMap map;
                Node node = elements.item(i);
                if (node.getNodeName().equalsIgnoreCase(CODEGEN_DICT_NODE_NAME)) {
                    this.processDictionary(node.getChildNodes());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase(INCLUDE_NODE_NAME)) {
                    map = node.getAttributes();
                    Node filenode = map.getNamedItem(HREF_NODE_NAME);
                    String nestedFile = filenode.getNodeValue();
                    this.parseFile(nestedFile);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase(GENERATOR_NODE_NAME)) {
                    map = node.getAttributes();
                    String generatorName = map.getNamedItem(GENERATOR_NAME_ITEM_NAME).getNodeValue();
                    String generatorCode = map.getNamedItem(GENERATOR_CODE_ITEM_NAME).getNodeValue();
                    this.fDictionary.put(generatorName, new GeneratorDictionaryEntry(generatorCode));
                    continue;
                }
                if (!node.getNodeName().equals(TEXT_NODE_NAME) && !node.getNodeName().equals(COMMENT_NODE_NAME)) continue;
            }
        }
        catch (Exception x) {
            J2eePlugin.logError(x);
            throw new FileNotFoundException(filename);
        }
    }

    private void processDictionary(NodeList elements) {
    }
}

