/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.codegen;

import com.ibm.etools.j2ee.internal.codegen.IGenerationBuffer;
import java.util.Iterator;
import java.util.List;

public class GenerationBuffer
implements IGenerationBuffer {
    private StringBuffer fBuffer = null;
    private StringBuffer fCurrentMargin = null;
    private String fIndentString = "\t";
    private int fIndentCount = 0;
    private char fFormatParmMarker = (char)37;

    @Override
    public void append(String[] strings) {
        if (strings != null && strings.length > 0) {
            for (int i = 0; i < strings.length; ++i) {
                this.append(strings[i]);
                if (i >= strings.length - 1) continue;
                this.append(", ");
            }
        }
    }

    @Override
    public void append(String aString) {
        if (aString != null && aString.length() > 0) {
            this.getBuffer().append(aString);
        }
    }

    @Override
    public void append(List strings) {
        if (strings != null) {
            Iterator stringsIter = strings.iterator();
            while (stringsIter.hasNext()) {
                this.append(stringsIter.next().toString());
                if (!stringsIter.hasNext()) continue;
                this.append(", ");
            }
        }
    }

    @Override
    public void appendWithMargin(String aString) {
        this.appendWithMargin(aString, true);
    }

    @Override
    public void appendWithMargin(String aString, boolean startMargin) {
        if (aString != null && aString.length() > 0) {
            StringBuffer buffer = this.getBuffer();
            buffer.ensureCapacity(buffer.length() + aString.length() + 50);
            if (startMargin) {
                this.margin();
            }
            int sourceLength = aString.length();
            boolean inLineBreak = false;
            for (int i = 0; i < sourceLength; ++i) {
                char current = aString.charAt(i);
                if (current == '\r' || current == '\n') {
                    inLineBreak = true;
                } else if (inLineBreak) {
                    this.margin();
                    inLineBreak = false;
                }
                buffer.append(current);
            }
        }
    }

    @Override
    public void appendWithMarginAndPrefix(String aString, String prefix) {
        this.appendWithMarginAndPrefix(aString, prefix, true);
    }

    @Override
    public void appendWithMarginAndPrefix(String aString, String prefix, boolean startMargin) {
        if (aString != null && aString.length() > 0) {
            StringBuffer buffer = this.getBuffer();
            buffer.ensureCapacity(buffer.length() + aString.length() + 50);
            if (startMargin) {
                this.margin();
                this.append(prefix);
            }
            int sourceLength = aString.length();
            boolean inLineBreak = false;
            for (int i = 0; i < sourceLength; ++i) {
                char current = aString.charAt(i);
                if (current == '\r' || current == '\n') {
                    inLineBreak = true;
                } else if (inLineBreak) {
                    this.margin();
                    this.append(prefix);
                    inLineBreak = false;
                }
                buffer.append(current);
            }
        }
    }

    @Override
    public void format(String format, String[] parms) {
        if (format != null && format.length() > 0) {
            StringBuffer buffer = this.getBuffer();
            buffer.ensureCapacity(buffer.length() + format.length() + 20 * parms.length);
            int formatLen = format.length();
            int formatPos = 0;
            char parmMarker = this.getFormatParmMarker();
            boolean inParm = false;
            StringBuffer parmNumber = new StringBuffer();
            while (formatPos < formatLen) {
                char formatChar = format.charAt(formatPos);
                ++formatPos;
                if (inParm) {
                    if (parmNumber.length() == 0 && !Character.isDigit(formatChar)) {
                        inParm = false;
                        buffer.append(parmMarker);
                        if (formatChar == parmMarker) continue;
                        buffer.append(formatChar);
                        continue;
                    }
                    if (Character.isDigit(formatChar)) {
                        parmNumber.append(formatChar);
                        if (formatPos != formatLen) continue;
                        this.append(parms[Integer.parseInt(parmNumber.toString())]);
                        continue;
                    }
                    this.append(parms[Integer.parseInt(parmNumber.toString())]);
                    parmNumber.setLength(0);
                    inParm = false;
                    --formatPos;
                    continue;
                }
                if (formatChar == parmMarker && formatPos < formatLen) {
                    inParm = true;
                    continue;
                }
                buffer.append(formatChar);
            }
        }
    }

    @Override
    public void format(String format, List parms) {
        String[] stringParms = new String[parms.size()];
        Iterator parmsIter = parms.iterator();
        int i = 0;
        while (parmsIter.hasNext()) {
            stringParms[i] = parmsIter.next().toString();
            ++i;
        }
        this.format(format, stringParms);
    }

    @Override
    public void formatWithMargin(String format, String[] parms) {
        this.formatWithMargin(format, parms, true);
    }

    @Override
    public void formatWithMargin(String format, String[] parms, boolean startMargin) {
        if (format != null && format.length() > 0) {
            StringBuffer buffer = this.getBuffer();
            buffer.ensureCapacity(buffer.length() + format.length() + 20 * parms.length);
            if (startMargin) {
                this.margin();
            }
            int formatLen = format.length();
            int formatPos = 0;
            char parmMarker = this.getFormatParmMarker();
            boolean inParm = false;
            StringBuffer parmNumber = new StringBuffer();
            boolean inLineBreak = false;
            while (formatPos < formatLen) {
                char formatChar = format.charAt(formatPos);
                ++formatPos;
                if (formatChar == '\r' || formatChar == '\n') {
                    inLineBreak = true;
                } else if (inLineBreak) {
                    this.margin();
                    inLineBreak = false;
                }
                if (inParm) {
                    if (parmNumber.length() == 0 && !Character.isDigit(formatChar)) {
                        inParm = false;
                        buffer.append(parmMarker);
                        if (formatChar == parmMarker) continue;
                        buffer.append(formatChar);
                        continue;
                    }
                    if (Character.isDigit(formatChar)) {
                        parmNumber.append(formatChar);
                        if (formatPos != formatLen) continue;
                        this.append(parms[Integer.parseInt(parmNumber.toString())]);
                        continue;
                    }
                    this.appendWithMargin(parms[Integer.parseInt(parmNumber.toString())], false);
                    parmNumber.setLength(0);
                    inParm = false;
                    --formatPos;
                    continue;
                }
                if (formatChar == parmMarker && formatPos < formatLen) {
                    inParm = true;
                    continue;
                }
                buffer.append(formatChar);
            }
        }
    }

    @Override
    public void formatWithMargin(String format, List parms) {
        this.formatWithMargin(format, parms, true);
    }

    @Override
    public void formatWithMargin(String format, List parms, boolean startMargin) {
        String[] stringParms = new String[parms.size()];
        Iterator parmsIter = parms.iterator();
        int i = 0;
        while (parmsIter.hasNext()) {
            stringParms[i] = parmsIter.next().toString();
            ++i;
        }
        this.formatWithMargin(format, stringParms, startMargin);
    }

    protected StringBuffer getBuffer() {
        if (this.fBuffer == null) {
            this.fBuffer = new StringBuffer(200);
        }
        return this.fBuffer;
    }

    protected StringBuffer getCurrentMargin() {
        if (this.fCurrentMargin == null) {
            this.fCurrentMargin = new StringBuffer();
            for (int i = 0; i < this.fIndentCount; ++i) {
                this.fCurrentMargin.append(this.fIndentString);
            }
        }
        return this.fCurrentMargin;
    }

    @Override
    public char getFormatParmMarker() {
        return this.fFormatParmMarker;
    }

    @Override
    public void indent() {
        this.getCurrentMargin().append(this.fIndentString);
        ++this.fIndentCount;
    }

    @Override
    public void margin() {
        if (this.fIndentCount > 0) {
            if (this.fIndentCount == 1) {
                this.append(this.fIndentString);
            } else {
                this.append(this.getCurrentMargin().toString());
            }
        }
    }

    @Override
    public void setFormatParmMarker(char newFormatParmMarker) {
        this.fFormatParmMarker = newFormatParmMarker;
    }

    @Override
    public void setIndent(int indentCount) {
        int setCount;
        int n = setCount = indentCount > 0 ? indentCount : 0;
        if (setCount != this.fIndentCount) {
            this.fIndentCount = setCount;
            this.fCurrentMargin = null;
        }
    }

    public String toString() {
        return this.getBuffer().toString();
    }

    @Override
    public void unindent() {
        if (this.fIndentCount > 0) {
            --this.fIndentCount;
            this.fCurrentMargin = null;
        }
    }
}

