/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.codegen;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.internal.codegen.DictionaryExtensionReader;
import com.ibm.etools.j2ee.internal.codegen.GeneratorDictionary;
import com.ibm.etools.j2ee.internal.codegen.GeneratorDictionaryLookUp;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DictionaryExtensionRegistry {
    static final String GROUP_ID = "groupID";
    static final String BASE_DICTIONARY = "baseDictionary";
    static final String EXTENSION_DICTIONARY = "extensionDictionary";
    private static DictionaryExtensionReader reader = null;
    private static HashMap dictionaryExtMap = null;
    private static boolean extPointHasRead = false;

    public static GeneratorDictionary generateDictionary(String xmlDictionaryName, ClassLoader loader) throws FileNotFoundException {
        dictionaryExtMap = DictionaryExtensionRegistry.getDictionaryExtensions();
        if (dictionaryExtMap == null) {
            return new GeneratorDictionary(xmlDictionaryName, loader);
        }
        List extensionsList = (List)dictionaryExtMap.get(xmlDictionaryName);
        if (extensionsList == null) {
            return new GeneratorDictionary(xmlDictionaryName, loader);
        }
        GeneratorDictionaryLookUp lookUp = new GeneratorDictionaryLookUp(xmlDictionaryName, loader);
        for (int i = 0; i < extensionsList.size(); ++i) {
            IConfigurationElement configElement = (IConfigurationElement)extensionsList.get(i);
            String groupID = configElement.getAttribute(GROUP_ID);
            String extDictionary = configElement.getAttribute(EXTENSION_DICTIONARY);
            String namespace = configElement.getDeclaringExtension().getNamespaceIdentifier();
            Bundle plugin = Platform.getBundle((String)namespace);
            String bundleActivator = (String)plugin.getHeaders().get("Bundle-Activator");
            try {
                if (bundleActivator != null) {
                    ClassLoader extLoader = plugin.loadClass(bundleActivator).getClassLoader();
                    lookUp.addDictionaryExtension(extDictionary, extLoader, groupID);
                    continue;
                }
                J2eePlugin.logError("DictionaryExtensionRegistry.generateDictionary: Bundle activator is null");
                continue;
            }
            catch (ClassNotFoundException e) {
                J2eePlugin.logError(e);
            }
        }
        return lookUp;
    }

    private static HashMap getDictionaryExtensions() {
        if (!extPointHasRead) {
            reader = new DictionaryExtensionReader();
            reader.readRegistry();
            extPointHasRead = true;
        }
        if (reader != null) {
            return DictionaryExtensionReader.getDictionaryExtensions();
        }
        return null;
    }
}

