/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.codegen;

import com.ibm.etools.j2ee.internal.codegen.AnalysisResult;
import com.ibm.etools.j2ee.internal.codegen.DependentGenerator;
import com.ibm.etools.j2ee.internal.codegen.DictionaryExtensionRegistry;
import com.ibm.etools.j2ee.internal.codegen.GenerationException;
import com.ibm.etools.j2ee.internal.codegen.Generator;
import com.ibm.etools.j2ee.internal.codegen.GeneratorDictionary;
import com.ibm.etools.j2ee.internal.codegen.GeneratorNotFoundException;
import com.ibm.etools.j2ee.internal.codegen.IBaseGenerator;
import com.ibm.etools.j2ee.internal.codegen.IDependentGenerator;
import com.ibm.etools.j2ee.internal.codegen.IGenerationBuffer;
import com.ibm.etools.j2ee.internal.codegen.ITargetContext;
import com.ibm.etools.j2ee.internal.codegen.TopLevelGenerationHelper;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseGenerator
extends Generator
implements IBaseGenerator {
    private static Map generatorDictionaryMap;
    private IBaseGenerator fParentGenerator = null;
    private List fChildren = null;
    private ITargetContext fTargetContext = null;
    private Object fTargetElement = null;
    private AnalysisResult fAnalysisResult = null;

    @Override
    public void addChild(IBaseGenerator child) {
        this.getChildren().add(child);
    }

    @Override
    public AnalysisResult analyze() throws GenerationException {
        return this.primAnalyze();
    }

    protected void analyzeChildren(AnalysisResult result) throws GenerationException {
        Iterator childGenIter = this.getChildren().iterator();
        while (childGenIter.hasNext()) {
            result.addChildResult(((IBaseGenerator)childGenIter.next()).analyze());
        }
    }

    private void buildDebugString(StringBuffer buffer, int indent) {
        try {
            for (int i = 0; i < indent; ++i) {
                buffer.append("  ");
            }
            buffer.append(this.getClass().getName());
            String name = this.getName();
            if (name != null) {
                buffer.append(" (");
                buffer.append(name);
                buffer.append(")");
            }
            buffer.append("\n");
            List children = this.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                BaseGenerator child = (BaseGenerator)children.get(i);
                child.buildDebugString(buffer, indent + 1);
            }
        }
        catch (GenerationException generationException) {
            // empty catch block
        }
    }

    @Override
    public void discardDependents() throws GenerationException {
        Iterator dependentChildGenIter = this.getDependentChildren().iterator();
        while (dependentChildGenIter.hasNext()) {
            ((IDependentGenerator)dependentChildGenIter.next()).terminate();
        }
        this.getDependentChildren().clear();
    }

    protected AnalysisResult getAnalysisResult() {
        return this.fAnalysisResult;
    }

    @Override
    public List getChildren() {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        return this.fChildren;
    }

    @Override
    public IDependentGenerator getDependentGenerator(String logicalName) throws GeneratorNotFoundException {
        DependentGenerator genImplInstance;
        try {
            genImplInstance = (DependentGenerator)super.getDependentGenerator(logicalName);
            genImplInstance.setBaseAncestor(this);
        }
        catch (Exception x) {
            throw new GeneratorNotFoundException(logicalName);
        }
        return genImplInstance;
    }

    @Override
    public IBaseGenerator getGenerator(String logicalName) throws GeneratorNotFoundException {
        BaseGenerator genImplInstance;
        try {
            genImplInstance = (BaseGenerator)this.getGeneratorImpl(logicalName);
            genImplInstance.fParentGenerator = this;
            this.addChild(genImplInstance);
            genImplInstance.fTargetContext = this.getTargetContext();
        }
        catch (Exception x) {
            throw new GeneratorNotFoundException(logicalName);
        }
        return genImplInstance;
    }

    public static IBaseGenerator getGenerator(String xmlDictionaryName, String logicalName) throws GeneratorNotFoundException {
        return BaseGenerator.getGenerator(xmlDictionaryName, logicalName, BaseGenerator.class, null);
    }

    public static IBaseGenerator getGenerator(String xmlDictionaryName, String logicalName, TopLevelGenerationHelper helper) throws GeneratorNotFoundException {
        return BaseGenerator.getGenerator(xmlDictionaryName, logicalName, BaseGenerator.class, helper);
    }

    public static IBaseGenerator getGenerator(String xmlDictionaryName, String logicalName, Class cls) throws GeneratorNotFoundException {
        return BaseGenerator.getGenerator(xmlDictionaryName, logicalName, cls, null);
    }

    public static IBaseGenerator getGenerator(String xmlDictionaryName, String logicalName, Class cls, TopLevelGenerationHelper helper) throws GeneratorNotFoundException {
        try {
            GeneratorDictionary xmlDictionary = BaseGenerator.getGeneratorDictionary(xmlDictionaryName, cls);
            return (IBaseGenerator)((Object)BaseGenerator.getGeneratorImpl(logicalName, xmlDictionary, helper));
        }
        catch (FileNotFoundException x) {
            throw new GeneratorNotFoundException(x.getMessage());
        }
    }

    protected static GeneratorDictionary getGeneratorDictionary(String xmlDictionaryName, Class cls) throws FileNotFoundException {
        GeneratorDictionary dictionary = null;
        if (xmlDictionaryName != null && cls != null) {
            ClassLoader loader = cls.getClassLoader();
            String key = loader.hashCode() + "#" + xmlDictionaryName;
            if (generatorDictionaryMap == null) {
                generatorDictionaryMap = new HashMap();
            }
            if ((dictionary = (GeneratorDictionary)generatorDictionaryMap.get(key)) == null) {
                dictionary = DictionaryExtensionRegistry.generateDictionary(xmlDictionaryName, loader);
                generatorDictionaryMap.put(key, dictionary);
            }
        }
        return dictionary;
    }

    protected String getName() throws GenerationException {
        return null;
    }

    @Override
    public IBaseGenerator getParent() {
        return this.fParentGenerator;
    }

    @Override
    public ITargetContext getTargetContext() {
        if (this.fTargetContext == null) {
            this.fTargetContext = this.createTargetContext();
        }
        return this.fTargetContext;
    }

    @Override
    public Object getTargetElement() {
        return this.fTargetElement;
    }

    protected AnalysisResult primAnalyze() throws GenerationException {
        AnalysisResult result = this.fAnalysisResult != null ? this.fAnalysisResult : new AnalysisResult();
        this.analyzeChildren(result);
        if (result.getChildResults().size() > 0) {
            this.fAnalysisResult = result;
        }
        return this.fAnalysisResult;
    }

    @Override
    public void run() throws GenerationException {
        this.runChildren();
    }

    protected void runChildren() throws GenerationException {
        Iterator childGenIter = this.getChildren().iterator();
        while (childGenIter.hasNext()) {
            ((IBaseGenerator)childGenIter.next()).run();
        }
    }

    @Override
    public void runDependents(IGenerationBuffer buffer) throws GenerationException {
        Iterator dependentChildGenIter = this.getDependentChildren().iterator();
        while (dependentChildGenIter.hasNext()) {
            ((IDependentGenerator)dependentChildGenIter.next()).run(buffer);
        }
    }

    protected void setAnalysisResult(AnalysisResult newAnalysisResult) {
        this.fAnalysisResult = newAnalysisResult;
    }

    @Override
    public void setTargetElement(Object targetElement) {
        this.fTargetElement = targetElement;
    }

    @Override
    public void terminate() throws GenerationException {
        if (this.fChildren != null) {
            Iterator childGenIter = this.fChildren.iterator();
            while (childGenIter.hasNext()) {
                ((IBaseGenerator)childGenIter.next()).terminate();
            }
            this.fChildren.clear();
            this.fChildren = null;
        }
        this.fParentGenerator = null;
        this.fTargetContext = null;
        this.fTargetElement = null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.buildDebugString(buffer, 0);
        return buffer.toString();
    }
}

