/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.common.operations.NewJavaClassDataModel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.operations.JavaModelUtil;

public class NewJavaClassOperation
extends WTPOperation {
    protected static final String EMPTY_STRING = "";
    protected static final String TAB = "\t";
    protected static final String SPACE = " ";
    protected static final String DOT = ".";
    protected static final String COMMA = ",";
    protected static final String SEMICOLON = ";";
    protected static final String POUND = "#";
    protected static final String OPEN_PAR = "(";
    protected static final String CLOSE_PAR = ")";
    protected static final String OPEN_BRA = "{";
    protected static final String CLOSE_BRA = "}";
    protected static final String lineSeparator = System.getProperty("line.separator");
    protected static final String JAVA_LANG_OBJECT = "java.lang.Object";
    protected static final String PACKAGE = "package ";
    protected static final String CLASS = "class ";
    protected static final String IMPORT = "import ";
    protected static final String EXTENDS = "extends ";
    protected static final String IMPLEMENTS = "implements ";
    protected static final String THROWS = "throws ";
    protected static final String SUPER = "super";
    protected static final String PUBLIC = "public ";
    protected static final String PROTECTED = "protected ";
    protected static final String PRIVATE = "private ";
    protected static final String STATIC = "static ";
    protected static final String ABSTRACT = "abstract ";
    protected static final String FINAL = "final ";
    protected static final String VOID = "void";
    protected static final String INT = "int";
    protected static final String BOOLEAN = "boolean";
    protected static final String MAIN_METHOD = "\tpublic static void main(String[] args) {";
    protected static final String TODO_COMMENT = "\t\t// TODO Auto-generated method stub";
    protected static final String RETURN_NULL = "\t\treturn null;";
    protected static final String RETURN_0 = "\t\treturn 0;";
    protected static final String RETURN_FALSE = "\t\treturn false;";
    private List importStatements = new ArrayList();

    public NewJavaClassOperation(WTPOperationDataModel dataModel) {
        super(dataModel);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IFolder sourceFolder = this.createJavaSourceFolder();
        IPackageFragment pack = this.createJavaPackage();
        this.createJavaFile(sourceFolder, pack);
    }

    protected final IFolder createJavaSourceFolder() {
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        String folderFullPath = model.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder folder = root.getFolder((IPath)new Path(folderFullPath));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                J2eePlugin.logError(e);
            }
        }
        return folder;
    }

    protected final IPackageFragment createJavaPackage() {
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        String packageName = model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        IPackageFragmentRoot packRoot = model.getJavaPackageFragmentRoot();
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment(EMPTY_STRING);
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                J2eePlugin.logError((CoreException)((Object)e));
            }
        }
        return pack;
    }

    protected void createJavaFile(IFolder sourceFolder, IPackageFragment pack) {
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        String packageName = model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        String className = model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        String fileName = className + ".java";
        try {
            String content = this.getJavaFileContent(pack, className);
            pack.createCompilationUnit(fileName, content, true, null);
            byte[] contentBytes = content.getBytes();
            Path packageFullPath = new Path(packageName.replace('.', '/'));
            IPath javaFileFullPath = packageFullPath.append(fileName);
            IFile file = sourceFolder.getFile(javaFileFullPath);
            if (file != null && file.exists()) {
                file.setContents((InputStream)new ByteArrayInputStream(contentBytes), false, true, null);
            } else if (file != null) {
                file.create((InputStream)new ByteArrayInputStream(contentBytes), false, null);
            }
        }
        catch (Exception ex) {
            J2eePlugin.logError(ex);
        }
    }

    private String getJavaFileContent(IPackageFragment pack, String className) {
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        String superclassName = model.getStringProperty("NewJavaClassDataModel.SUPERCLASS");
        List interfaces = (List)model.getProperty("NewJavaClassDataModel.INTERFACES");
        String packageStatement = this.getPackageStatement(pack);
        this.setupImportStatements(pack, superclassName, interfaces);
        String classDeclaration = this.getClassDeclaration(superclassName, className, interfaces);
        String fields = this.getFields();
        String methods = this.getMethodStubs(superclassName, className);
        StringBuffer contents = new StringBuffer();
        contents.append(packageStatement);
        for (int i = 0; i < this.importStatements.size(); ++i) {
            contents.append(IMPORT + String.valueOf(this.importStatements.get(i)) + SEMICOLON);
            contents.append(lineSeparator);
        }
        contents.append(lineSeparator);
        contents.append(classDeclaration);
        contents.append(fields);
        contents.append(methods);
        contents.append(CLOSE_BRA);
        return contents.toString();
    }

    private String getPackageStatement(IPackageFragment pack) {
        StringBuffer sb = new StringBuffer();
        if (!pack.isDefaultPackage()) {
            sb.append(PACKAGE + pack.getElementName() + SEMICOLON);
            sb.append(lineSeparator);
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private boolean isSamePackage(IPackageFragment packageFragment, String className) {
        if (className != null && className.length() > 0) {
            String sPackageName = packageFragment.getElementName();
            String classPackageName = Signature.getQualifier((String)className);
            if (classPackageName.equals(sPackageName)) {
                return true;
            }
        }
        return false;
    }

    private void setupImportStatements(IPackageFragment pack, String superclassName, List interfaces) {
        if (superclassName != null && superclassName.length() > 0 && !superclassName.equals(JAVA_LANG_OBJECT) && !this.isSamePackage(pack, superclassName)) {
            this.importStatements.add(superclassName);
        }
        if (interfaces != null && interfaces.size() > 0) {
            int size = interfaces.size();
            for (int i = 0; i < size; ++i) {
                String interfaceName = (String)interfaces.get(i);
                if (interfaceName.equals(JAVA_LANG_OBJECT) || this.isSamePackage(pack, interfaceName)) continue;
                this.importStatements.add(interfaceName);
            }
        }
    }

    private String getClassDeclaration(String superclassName, String className, List interfaces) {
        StringBuffer sb = new StringBuffer();
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        if (model.getBooleanProperty("NewJavaClassDataModel.MODIFIER_PUBLIC")) {
            sb.append(PUBLIC);
        }
        if (model.getBooleanProperty("NewJavaClassDataModel.MODIFIER_ABSTRACT")) {
            sb.append(ABSTRACT);
        }
        if (model.getBooleanProperty("NewJavaClassDataModel.MODIFIER_FINAL")) {
            sb.append(FINAL);
        }
        sb.append(CLASS);
        sb.append(className + SPACE);
        if (superclassName != null && superclassName.length() > 0 && !superclassName.equals(JAVA_LANG_OBJECT)) {
            int index = superclassName.lastIndexOf(DOT);
            if (index != -1) {
                superclassName = superclassName.substring(index + 1);
            }
            sb.append(EXTENDS + superclassName + SPACE);
        }
        if (interfaces != null && interfaces.size() > 0) {
            sb.append(IMPLEMENTS);
            int size = interfaces.size();
            for (int i = 0; i < size; ++i) {
                String interfaceName = (String)interfaces.get(i);
                int index = interfaceName.lastIndexOf(DOT);
                if (index != -1) {
                    interfaceName = interfaceName.substring(index + 1);
                }
                sb.append(interfaceName);
                if (i < size - 1) {
                    sb.append(COMMA);
                }
                sb.append(SPACE);
            }
        }
        sb.append(OPEN_BRA);
        sb.append(lineSeparator);
        return sb.toString();
    }

    protected String getFields() {
        return EMPTY_STRING;
    }

    private String getMethodStubs(String superclassName, String className) {
        String userDefined;
        StringBuffer sb = new StringBuffer();
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        IProject project = model.getTargetProject();
        IJavaProject javaProj = JemProjectUtilities.getJavaProject((IProject)project);
        if (model.getBooleanProperty("NewJavaClassDataModel.MAIN_METHOD")) {
            sb.append(MAIN_METHOD);
            sb.append(lineSeparator);
            sb.append(TODO_COMMENT);
            sb.append(lineSeparator);
            sb.append("\t}");
            sb.append(lineSeparator);
            sb.append(lineSeparator);
        }
        IType superClassType = null;
        if (model.getBooleanProperty("NewJavaClassDataModel.CONSTRUCTOR") || model.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS")) {
            try {
                superClassType = javaProj.findType(superclassName);
            }
            catch (JavaModelException e) {
                J2eePlugin.logError((CoreException)((Object)e));
            }
        }
        if (model.getBooleanProperty("NewJavaClassDataModel.CONSTRUCTOR")) {
            try {
                if (superClassType != null) {
                    IMethod[] methods = superClassType.getMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        if (!methods[j].isConstructor() || Flags.isPrivate((int)methods[j].getFlags()) || this.hasGenericParams(methods[j])) continue;
                        String methodStub = this.getMethodStub(methods[j], superclassName, className);
                        sb.append(methodStub);
                    }
                }
            }
            catch (JavaModelException e) {
                J2eePlugin.logError((CoreException)((Object)e));
            }
        }
        if (model.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS") && superClassType != null) {
            String methodStub = this.getUnimplementedMethodsFromSuperclass(superClassType, className);
            if (methodStub != null && methodStub.trim().length() > 0) {
                sb.append(methodStub);
            }
            if ((methodStub = this.getUnimplementedMethodsFromInterfaces(superClassType, className, javaProj)) != null && methodStub.trim().length() > 0) {
                sb.append(methodStub);
            }
        }
        if (superClassType != null && (userDefined = this.getUserDefinedMethodStubs(superClassType)) != null && userDefined.trim().length() > 0) {
            sb.append(userDefined);
        }
        return sb.toString();
    }

    private boolean hasGenericParams(IMethod method) {
        try {
            IType parentType = method.getDeclaringType();
            for (String type : method.getParameterTypes()) {
                if (this.isPrimitiveType(type) || (type = JavaModelUtil.getResolvedTypeName((String)type, (IType)parentType)).indexOf(60, 0) == -1) continue;
                return true;
            }
        }
        catch (JavaModelException e) {
            J2eePlugin.logError((CoreException)((Object)e));
        }
        return false;
    }

    private String getUnimplementedMethodsFromSuperclass(IType superClassType, String className) {
        StringBuffer sb = new StringBuffer();
        try {
            IMethod[] methods = superClassType.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                IMethod method = methods[j];
                int flags = method.getFlags();
                if ((!Flags.isAbstract((int)flags) || Flags.isStatic((int)flags) || Flags.isPrivate((int)flags)) && !this.implementImplementedMethod(methods[j])) continue;
                String methodStub = this.getMethodStub(methods[j], superClassType.getFullyQualifiedName(), className);
                sb.append(methodStub);
            }
        }
        catch (JavaModelException e) {
            J2eePlugin.logError((CoreException)((Object)e));
        }
        return sb.toString();
    }

    private String getUnimplementedMethodsFromInterfaces(IType superClassType, String className, IJavaProject javaProj) {
        StringBuffer sb = new StringBuffer();
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        try {
            List interfaces = (List)model.getProperty("NewJavaClassDataModel.INTERFACES");
            if (interfaces != null) {
                for (int i = 0; i < interfaces.size(); ++i) {
                    String qualifiedClassName = (String)interfaces.get(i);
                    IType interfaceType = javaProj.findType(qualifiedClassName);
                    if (interfaceType == null) continue;
                    IMethod[] methodArray = interfaceType.getMethods();
                    for (int j = 0; j < methodArray.length; ++j) {
                        if (this.isMethodImplementedInHierarchy(methodArray[j], superClassType)) continue;
                        String methodStub = this.getMethodStub(methodArray[j], qualifiedClassName, className);
                        sb.append(methodStub);
                    }
                }
            }
        }
        catch (JavaModelException e) {
            J2eePlugin.logError((CoreException)((Object)e));
        }
        return sb.toString();
    }

    private boolean isPrimitiveType(String typeName) {
        char first = Signature.getElementType((String)typeName).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private String resolveAndAdd(String refTypeSig, IType declaringType) throws JavaModelException {
        if (refTypeSig.indexOf(60, 0) != -1) {
            this.getImportStatements(refTypeSig, declaringType);
        } else {
            String resolvedTypeName = JavaModelUtil.getResolvedTypeName((String)refTypeSig, (IType)declaringType);
            if (resolvedTypeName != null && !this.importStatements.contains(resolvedTypeName) && !resolvedTypeName.startsWith("java.lang")) {
                this.importStatements.add(resolvedTypeName);
            }
        }
        return Signature.toString((String)refTypeSig);
    }

    private void getImportStatements(String signature, IType declaringType) throws JavaModelException {
        String erasure = Signature.getTypeErasure((String)signature);
        String resolvedTypeName = JavaModelUtil.getResolvedTypeName((String)erasure, (IType)declaringType);
        if (resolvedTypeName != null && !this.importStatements.contains(resolvedTypeName) && !resolvedTypeName.startsWith("java.lang")) {
            this.importStatements.add(resolvedTypeName);
        }
        String[] params = Signature.getTypeArguments((String)signature);
        for (int i = 0; i < params.length; ++i) {
            this.getImportStatements(params[i], declaringType);
        }
    }

    private String getMethodStub(IMethod method, String superClassName, String className) {
        StringBuffer sb = new StringBuffer();
        try {
            int i;
            IType parentType = method.getDeclaringType();
            String name = method.getElementName();
            String[] paramTypes = method.getParameterTypes();
            String[] paramNames = method.getParameterNames();
            String[] exceptionTypes = method.getExceptionTypes();
            Object paramString = EMPTY_STRING;
            int nP = paramTypes.length;
            for (int i2 = 0; i2 < nP; ++i2) {
                String type = paramTypes[i2];
                type = !this.isPrimitiveType(type) ? this.resolveAndAdd(type, parentType) : Signature.toString((String)type);
                int index = type.lastIndexOf(DOT);
                if (index != -1) {
                    type = type.substring(index + 1);
                }
                paramString = (String)paramString + type + SPACE + paramNames[i2];
                if (i2 >= nP - 1) continue;
                paramString = (String)paramString + ", ";
            }
            sb.append("\t/* (non-Java-doc)");
            sb.append(lineSeparator);
            sb.append("\t * @see ");
            sb.append(superClassName + POUND + name + OPEN_PAR);
            sb.append((String)paramString);
            sb.append(CLOSE_PAR);
            sb.append(lineSeparator);
            sb.append("\t */");
            sb.append(lineSeparator);
            sb.append(TAB);
            if (Flags.isPublic((int)method.getFlags())) {
                sb.append(PUBLIC);
            } else if (Flags.isProtected((int)method.getFlags())) {
                sb.append(PROTECTED);
            } else if (Flags.isPrivate((int)method.getFlags())) {
                sb.append(PRIVATE);
            }
            String returnType = null;
            if (method.isConstructor()) {
                sb.append(className);
            } else {
                returnType = method.getReturnType();
                returnType = !this.isPrimitiveType(returnType) ? this.resolveAndAdd(returnType, parentType) : Signature.toString((String)returnType);
                int idx = returnType.lastIndexOf(DOT);
                if (idx == -1) {
                    sb.append(returnType);
                } else {
                    sb.append(returnType.substring(idx + 1));
                }
                sb.append(SPACE);
                sb.append(name);
            }
            sb.append(OPEN_PAR + (String)paramString + CLOSE_PAR);
            int nE = exceptionTypes.length;
            if (nE > 0) {
                sb.append(" throws ");
                for (i = 0; i < nE; ++i) {
                    String type = exceptionTypes[i];
                    type = !this.isPrimitiveType(type) ? this.resolveAndAdd(type, parentType) : Signature.toString((String)type);
                    int index = type.lastIndexOf(DOT);
                    if (index != -1) {
                        type = type.substring(index + 1);
                    }
                    sb.append(type);
                    if (i >= nE - 1) continue;
                    sb.append(", ");
                }
            }
            sb.append(" {");
            sb.append(lineSeparator);
            if (method.isConstructor()) {
                sb.append("\t\tsuper(");
                for (i = 0; i < nP; ++i) {
                    sb.append(paramNames[i]);
                    if (i >= nP - 1) continue;
                    sb.append(", ");
                }
                sb.append(");");
                sb.append(lineSeparator);
            } else {
                String methodBody = this.getMethodBody(method, returnType);
                sb.append(methodBody);
            }
            sb.append("\t}");
            sb.append(lineSeparator);
            sb.append(lineSeparator);
        }
        catch (JavaModelException e) {
            J2eePlugin.logError((CoreException)((Object)e));
        }
        return sb.toString();
    }

    private boolean isMethodImplementedInHierarchy(IMethod method, IType superClass) {
        boolean ret = false;
        IMethod foundMethod = this.findMethodImplementationInHierarchy(method, superClass);
        if (foundMethod != null && foundMethod.exists() && !this.implementImplementedMethod(method)) {
            ret = true;
        }
        return ret;
    }

    private IMethod findMethodImplementationInHierarchy(IMethod method, IType superClass) {
        IMethod implementedMethod = null;
        try {
            if (superClass != null && superClass.exists()) {
                ITypeHierarchy tH = superClass.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                implementedMethod = this.findMethodImplementationInHierarchy(tH, superClass, method.getElementName(), method.getParameterTypes(), method.isConstructor());
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return implementedMethod;
    }

    private IMethod findMethodImplementationInHierarchy(ITypeHierarchy tH, IType thisType, String methodName, String[] parameterTypes, boolean isConstructor) throws JavaModelException {
        IMethod found = JavaModelUtil.findMethod((String)methodName, (String[])parameterTypes, (boolean)isConstructor, (IType)thisType);
        if (found != null && !Flags.isAbstract((int)found.getFlags())) {
            return found;
        }
        return JavaModelUtil.findMethodImplementationInHierarchy((ITypeHierarchy)tH, (IType)thisType, (String)methodName, (String[])parameterTypes, (boolean)isConstructor);
    }

    protected String getMethodBody(IMethod method, String returnType) {
        Object body = TODO_COMMENT;
        body = (String)body + lineSeparator;
        if (returnType == null || returnType.equals(VOID)) {
            return body;
        }
        body = returnType.equals(INT) ? (String)body + RETURN_0 : (returnType.equals(BOOLEAN) ? (String)body + RETURN_FALSE : (String)body + RETURN_NULL);
        body = (String)body + lineSeparator;
        return body;
    }

    protected String getUserDefinedMethodStubs(IType superClassType) {
        return EMPTY_STRING;
    }

    protected boolean implementImplementedMethod(IMethod method) {
        return false;
    }
}

