/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.j2ee.common.operations.EditLibraryDirectoryOperation;
import com.ibm.etools.j2ee.common.operations.Messages;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class EditLibraryDirectoryDataModel
extends AbstractDataModelProvider {
    public static final String LIBRARY_DIRECTORY = "EditLibraryDirectoryDataModel.LIBRARY_DIRECTORY";
    public static final String PROJECT = "EditLibraryDirectoryDataModel.PROJECT";

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add(PROJECT);
        propertyNames.add(LIBRARY_DIRECTORY);
        return propertyNames;
    }

    public IDataModelOperation getDefaultOperation() {
        return new EditLibraryDirectoryOperation(this.model);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals(LIBRARY_DIRECTORY)) {
            return this.validateLibraryDirectory(this.model.getStringProperty(propertyName));
        }
        return super.validate(propertyName);
    }

    private IStatus validateLibraryDirectory(String libraryDirectory) {
        if (libraryDirectory != null) {
            String libDir = libraryDirectory.trim();
            if (libDir.length() == 0) {
                return WTPCommonPlugin.createWarningStatus((String)Messages.WARN_LIB_DIR_EMPTY);
            }
            if (new Path(libDir).isAbsolute()) {
                return WTPCommonPlugin.createErrorStatus((String)Messages.ERR_LIB_DIR_NOT_RELATIVE);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

