/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.j2ee.J2eePlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddMigrationBuilderOperation
extends AbstractDataModelOperation {
    public static final String MIGRATION_BUILDER = "com.ibm.etools.common.migration.MigrationBuilder";

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.addMigratorBuilder();
        return OK_STATUS;
    }

    public void addMigratorBuilder() {
        IProject project = J2EEProjectUtilities.getProject((String)this.model.getStringProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME"));
        if (!project.isAccessible()) {
            return;
        }
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            for (int i = 0; i < commands.length; ++i) {
                if (!MIGRATION_BUILDER.equals(commands[i].getBuilderName())) continue;
                return;
            }
            ICommand[] newCommands = new ICommand[commands.length + 1];
            newCommands[0] = new BuildCommand();
            newCommands[0].setBuilderName(MIGRATION_BUILDER);
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            description.setBuildSpec(newCommands);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            J2eePlugin.logError(e);
        }
    }
}

