/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee;

import com.ibm.etools.j2ee.J2eePlugin;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.componentcore.EnterpriseBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.facet.EARFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.UtilityProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.w3c.dom.Document;

public class J2EEProjectUtilities
extends org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities {
    public static final IWorkspace ws = ResourcesPlugin.getWorkspace();

    public static boolean isEARComponent(IVirtualComponent aComponent) {
        return !aComponent.isBinary() && JavaEEProjectUtilities.isEARProject((IProject)aComponent.getProject());
    }

    public static IVirtualComponent[] getReferencingEARComponents(IVirtualComponent aComponent) {
        if (aComponent == null) {
            return new IVirtualComponent[0];
        }
        if (J2EEProjectUtilities.isEARComponent(aComponent)) {
            return new IVirtualComponent[]{aComponent};
        }
        ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>();
        if (aComponent.isBinary()) {
            IProject[] earProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.ear");
            for (int i = 0; i < earProjects.length; ++i) {
                IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProjects[i]);
                IVirtualReference[] references = earComponent.getReferences();
                boolean refFound = false;
                for (int j = 0; j < references.length && !refFound; ++j) {
                    if (!references[j].getReferencedComponent().equals((Object)aComponent)) continue;
                    refFound = true;
                    result.add(earComponent);
                }
            }
        } else {
            IVirtualComponent[] refComponents = aComponent.getReferencingComponents();
            for (int i = 0; i < refComponents.length; ++i) {
                if (!J2EEProjectUtilities.isEARComponent(refComponents[i])) continue;
                result.add(refComponents[i]);
            }
        }
        return result.toArray(new IVirtualComponent[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchiveManifest readManifest(IVirtualComponent component) {
        if (!component.isBinary()) {
            IVirtualFile vManifest = component.getRootFolder().getFile("META-INF/MANIFEST.MF");
            if (vManifest.exists()) {
                IFile manifestFile = vManifest.getUnderlyingFile();
                InputStream in = null;
                try {
                    in = manifestFile.getContents();
                    ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl(in);
                    return archiveManifestImpl;
                }
                catch (IOException e) {
                    J2eePlugin.logError(e);
                }
                catch (CoreException e) {
                    J2eePlugin.logError(e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                            in = null;
                        }
                        catch (IOException e) {
                            J2eePlugin.logError(e);
                        }
                    }
                }
            }
        } else {
            EnterpriseBinaryComponentHelper.IReferenceCountedArchive archive = EnterpriseBinaryComponentHelper.ArchiveCache.getInstance().getArchive(component);
            if (null == archive) {
                EnterpriseBinaryComponentHelper helper = EnterpriseBinaryComponentHelper.getHelper((IVirtualComponent)component);
                try {
                    ArchiveManifest manifest;
                    archive = helper.accessArchive();
                    ArchiveManifest archiveManifest = manifest = archive.getManifest();
                    return archiveManifest;
                }
                catch (Exception exception) {
                }
                finally {
                    if (null != archive) {
                        archive.close();
                    }
                    if (null != helper) {
                        helper.dispose();
                    }
                }
            } else {
                return archive.getManifest();
            }
        }
        return null;
    }

    public static IVirtualReference[] getJ2EEModuleReferences(IVirtualComponent earComponent) {
        return org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.getJ2EEModuleReferences((IVirtualComponent)earComponent);
    }

    public static String convertToModuleVersion(String type, int j2eeVersion) {
        if (type.equals("jst.ejb")) {
            if (j2eeVersion == 12) {
                return "1.1";
            }
            if (j2eeVersion == 13) {
                return "2.0";
            }
            if (j2eeVersion == 14) {
                return "2.1";
            }
            if (j2eeVersion == 50) {
                return "3.0";
            }
            if (j2eeVersion == 60) {
                return "3.1";
            }
            if (j2eeVersion == 70 || j2eeVersion == 80) {
                return "3.2";
            }
            return null;
        }
        if (type.equals("jst.web")) {
            if (j2eeVersion == 12) {
                return "2.2";
            }
            if (j2eeVersion == 13) {
                return "2.3";
            }
            if (j2eeVersion == 14) {
                return "2.4";
            }
            if (j2eeVersion == 50) {
                return "2.5";
            }
            if (j2eeVersion == 60) {
                return "3.0";
            }
            if (j2eeVersion == 70) {
                return "3.1";
            }
            if (j2eeVersion == 80) {
                return "4.0";
            }
            return null;
        }
        if (type.equals("jst.connector")) {
            if (j2eeVersion == 13) {
                return "1.0";
            }
            if (j2eeVersion == 14) {
                return "1.5";
            }
            if (j2eeVersion == 50) {
                return "1.5";
            }
            if (j2eeVersion == 60) {
                return "1.6";
            }
            if (j2eeVersion == 70 || j2eeVersion == 80) {
                return "1.7";
            }
            return null;
        }
        return J2EEVersionUtil.getJ2EETextVersion((int)j2eeVersion);
    }

    public static String getJ2EEDDProjectVersion(IProject project) {
        return JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
    }

    public static IProject getProject(String name) {
        return ws.getRoot().getProject(name);
    }

    public static IProject createEARProject(String name) {
        return J2EEProjectUtilities.createEARProject(name, false);
    }

    public static IProject createEARProject(String name, boolean waitForBuildToComplete) {
        return J2EEProjectUtilities.createEARProject(name, 14, false, waitForBuildToComplete);
    }

    public static IProject createEARProject(String name, int facetVersion, boolean generateDD, boolean waitForBuildToComplete) {
        IDataModel dataModel = J2EEProjectUtilities.getEARCreationDataModel(name, facetVersion, generateDD);
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.ear", null, waitForBuildToComplete);
    }

    public static IProject createWebProject(String name, String earName) {
        return J2EEProjectUtilities.createWebProject(name, earName, false);
    }

    public static IProject createWebProject(String name, String earName, boolean waitForBuildToComplete) {
        return J2EEProjectUtilities.createWebProject(name, earName, 24, waitForBuildToComplete, true);
    }

    public static IProject createWebProject(String name, String earName, int facetVersion, boolean waitForBuildToComplete, boolean generateDD) {
        IDataModel dataModel = J2EEProjectUtilities.getWebCreationDataModel(name, earName, facetVersion, generateDD);
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.web", earName, waitForBuildToComplete);
    }

    public static IProject createUtilityProject(String name, String earName) {
        return J2EEProjectUtilities.createUtilityProject(name, earName, false);
    }

    public static IProject createUtilityProject(String name, String earName, boolean waitForBuildToComplete) {
        IDataModel dataModel = J2EEProjectUtilities.getUtilityCreationDataModel(name, earName);
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.utility", earName, waitForBuildToComplete);
    }

    public static IProject createEJBProject(String name, String earName) {
        return J2EEProjectUtilities.createEJBProject(name, earName, false);
    }

    public static IProject createEJBProject(String name, String earName, boolean waitForBuildToComplete) {
        return J2EEProjectUtilities.createEJBProject(name, earName, 21, waitForBuildToComplete, false);
    }

    public static IProject createEJBProject(String name, String earName, int facetVersion, boolean waitForBuildToComplete, boolean generateDD) {
        IDataModel dataModel = J2EEProjectUtilities.getEJBCreationDataModel(name, earName, facetVersion, generateDD, null);
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.ejb", earName, waitForBuildToComplete);
    }

    public static IProject createEJBProject(String name, String earName, Map<String, Object> facetModelProperties, int facetVersion, boolean waitForBuildToComplete, boolean generateDD) {
        IDataModel dataModel = J2EEProjectUtilities.getEJBCreationDataModel(name, earName, facetVersion, generateDD, null);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        for (Map.Entry<String, Object> entry : facetModelProperties.entrySet()) {
            facetModel.setProperty(entry.getKey(), entry.getValue());
        }
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.ejb", earName, waitForBuildToComplete);
    }

    public static IProject createEJBProject(String name, String earName, String clientName, int facetVersion, boolean waitForBuildToComplete, boolean generateDD) {
        IDataModel dataModel = J2EEProjectUtilities.getEJBCreationDataModel(name, earName, facetVersion, generateDD, null);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
        if (clientName != null && earName != null) {
            facetModel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", true);
            facetModel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ", clientName);
        }
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.ejb", earName, waitForBuildToComplete);
    }

    private static IDataModel getEARCreationDataModel(String name, int facetVersion, boolean generateDD) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARFacetProjectCreationDataModelProvider());
        J2EEProjectUtilities.configure(model, name, "jst.ear", null, facetVersion, false, generateDD);
        return model;
    }

    private static IDataModel getWebCreationDataModel(String name, String earName, int facetVersion, boolean generateDD) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        J2EEProjectUtilities.configure(model, name, "jst.web", earName, facetVersion, facetVersion >= 50, generateDD);
        return model;
    }

    private static IDataModel getUtilityCreationDataModel(String name, String earName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new UtilityProjectCreationDataModelProvider());
        J2EEProjectUtilities.configure(model, name, "jst.utility", earName, 0, false, true);
        return model;
    }

    private static IDataModel getEJBCreationDataModel(String name, String earName, int facetVersion, boolean generateDD, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        J2EEProjectUtilities.configure(model, name, "jst.ejb", earName, facetVersion, facetVersion >= 50, generateDD);
        model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
        return model;
    }

    private static void configure(IDataModel model, String name, String facet, String earName, int facetVersion, boolean isJEE5OrGreater, boolean generateDD) {
        model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)name);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetDM = map.getFacetDataModel(facet);
        facetDM.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", generateDD);
        if (earName != null) {
            facetDM.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", true);
            facetDM.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        }
        if (facet.equals("jst.ejb")) {
            facetDM.setProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", (Object)false);
        }
        if (facetVersion != 0) {
            String versionText = J2EEProjectUtilities.convertToModuleVersion(facet, facetVersion);
            facetDM.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", versionText);
        }
        if (isJEE5OrGreater) {
            facetDM = map.getFacetDataModel("jst.java");
            String javaVersionString = null;
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            if (runtime != null) {
                IProjectFacetVersion javaVersion = null;
                try {
                    javaVersion = JavaFacet.FACET.getLatestSupportedVersion(runtime);
                }
                catch (CoreException e) {
                    J2eePlugin.logError(e);
                }
                if (javaVersion != null) {
                    javaVersionString = javaVersion.getVersionString();
                }
            }
            if (javaVersionString == null) {
                switch (facetVersion) {
                    case 50: {
                        javaVersionString = JavaFacet.VERSION_1_5.getVersionString();
                        break;
                    }
                    case 60: {
                        javaVersionString = JavaFacet.VERSION_1_6.getVersionString();
                        break;
                    }
                    case 70: {
                        javaVersionString = JavaFacet.VERSION_1_7.getVersionString();
                        break;
                    }
                    default: {
                        javaVersionString = JavaFacet.VERSION_1_8.getVersionString();
                    }
                }
            }
            facetDM.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", javaVersionString);
        }
    }

    private static IProject createAndExecute(IDataModel model, String projectName, String type, String earName, boolean waitForBuildToComplete) {
        J2EEProjectUtilities.runModel(model, waitForBuildToComplete);
        if (waitForBuildToComplete) {
            J2EEProjectUtilities.waitForClasspathUpdate();
        }
        return J2EEProjectUtilities.getProject(projectName);
    }

    private static void runModel(IDataModel dataModel, boolean waitForBuildToComplete) {
        try {
            dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            if (waitForBuildToComplete) {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            }
        }
        catch (ExecutionException e) {
            J2eePlugin.logError(e);
        }
        catch (OperationCanceledException e) {
            J2eePlugin.logError(e);
        }
        catch (InterruptedException e) {
            J2eePlugin.logError(e);
        }
        finally {
            dataModel.dispose();
        }
    }

    private static void waitForClasspathUpdate() {
        Job[] jobs = Job.getJobManager().find((Object)J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME);
        if (jobs.length > 0) {
            try {
                for (int i = 0; i < jobs.length; ++i) {
                    if (!jobs[i].getName().equals(J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME)) continue;
                    jobs[i].join();
                }
            }
            catch (InterruptedException e) {
                J2eePlugin.logError(e);
            }
        }
    }

    public static IProject createEJBProject(String ejbName, String earName, int version, boolean waitForBuildToComplete, boolean generateDD, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IDataModel dataModel = J2EEProjectUtilities.getEJBCreationDataModel(ejbName, earName, version, generateDD, runtime);
        return J2EEProjectUtilities.createAndExecute(dataModel, ejbName, "jst.ejb", earName, waitForBuildToComplete);
    }

    public static String getServerRuntimeTypeId(IProject project) {
        IRuntime serverRuntime;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = null;
        IFacetedProject fProject = null;
        try {
            fProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            J2eePlugin.logError(e);
        }
        if (fProject != null) {
            facetRuntime = fProject.getPrimaryRuntime();
        }
        if (facetRuntime != null && (serverRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetRuntime)) != null) {
            return serverRuntime.getRuntimeType().getId();
        }
        return null;
    }

    public static void saveXMLFileContent(IFile file, Document document) throws FileNotFoundException, IOException, CoreException {
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setLineWidth(65);
        outputFormat.setIndenting(true);
        outputFormat.setIndent(2);
        FileOutputStream fileOutputStream = new FileOutputStream(file.getRawLocation().toOSString());
        XMLSerializer serializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat);
        serializer.serialize(document);
        fileOutputStream.flush();
        fileOutputStream.close();
        file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
    }
}

