/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.j2ee.web.WebSocketUtility;
import com.ibm.etools.j2ee.web.internal.operations.NewWebsocketEndpointOperation;
import com.ibm.etools.j2ee.web.internal.operations.WebMessages;
import com.ibm.etools.j2ee.web.internal.operations.WebSocketSupertypesValidator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewWebsocketEndpointDataModelProvider
extends NewJavaClassDataModelProvider {
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("NewServletClassDataModel.JAVA_EE_VERSION");
        propertyNames.add("NewWebsocketEndpointDataModel.PROGAMMATIC_ENDPOINT");
        propertyNames.add("NewWebsocketEndpointDataModel.ANNOTATED_CLIENT_ENDPOINT");
        propertyNames.add("NewWebsocketEndpointDataModel.ANNOTATED_SERVER_ENDPOINT");
        propertyNames.add("NewWebsocketEndpointDataModel.ANNOTATED_SERVER_ENDPOINT_URL");
        propertyNames.add("NewWebsocketEndpointDataModel.ON_CLOSE");
        propertyNames.add("NewWebsocketEndpointDataModel.ON_OPEN");
        propertyNames.add("NewWebsocketEndpointDataModel.ON_ERROR");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("NewServletClassDataModel.JAVA_EE_VERSION".equals(propertyName)) {
            return this.getJavaEEVersion();
        }
        if ("NewWebsocketEndpointDataModel.PROGAMMATIC_ENDPOINT".equals(propertyName)) {
            return Boolean.FALSE;
        }
        if ("NewWebsocketEndpointDataModel.ANNOTATED_SERVER_ENDPOINT".equals(propertyName)) {
            return Boolean.TRUE;
        }
        if ("NewWebsocketEndpointDataModel.ANNOTATED_CLIENT_ENDPOINT".equals(propertyName)) {
            return Boolean.FALSE;
        }
        if ("NewWebsocketEndpointDataModel.ANNOTATED_SERVER_ENDPOINT_URL".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
            if (className != null) {
                return "/" + className;
            }
        } else if ("NewWebsocketEndpointDataModel.ON_OPEN".equals(propertyName)) {
            return WebSocketSupertypesValidator.isEndpointSuperclass(this.model);
        }
        return super.getDefaultProperty(propertyName);
    }

    public String getJavaEEVersion() {
        String projectName = this.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && projectName.length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            String id = null;
            if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
                id = WebFacetUtils.WEB_FACET.getId();
            } else if (JavaEEProjectUtilities.isWebFragmentProject((IProject)project)) {
                id = WebFacetUtils.WEBFRAGMENT_FACET.getId();
            } else if (JavaEEProjectUtilities.isUtilityProject((IProject)project)) {
                id = IJ2EEFacetConstants.UTILITY_FACET.getId();
            } else {
                return "";
            }
            return FacetedProjectUtilities.getProjectFacetVersion((IProject)project, (String)id).getVersionString();
        }
        return "";
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = false;
        if ("NewJavaClassDataModel.SUPERCLASS".equals(propertyName)) {
            this.model.notifyPropertyChange("NewJavaClassDataModel.ABSTRACT_METHODS", 3);
            this.model.notifyPropertyChange("NewWebsocketEndpointDataModel.ON_CLOSE", 3);
            this.model.notifyPropertyChange("NewWebsocketEndpointDataModel.ON_ERROR", 3);
            this.model.notifyPropertyChange("NewWebsocketEndpointDataModel.ON_OPEN", 3);
            if (!this.hasSuperClass()) {
                this.model.setProperty("NewJavaClassDataModel.ABSTRACT_METHODS", null);
                this.model.setProperty("NewWebsocketEndpointDataModel.ON_CLOSE", null);
                this.model.setProperty("NewWebsocketEndpointDataModel.ON_ERROR", null);
                this.model.setProperty("NewWebsocketEndpointDataModel.ON_OPEN", null);
            }
            this.model.notifyPropertyChange("NewJavaClassDataModel.ABSTRACT_METHODS", 2);
            this.model.notifyPropertyChange("NewWebsocketEndpointDataModel.ON_CLOSE", 2);
            this.model.notifyPropertyChange("NewWebsocketEndpointDataModel.ON_ERROR", 2);
            this.model.notifyPropertyChange("NewWebsocketEndpointDataModel.ON_OPEN", 2);
        }
        return result || super.propertySet(propertyName, propertyValue);
    }

    protected boolean hasSuperClass() {
        String superClass = this.model.getStringProperty("NewJavaClassDataModel.SUPERCLASS");
        return superClass == null ? false : superClass.trim().length() > 0;
    }

    protected IStatus validateSuperClassName(String superclassName) {
        if (WebSocketSupertypesValidator.isEndpointSuperclass(this.model)) {
            return OK_STATUS;
        }
        return WTPCommonPlugin.createErrorStatus((String)WebMessages.ERR_NOT_ENDPOINT_SUPERCLASS);
    }

    public IStatus validate(String propertyName) {
        if (this.model.getBooleanProperty("NewWebsocketEndpointDataModel.PROGAMMATIC_ENDPOINT")) {
            if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && !"javax.websocket.Endpoint".equals(this.model.getStringProperty("NewJavaClassDataModel.SUPERCLASS"))) {
                return this.validateSuperClassName(this.getStringProperty(propertyName));
            }
        } else if (this.model.getBooleanProperty("NewWebsocketEndpointDataModel.ANNOTATED_SERVER_ENDPOINT") && propertyName.equals("NewWebsocketEndpointDataModel.ANNOTATED_SERVER_ENDPOINT_URL")) {
            return this.validateURL(this.getStringProperty(propertyName));
        }
        return super.validate(propertyName);
    }

    private IStatus validateURL(String url) {
        if (!WebSocketUtility.isURIValid(url)) {
            return WTPCommonPlugin.createErrorStatus((String)WebMessages.WEBSOCKET_SERVERENDPOINT_URL_IS_NOT_VALID);
        }
        return OK_STATUS;
    }

    public IDataModelOperation getDefaultOperation() {
        return new NewWebsocketEndpointOperation(this.model);
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("NewJavaClassDataModel.MODIFIER_ABSTRACT".equals(propertyName)) {
            return false;
        }
        return super.isPropertyEnabled(propertyName);
    }
}

