/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddWebResourceCollectionOperation;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddWebResourceCollectionDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String ID = "AddWebResourceCollectionOperationDataModel.ID";
    public static final String SECURITY_CONSTRAINT = "AddWebResourceCollectionOperationDataModel.SECURITY_CONSTRAINT";
    public static final String RESOURCE_NAME = "AddWebResourceCollectionOperationDataModel.RESOURCE_NAME";
    public static final String RESOURCE_DESCRIPTION = "AddWebResourceCollectionOperationDataModel.RESOURCE_DESCRIPTION";
    public static final String HTTP_METHODS = "AddWebResourceCollectionOperationDataModel.HTTP_METHODS";
    public static final String URL_PATTERNS = "AddWebResourceCollectionOperationDataModel.URL_PATTERNS";

    public WTPOperation getDefaultOperation() {
        return new AddWebResourceCollectionOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SECURITY_CONSTRAINT);
        this.addValidBaseProperty(RESOURCE_NAME);
        this.addValidBaseProperty(RESOURCE_DESCRIPTION);
        this.addValidBaseProperty(HTTP_METHODS);
        this.addValidBaseProperty(URL_PATTERNS);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(RESOURCE_NAME)) {
            return this.validateResourceName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(URL_PATTERNS)) {
            return this.validateUrlPatterns((List)this.getProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateResourceName(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_RESOURCE_NAME_EMPTY, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        SecurityConstraint sc = (SecurityConstraint)this.getProperty(SECURITY_CONSTRAINT);
        boolean exists = false;
        if (sc != null) {
            EList collections = sc.getWebResourceCollections();
            int size = collections.size();
            for (int i = 0; i < size; ++i) {
                String wrName = ((WebResourceCollection)collections.get(i)).getWebResourceName();
                if (!name.equals(wrName)) continue;
                exists = true;
                break;
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_RESOURCE_NAME_EXIST, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateUrlPatterns(List urlList) {
        if (urlList == null || urlList.isEmpty()) {
            String msg = WebMessages.ERR_URL_PATTERNS_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

