/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.common.operations.ModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddTagLibRefOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddTagLibRefDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String URL = "AddTagLibRefDataModel.URL";
    public static final String LOCATION = "AddTagLibRefDataModel.LOCATION";

    public WTPOperation getDefaultOperation() {
        return new AddTagLibRefOperation((ModelModifierOperationDataModel)this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(URL);
        this.addValidBaseProperty(LOCATION);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(URL)) {
            return this.validateURL(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateURL(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_TAGLIBREF_URL_EMPTY, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        boolean exists = false;
        EList list = null;
        if (webApp.getJ2EEVersionID() >= 14) {
            JSPConfig jspConfig = webApp.getJspConfig();
            if (jspConfig != null) {
                list = jspConfig.getTagLibs();
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    TagLibRefType refType = (TagLibRefType)list.get(i);
                    String url = refType.getTaglibURI();
                    if (!name.equals(url)) continue;
                    exists = true;
                    break;
                }
            }
        } else {
            list = webApp.getTagLibs();
            if (list != null && list.size() > 0) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    TagLibRef ref = (TagLibRef)list.get(i);
                    String url = ref.getTaglibURI();
                    if (!name.equals(url)) continue;
                    exists = true;
                    break;
                }
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_TAGLIBREF_URL_EXIST, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

