/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.web.internal.operations.AddServletMappingOperation;
import com.ibm.etools.j2ee.web.internal.operations.WebMessages;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.javaee.web.IWebCommon;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class AddServletMappingDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String SERVLET = "AddServletMappingOperationDataModel.SERVLET";
    public static final String URL_PATTERN = "AddServletMappingOperationDataModel.URL_PATTERN";

    public WTPOperation getDefaultOperation() {
        return new AddServletMappingOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SERVLET);
        this.addValidBaseProperty(URL_PATTERN);
    }

    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = this.validateEE5Project();
        if (!status.isOK() && !this.isJavaEE6Project()) {
            return status;
        }
        if (propertyName.equals(SERVLET)) {
            WebApp webApp = null;
            IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
            Object app = ModelProviderManager.getModelProvider((IProject)selectedProj).getModelObject();
            if (app instanceof WebApp) {
                webApp = (WebApp)app;
            }
            String servletName = this.getStringProperty(SERVLET);
            if (webApp != null) {
                Servlet servlet = webApp.getServletNamed(servletName);
                status = this.validateServlet(servlet);
            } else {
                org.eclipse.jst.javaee.web.Servlet curServlet = this.getEE5ServletNamed(servletName);
                status = this.validateServlet(curServlet);
            }
            return status;
        }
        if (propertyName.equals(URL_PATTERN)) {
            return this.validateURLPattern(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    protected IStatus validateEE5Project() {
        EObject app = this.getDeploymentDescriptorRoot();
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (app == null && !JavaEEProjectUtilities.isWebFragmentProject((IProject)selectedProj)) {
            String msg = MessageFormat.format(JavaCodeGenResourceHandler.AddSecurityRoleOperationDataModel_This_wizard_is_not_applicable_on_pr_, new Object[]{null});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateURLPattern(String urlPattern) {
        if (urlPattern == null || urlPattern.trim().length() == 0) {
            String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_MAPPING_URL_PATTERN_EMPTY, new String[]{urlPattern});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        String servletName = this.getStringProperty(SERVLET);
        Servlet servlet = null;
        Object mappings = null;
        boolean exists = false;
        if (webApp != null) {
            servlet = webApp.getServletNamed(servletName);
            mappings = webApp.getServletMappings();
            if (mappings != null && !mappings.isEmpty()) {
                for (int i = 0; i < mappings.size(); ++i) {
                    org.eclipse.jst.j2ee.webapplication.ServletMapping mapping = (org.eclipse.jst.j2ee.webapplication.ServletMapping)mappings.get(i);
                    if (mapping.getServlet() != servlet || !urlPattern.equals(mapping.getUrlPattern())) continue;
                    exists = true;
                    break;
                }
            }
        } else {
            org.eclipse.jst.javaee.web.Servlet myServlet = this.getEE5ServletNamed(servletName);
            mappings = this.getEE5ServletMappingsInSelectedProject();
            if (mappings != null && !mappings.isEmpty()) {
                for (int i = 0; i < mappings.size(); ++i) {
                    ServletMapping mapping = (ServletMapping)mappings.get(i);
                    if (!mapping.getServletName().equals(myServlet.getServletName()) || !urlPattern.equals(mapping.getUrlPatterns().get(0))) continue;
                    exists = true;
                    break;
                }
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_MAPPING_URL_PATTERN_EXIST, new String[]{urlPattern});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateServlet(Object servlet) {
        if (servlet == null) {
            String msg = WebMessages.ERR_SERVLET_MAPPING_SERVLET_NOT_EXIST;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private org.eclipse.jst.javaee.web.Servlet getEE5ServletNamed(String servletName) {
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        IWebCommon webCommon = (IWebCommon)ModelProviderManager.getModelProvider((IProject)selectedProj).getModelObject();
        List servlets = webCommon.getServlets();
        for (org.eclipse.jst.javaee.web.Servlet curServlet : servlets) {
            if (!curServlet.getServletName().equals(servletName)) continue;
            return curServlet;
        }
        return null;
    }

    private List getEE5ServletMappingsInSelectedProject() {
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        IWebCommon webCommon = (IWebCommon)ModelProviderManager.getModelProvider((IProject)selectedProj).getModelObject();
        return webCommon.getServletMappings();
    }

    public boolean isJavaEE6Project() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (project != null && project.isAccessible()) {
            try {
                return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEB_FACET.getId(), (String)WebFacetUtils.WEB_30.getVersionString()) || FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEBFRAGMENT_FACET.getId(), (String)WebFacetUtils.WEBFRAGMENT_30.getVersionString());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

