/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.web.internal.operations.AddSecurityConstraintOperation;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.javaee.web.IWebCommon;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class AddSecurityConstraintDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String CONSTRAINT_NAME = "AddSecurityConstraintOperationDataModel.CONSTRAINT_NAME";

    public WTPOperation getDefaultOperation() {
        return new AddSecurityConstraintOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(CONSTRAINT_NAME);
    }

    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = this.validateEE5Project();
        if (!status.isOK() && !this.isJavaEE6Project()) {
            return status;
        }
        if (propertyName.equals(CONSTRAINT_NAME)) {
            return this.validateConstraintName(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    protected IStatus validateEE5Project() {
        EObject app = this.getDeploymentDescriptorRoot();
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (app == null && !JavaEEProjectUtilities.isWebFragmentProject((IProject)selectedProj)) {
            String msg = MessageFormat.format(JavaCodeGenResourceHandler.AddSecurityRoleOperationDataModel_This_wizard_is_not_applicable_on_pr_, new Object[]{null});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateConstraintName(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_SECURITY_CONSTRAINT_NAME_EMPTY, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        boolean exists = false;
        Object scList = null;
        if (webApp != null) {
            scList = webApp.getConstraints();
            if (scList != null) {
                int size = scList.size();
                if (webApp.getJ2EEVersionID() >= 14) {
                    for (int i = 0; i < size; ++i) {
                        DisplayName displayName;
                        String scName;
                        EList displayNameList = ((SecurityConstraint)scList.get(i)).getDisplayNames();
                        if (displayNameList == null || displayNameList.isEmpty() || !name.equals(scName = (displayName = (DisplayName)displayNameList.get(0)).getValue())) continue;
                        exists = true;
                        break;
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        String scName = ((SecurityConstraint)scList.get(i)).getDisplayName();
                        if (!name.equals(scName)) continue;
                        exists = true;
                        break;
                    }
                }
            }
        } else {
            IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
            IWebCommon webCommon = (IWebCommon)ModelProviderManager.getModelProvider((IProject)selectedProj).getModelObject();
            scList = webCommon.getSecurityConstraints();
            if (scList != null) {
                int size = scList.size();
                for (int i = 0; i < size; ++i) {
                    org.eclipse.jst.javaee.core.DisplayName displayName;
                    String scName;
                    List displayNameList = ((org.eclipse.jst.javaee.web.SecurityConstraint)scList.get(i)).getDisplayNames();
                    if (displayNameList == null || displayNameList.isEmpty() || !name.equals(scName = (displayName = (org.eclipse.jst.javaee.core.DisplayName)displayNameList.get(0)).getValue())) continue;
                    exists = true;
                    break;
                }
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_SECURITY_CONSTRAINT_NAME_EXIST, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    public boolean isJavaEE6Project() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (project != null && project.isAccessible()) {
            try {
                return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEB_FACET.getId(), (String)WebFacetUtils.WEB_30.getVersionString()) || FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEBFRAGMENT_FACET.getId(), (String)WebFacetUtils.WEBFRAGMENT_30.getVersionString());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

