/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddFilterMappingToServletOperation;
import com.ibm.etools.j2ee.web.internal.operations.WebMessages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddFilterMappingToServletDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String FILTER = "AddFilterMappingToServletOperationDataModel.FILTER";
    public static final String DISPATCHER_TYPE_NAME = "AddFilterMappingToServletOperationDataModel.DISPATCHER_TYPE_NAME";
    public static final String SERVLET_NAME = "AddFilterMappingOperationDataModel.SERVLET_NAME";
    public static final String DISPATCHER_TYPE = "AddFilterMappingToServletOperationDataModel.DISPATCHER_TYPE";

    public WTPOperation getDefaultOperation() {
        return new AddFilterMappingToServletOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(DISPATCHER_TYPE);
        this.addValidBaseProperty(DISPATCHER_TYPE_NAME);
        this.addValidBaseProperty(SERVLET_NAME);
        this.addValidBaseProperty(FILTER);
    }

    private IStatus validateServletName(String servletName) {
        if (servletName == null || servletName.trim().length() == 0) {
            String msg = WebMessages.ERR_MAPPING_SERVLET_EMTPY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        EList servlets = webApp.getServlets();
        boolean exists = false;
        if (servlets != null && !servlets.isEmpty()) {
            for (int i = 0; i < servlets.size(); ++i) {
                Servlet s = (Servlet)servlets.get(i);
                if (!s.getServletName().equals(servletName)) continue;
                exists = true;
                break;
            }
        }
        if (!exists) {
            String msg = WebMessages.ERR_SERVLET_MAPPING_SERVLET_NOT_EXIST;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        Filter filter = (Filter)this.getProperty(FILTER);
        EList mappings = webApp.getFilterMappings();
        exists = false;
        if (mappings != null && !mappings.isEmpty()) {
            for (int i = 0; i < mappings.size(); ++i) {
                FilterMapping mapping = (FilterMapping)mappings.get(i);
                if (mapping.getFilter() != filter || !servletName.equals(mapping.getServletName())) continue;
                exists = true;
                break;
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString(WebMessages.ERR_FILTER_MAPPING_SERVLET_EXIST, new String[]{servletName});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateDispatcherTypeName(List list) {
        if (list == null || list.size() == 0) {
            String msg = WebMessages.ERR_FILTER_MAPPING_SERVLET_DISPATCHER_TYPES_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean notify = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(DISPATCHER_TYPE_NAME)) {
            this.setProperty(DISPATCHER_TYPE_NAME, propertyValue);
            this.setProperty(DISPATCHER_TYPE, this.getDispatcherValues((List)propertyValue));
        }
        return notify;
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(SERVLET_NAME)) {
            return this.validateServletName(this.getStringProperty(propertyName));
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        if (webApp.getJ2EEVersionID() >= 14) {
            if (propertyName.equals(DISPATCHER_TYPE)) {
                return WTPCommonPlugin.OK_STATUS;
            }
            if (propertyName.equals(DISPATCHER_TYPE_NAME)) {
                return this.validateDispatcherTypeName((List)this.getProperty(propertyName));
            }
        }
        return super.doValidateProperty(propertyName);
    }

    private List getDispatcherValues(List list) {
        ArrayList<DispatcherType> dispatcherTypes = new ArrayList<DispatcherType>();
        for (int i = 0; i < list.size(); ++i) {
            String dispatcherTypeName = (String)list.get(i);
            dispatcherTypes.add(DispatcherType.get((String)dispatcherTypeName));
        }
        return dispatcherTypes;
    }

    protected String[] getStringValues(List values) {
        String[] names = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            names[i] = values.get(i).toString();
        }
        return names;
    }

    public String[] getValidDispatcherTypeNames() {
        return this.getStringValues(DispatcherType.VALUES);
    }

    public String[] getValidServletNames() {
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        List servlets = webApp.getServletNames();
        String[] names = new String[servlets.size()];
        for (int i = 0; i < servlets.size(); ++i) {
            names[i] = (String)servlets.get(i);
        }
        return names;
    }

    protected Object[] doGetValidPropertyValues(String propertyName) {
        if (propertyName.equals(DISPATCHER_TYPE_NAME)) {
            return this.getValidDispatcherTypeNames();
        }
        if (propertyName.equals(SERVLET_NAME)) {
            return this.getValidServletNames();
        }
        return super.doGetValidPropertyDescriptors(propertyName);
    }
}

