/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPPropertyDescriptor;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.web.internal.operations.AddFilterMappingOperation;
import com.ibm.etools.j2ee.web.internal.operations.WebMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.IWebCommon;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class AddFilterMappingDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String FILTER = "AddFilterMappingOperationDataModel.FILTER";
    public static final String DISPATCHER_TYPE_NAME = "AddFilterMappingOperationDataModel.DISPATCHER_TYPE_NAME";
    public static final String URL_PATTERN = "AddFilterMappingOperationDataModel.URL_PATTERN";
    public static final String DISPATCHER_TYPE = "AddFilterMappingOperationDataModel.DISPATCHER_TYPE";

    public WTPOperation getDefaultOperation() {
        return new AddFilterMappingOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(DISPATCHER_TYPE);
        this.addValidBaseProperty(URL_PATTERN);
        this.addValidBaseProperty(DISPATCHER_TYPE_NAME);
        this.addValidBaseProperty(FILTER);
    }

    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = this.validateEE5Project();
        if (!status.isOK() && !this.isJavaEE6Project()) {
            return status;
        }
        if (propertyName.equals(FILTER)) {
            WebApp webApp = null;
            IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
            Object app = ModelProviderManager.getModelProvider((IProject)selectedProj).getModelObject();
            if (app instanceof WebApp) {
                webApp = (WebApp)app;
            }
            String filterName = this.getStringProperty(FILTER);
            if (webApp == null) {
                Filter curFilter = this.getEE5FilterNamed(filterName);
                return this.validateFilter(curFilter);
            }
            org.eclipse.jst.j2ee.webapplication.Filter filter = webApp.getFilterNamed(filterName);
            status = this.validateFilter(filter);
            return status;
        }
        if (propertyName.equals(URL_PATTERN)) {
            return this.validateURLPattern(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    protected IStatus validateEE5Project() {
        EObject app = this.getDeploymentDescriptorRoot();
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (app == null && !JavaEEProjectUtilities.isWebFragmentProject((IProject)selectedProj)) {
            String msg = MessageFormat.format(JavaCodeGenResourceHandler.AddSecurityRoleOperationDataModel_This_wizard_is_not_applicable_on_pr_, new Object[]{null});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean notify = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(DISPATCHER_TYPE_NAME)) {
            this.setProperty(DISPATCHER_TYPE, this.getDispatcherValues((List)propertyValue));
        }
        return notify;
    }

    private List getDispatcherValues(List list) {
        ArrayList<Object> dispatcherTypes = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            String dispatcherTypeName = (String)list.get(i);
            if (JavaEEProjectUtilities.isLegacyJ2EEComponent((IVirtualComponent)this.getVirtualComponent())) {
                dispatcherTypes.add(DispatcherType.get((String)dispatcherTypeName));
                continue;
            }
            dispatcherTypes.add(org.eclipse.jst.javaee.web.DispatcherType.get((String)dispatcherTypeName));
        }
        return dispatcherTypes;
    }

    protected WTPPropertyDescriptor[] getStringValues(List values) {
        WTPPropertyDescriptor[] names = new WTPPropertyDescriptor[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            names[i] = new WTPPropertyDescriptor(values.get(i));
        }
        return names;
    }

    private WTPPropertyDescriptor[] getValidDispatcherTypeNames() {
        if (JavaEEProjectUtilities.isLegacyJ2EEComponent((IVirtualComponent)this.getVirtualComponent())) {
            return this.getStringValues(DispatcherType.VALUES);
        }
        return this.getStringValues(org.eclipse.jst.javaee.web.DispatcherType.VALUES);
    }

    protected WTPPropertyDescriptor[] doGetValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals(DISPATCHER_TYPE_NAME)) {
            return this.getValidDispatcherTypeNames();
        }
        return super.doGetValidPropertyDescriptors(propertyName);
    }

    private IStatus validateURLPattern(String urlPattern) {
        if (urlPattern == null || urlPattern.trim().length() == 0) {
            String msg = org.eclipse.jst.j2ee.internal.web.operations.WebMessages.getResourceString((String)WebMessages.ERR_MAPPING_URL_EMPTY, (Object[])new String[]{urlPattern});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        if (webApp != null) {
            String filterName = this.getStringProperty(FILTER);
            org.eclipse.jst.j2ee.webapplication.Filter filter = webApp.getFilterNamed(filterName);
            EList mappings = webApp.getFilterMappings();
            boolean exists = false;
            if (mappings != null && !mappings.isEmpty()) {
                for (int i = 0; i < mappings.size(); ++i) {
                    FilterMapping mapping = (FilterMapping)mappings.get(i);
                    if (mapping.getFilter() != filter || !urlPattern.equals(mapping.getUrlPattern())) continue;
                    exists = true;
                    break;
                }
            }
            if (exists) {
                String msg = org.eclipse.jst.j2ee.internal.web.operations.WebMessages.getResourceString((String)WebMessages.ERR_MAPPING_URL_EXISTS, (Object[])new String[]{urlPattern});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateFilter(Object filter) {
        if (filter == null) {
            String msg = org.eclipse.jst.j2ee.internal.web.operations.WebMessages.ERR_DISPLAY_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    public boolean isJavaEE6Project() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (project != null && project.isAccessible()) {
            try {
                return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEB_FACET.getId(), (String)WebFacetUtils.WEB_30.getVersionString()) || FacetedProjectFramework.hasProjectFacet((IProject)project, (String)WebFacetUtils.WEBFRAGMENT_FACET.getId(), (String)WebFacetUtils.WEBFRAGMENT_30.getVersionString());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private IVirtualComponent getVirtualComponent() {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        return ComponentCore.createComponent((IProject)proj);
    }

    private Filter getEE5FilterNamed(String filterName) {
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        IWebCommon webCommon = (IWebCommon)ModelProviderManager.getModelProvider((IProject)selectedProj).getModelObject();
        List filters = webCommon.getFilters();
        for (Filter curFilter : filters) {
            if (!curFilter.getFilterName().equals(filterName)) continue;
            return curFilter;
        }
        return null;
    }
}

