/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.web.internal.operations.AddFilterOperation;
import com.ibm.etools.j2ee.web.internal.operations.AddServletFilterListenerCommonDataModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddFilterDataModel
extends AddServletFilterListenerCommonDataModel {
    public static final String[] FILTER_INTERFACES = new String[]{"javax.servlet.Filter"};
    public static final String INIT_PARAM = "AddFilterDataModel.INIT_PARAM";
    public static final String URL_MAPPINGS = "AddFilterDataModel.URL_MAPPINGS";
    public static final String SERVLET_MAPPINGS = "AddFilterDataModel.SERVLET_MAPPINGS";
    public static final String COMPONENT_NAME = "IArtifactEditOperationDataModelProperties.COMPONENT_NAME";
    private List interfaceList;

    @Override
    public WTPOperation getDefaultOperation() {
        return new AddFilterOperation(this);
    }

    @Override
    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(INIT_PARAM);
        this.addValidBaseProperty(URL_MAPPINGS);
        this.addValidBaseProperty(SERVLET_MAPPINGS);
        this.addValidBaseProperty(COMPONENT_NAME);
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = this.validateEE5Project();
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals(INIT_PARAM)) {
            return this.validateInitParamList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals(URL_MAPPINGS)) {
            return this.validateURLMappingList((List)this.getProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    protected IStatus validateEE5Project() {
        EObject app = this.getDeploymentDescriptorRoot();
        IProject selectedProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME"));
        if (app == null && !JavaEEProjectUtilities.isWebFragmentProject((IProject)selectedProj)) {
            String msg = MessageFormat.format(JavaCodeGenResourceHandler.AddSecurityRoleOperationDataModel_This_wizard_is_not_applicable_on_pr_, new Object[]{null});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    @Override
    protected IStatus validateDisplayName(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = WebMessages.ERR_DISPLAY_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        boolean exists = false;
        EObject app = this.getDeploymentDescriptorRoot();
        WebApp webApp = null;
        EList filters = new ArrayList();
        if (app instanceof WebApp) {
            webApp = (WebApp)app;
            filters = webApp.getFilters();
        }
        if (filters != null && !filters.isEmpty()) {
            for (int i = 0; i < filters.size(); ++i) {
                String name = ((Filter)filters.get(i)).getName();
                if (!prop.equals(name)) continue;
                exists = true;
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_FILTER_NAME_EXIST, (Object[])new String[]{prop});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    @Override
    protected IStatus validateClassName(String prop) {
        if (!this.getBooleanProperty("AddServletFilterListenerCommonDataModel.USE_EXISTING_CLASS")) {
            return WTPCommonPlugin.OK_STATUS;
        }
        IStatus status = super.validateClassName(prop);
        if (!status.isOK()) {
            return status;
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        EList filters = webApp.getFilters();
        if (filters != null && filters.size() > 0) {
            for (int i = 0; i < filters.size(); ++i) {
                Filter filter = (Filter)filters.get(i);
                if (!prop.equals(filter.getFilterClass().getQualifiedName())) continue;
                String msg = WebMessages.ERR_FILTER_CLASS_NAME_USED;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateInitParamList(List prop) {
        boolean dup;
        if (prop != null && !prop.isEmpty() && (dup = this.hasDuplicatesInStringArrayList(prop))) {
            String msg = WebMessages.ERR_DUPLICATED_INIT_PARAMETER;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateURLMappingList(List prop) {
        boolean dup;
        if (prop != null && !prop.isEmpty() && (dup = this.hasDuplicatesInStringArrayList(prop))) {
            String msg = WebMessages.ERR_DUPLICATED_URL_MAPPING;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    public List getFilterInterfaces() {
        if (this.interfaceList == null) {
            this.interfaceList = new ArrayList();
            for (int i = 0; i < FILTER_INTERFACES.length; ++i) {
                this.interfaceList.add(FILTER_INTERFACES[i]);
            }
        }
        return this.interfaceList;
    }

    private boolean hasDuplicatesInStringArrayList(List input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        boolean dup = false;
        for (int i = 0; i < n; ++i) {
            String[] sArray1 = (String[])input.get(i);
            for (int j = i + 1; j < n; ++j) {
                String[] sArray2 = (String[])input.get(j);
                if (!this.isTwoStringArraysEqual(sArray1, sArray2)) continue;
                dup = true;
                break;
            }
            if (dup) break;
        }
        return dup;
    }

    private boolean isTwoStringArraysEqual(String[] sArray1, String[] sArray2) {
        if (sArray1 == null || sArray2 == null) {
            return false;
        }
        int n1 = sArray1.length;
        int n2 = sArray1.length;
        if (n1 == 0 || n2 == 0) {
            return false;
        }
        if (n1 != n2) {
            return false;
        }
        return sArray1[0].equals(sArray2[0]);
    }
}

