/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.common.operations.ModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddErrorCodeErrorPageOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.webapplication.ErrorCodeErrorPage;
import org.eclipse.jst.j2ee.webapplication.ErrorPage;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddErrorCodeErrorPageDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String ERROR_CODE_ERROR_PAGE_LOCATION = "AddErrorCodeErrorPageOperationDataModel.ERROR_CODE_ERROR_PAGE_LOCATION";
    public static final String ERROR_CODE_ERROR_PAGE_ERROR_CODE = "AddErrorCodeErrorPageOperationDataModel.ERROR_CODE_ERROR_PAGE_ERROR_CODE";

    public WTPOperation getDefaultOperation() {
        return new AddErrorCodeErrorPageOperation((ModelModifierOperationDataModel)this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(ERROR_CODE_ERROR_PAGE_LOCATION);
        this.addValidBaseProperty(ERROR_CODE_ERROR_PAGE_ERROR_CODE);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(ERROR_CODE_ERROR_PAGE_ERROR_CODE)) {
            return this.validateErrorCode(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(ERROR_CODE_ERROR_PAGE_LOCATION)) {
            return this.validateLocation(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateLocation(String location) {
        if (location == null || location.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_ERROR_PAGE_LOCATION_EMPTY, (Object[])new String[]{location});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!location.startsWith("/")) {
            String msg = WebMessages.ERR_ERROR_PAGE_LOCATION_MUST_START_WITH_SLASH;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return this.validateForDuplicates();
    }

    private IStatus validateErrorCode(String errorCode) {
        if (errorCode == null || errorCode.trim().length() == 0) {
            String msg = WebMessages.ERR_ERROR_CODE_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!this.isThreeDigits(errorCode)) {
            String msg = WebMessages.ERR_ERROR_CODE_MUST_BE_3_DIGITS;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return this.validateForDuplicates();
    }

    private boolean isThreeDigits(String s) {
        char[] a = s.toCharArray();
        int n = a.length;
        if (n != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (Character.isDigit(a[i])) continue;
            return false;
        }
        return true;
    }

    private IStatus validateForDuplicates() {
        EList errorPages = ((WebApp)this.getDeploymentDescriptorRoot()).getErrorPages();
        for (int i = 0; i < errorPages.size(); ++i) {
            ErrorCodeErrorPage ecErrorPage;
            ErrorPage errorPage = (ErrorPage)errorPages.get(i);
            if (!errorPage.isErrorCode() || !(ecErrorPage = (ErrorCodeErrorPage)errorPage).getLocation().equals(this.getStringProperty(ERROR_CODE_ERROR_PAGE_LOCATION)) || !ecErrorPage.getErrorCode().equals(this.getStringProperty(ERROR_CODE_ERROR_PAGE_ERROR_CODE))) continue;
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_ERROR_PAGE_LOCATION_EXIST, (Object[])new String[]{this.getStringProperty(ERROR_CODE_ERROR_PAGE_LOCATION)});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

