/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddEnvEntryOperation;
import com.ibm.etools.j2ee.web.internal.operations.WebMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddEnvEntryDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String ENV_ENTRY_NAME = "AddEnvEntriesOperationDataModel.ENV_ENTRY_NAME";
    public static final String ENV_ENTRY_TYPE = "AddEnvEntriesOperationDataModel.ENV_ENTRY_TYPE";
    public static final String ENV_ENTRY_VALUE = "AddEnvEntriesOperationDataModel.ENV_ENTRY_VALUE";

    public WTPOperation getDefaultOperation() {
        return new AddEnvEntryOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(ENV_ENTRY_NAME);
        this.addValidBaseProperty(ENV_ENTRY_TYPE);
        this.addValidBaseProperty(ENV_ENTRY_VALUE);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(ENV_ENTRY_NAME)) {
            return this.validateName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(ENV_ENTRY_VALUE)) {
            return this.validateValue();
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateValue() {
        String type = this.getStringProperty(ENV_ENTRY_TYPE);
        String value = this.getStringProperty(ENV_ENTRY_VALUE);
        if (type == null || type == "") {
            return WTPCommonPlugin.createErrorStatus((String)WebMessages.AddEnvEntryDataModel_0);
        }
        if (value == null) {
            return WTPCommonPlugin.createErrorStatus((String)WebMessages.AddEnvEntryDataModel_1);
        }
        if (type.equals("Boolean") && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            return WTPCommonPlugin.createErrorStatus((String)(value + WebMessages.AddEnvEntryDataModel_2));
        }
        if (type.equals("Integer")) {
            try {
                Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return WTPCommonPlugin.createErrorStatus((String)(value + WebMessages.AddEnvEntryDataModel_3));
            }
        }
        if (type.equals("Long")) {
            try {
                Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return WTPCommonPlugin.createErrorStatus((String)(value + WebMessages.AddEnvEntryDataModel_4));
            }
        }
        if (type.equals("Byte")) {
            try {
                Byte.valueOf(value);
            }
            catch (NumberFormatException e) {
                return WTPCommonPlugin.createErrorStatus((String)(value + WebMessages.AddEnvEntryDataModel_5));
            }
        }
        if (type.equals("Double")) {
            try {
                Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return WTPCommonPlugin.createErrorStatus((String)(value + WebMessages.AddEnvEntryDataModel_6));
            }
        }
        if (type.equals("Short")) {
            try {
                Short.valueOf(value);
            }
            catch (NumberFormatException e) {
                return WTPCommonPlugin.createErrorStatus((String)(value + WebMessages.AddEnvEntryDataModel_7));
            }
        }
        if (type.equals("Float")) {
            try {
                Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                return WTPCommonPlugin.createErrorStatus((String)(value + WebMessages.AddEnvEntryDataModel_8));
            }
        }
        if (type.equals("Character")) {
            IStatus createErrorStatus = WTPCommonPlugin.createErrorStatus((String)(value + WebMessages.AddEnvEntryDataModel_9));
            if (value.length() > 1) {
                return createErrorStatus;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus validateName(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = org.eclipse.jst.j2ee.internal.web.operations.WebMessages.getResourceString((String)org.eclipse.jst.j2ee.internal.web.operations.WebMessages.ERR_ENV_ENTRY_NAME_EMPTY, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        EList entries = webApp.getEnvironmentProperties();
        boolean exists = false;
        if (entries != null) {
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                String entryName = ((EnvEntry)entries.get(i)).getName();
                if (!name.equals(entryName)) continue;
                exists = true;
                break;
            }
        }
        if (exists) {
            String msg = org.eclipse.jst.j2ee.internal.web.operations.WebMessages.getResourceString((String)org.eclipse.jst.j2ee.internal.web.operations.WebMessages.ERR_ENV_ENTRY_NAME_EXIST, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

