/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.wsc;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.webtools.flatui.WidgetFactory;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ServiceReferenceBrowseDialog
extends Dialog {
    private Table serviceRefTable_;
    private TableViewer serviceRefList_;
    private Label status_;
    private EObject parent_;
    private String[] excluded_;
    private String addedServiceRefName_;
    private Color red_;
    private WidgetFactory wf_;

    public ServiceReferenceBrowseDialog(Shell shell, EObject parent, String[] excluded) {
        super(shell);
        this.parent_ = parent;
        this.excluded_ = excluded;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(J2EEUIPlugin.getResourceString("%DIALOG_TITLE_SERVICE_REF"));
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        parent.getShell().setSize(400, 300);
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        composite.setLayoutData((Object)gd);
        this.wf_ = new WidgetFactory();
        this.serviceRefTable_ = this.wf_.createTable(composite, 65540);
        this.serviceRefTable_.setLayoutData((Object)gd);
        this.serviceRefList_ = new TableViewer(this.serviceRefTable_);
        this.serviceRefList_.setContentProvider((IContentProvider)new ServiceRefContentProvider());
        this.serviceRefList_.setLabelProvider((IBaseLabelProvider)new ServiceRefLabelProvider());
        this.serviceRefList_.setInput((Object)this.parent_);
        this.status_ = new Label(composite, 64);
        this.status_.setVisible(false);
        this.status_.setText(J2EEUIPlugin.getResourceString("%MSG_NO_SERVICE_REFS"));
        this.red_ = new Color((Device)this.getShell().getDisplay(), 255, 0, 0);
        this.status_.setForeground(this.red_);
        if (this.serviceRefTable_.getItemCount() > 0) {
            this.serviceRefTable_.select(0);
        } else {
            this.status_.setVisible(true);
        }
        return composite;
    }

    public String getAddedServiceRefName() {
        return this.addedServiceRefName_;
    }

    protected void okPressed() {
        TableItem[] selection = this.serviceRefTable_.getSelection();
        if (selection.length > 0) {
            TableItem item = selection[0];
            this.addedServiceRefName_ = item.getText();
            this.setReturnCode(0);
        } else {
            this.setReturnCode(1);
        }
        this.disposeWidgets();
        this.close();
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.disposeWidgets();
        this.close();
    }

    private void disposeWidgets() {
        if (this.red_ != null && !this.red_.isDisposed()) {
            this.red_.dispose();
        }
        if (this.wf_ != null) {
            this.wf_.dispose();
        }
    }

    public class ServiceRefContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            int size;
            EList srs = ServiceReferenceBrowseDialog.this.parent_ instanceof WebServicesClient ? ((WebServicesClient)ServiceReferenceBrowseDialog.this.parent_).getServiceRefs() : ((ComponentScopedRefs)ServiceReferenceBrowseDialog.this.parent_).getServiceRefs();
            int resultSize = size = srs.size();
            Object[] temp = new Object[size];
            Iterator i = srs.iterator();
            int j = 0;
            while (i.hasNext()) {
                ServiceRef sr = (ServiceRef)i.next();
                if (this.isExcluded(sr)) {
                    temp[j] = null;
                    --resultSize;
                } else {
                    temp[j] = sr;
                }
                ++j;
            }
            Object[] result = new Object[resultSize];
            int m = 0;
            for (int k = 0; k < size; ++k) {
                Object sr = temp[k];
                if (sr == null) continue;
                result[m] = sr;
                ++m;
            }
            return result;
        }

        private boolean isExcluded(ServiceRef sr) {
            boolean excluded = false;
            String srName = sr.getServiceRefName();
            if (srName != null) {
                int size = ServiceReferenceBrowseDialog.this.excluded_.length;
                for (int i = 0; i < size; ++i) {
                    if (!srName.equals(ServiceReferenceBrowseDialog.this.excluded_[i])) continue;
                    excluded = true;
                    break;
                }
            }
            return excluded;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }
    }

    public class ServiceRefLabelProvider
    extends LabelProvider {
        private Image image_ = null;

        public Image getImage(Object element) {
            Image imageObj;
            if (this.image_ == null && (imageObj = J2EEUIPlugin.getDefault().getImage("icons/obj16/serviceref.gif")) != null) {
                this.image_ = imageObj;
            }
            return this.image_;
        }

        public String getText(Object element) {
            ServiceRef sr = (ServiceRef)element;
            return sr.getServiceRefName();
        }

        public void dispose() {
            if (this.image_ != null && !this.image_.isDisposed()) {
                this.image_.dispose();
            }
            super.dispose();
        }
    }
}

