/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.ws;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.SessionType;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddPackage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class AdapterWSServiceImplBean
extends AdapterImpl
implements SelectionListener {
    private final byte SERVICE_IMPL_BEAN_TYPE_EJB = 0;
    private final byte SERVICE_IMPL_BEAN_TYPE_SERVLET = 1;
    private ArtifactEdit artifactEdit;
    private EObject eObject_;
    private CCombo serviceImplBeanCombo_;
    private Button ejbLinkButton_;
    private Button servletLinkButton_;

    public AdapterWSServiceImplBean(ArtifactEdit anArtifactEdit, CCombo serviceImplBeanCombo, Button ejbLinkButton, Button servletLinkButton) {
        this.artifactEdit = anArtifactEdit;
        this.eObject_ = null;
        this.serviceImplBeanCombo_ = serviceImplBeanCombo;
        this.ejbLinkButton_ = ejbLinkButton;
        this.servletLinkButton_ = servletLinkButton;
        this.serviceImplBeanCombo_.addSelectionListener((SelectionListener)this);
        this.ejbLinkButton_.addSelectionListener((SelectionListener)this);
        this.servletLinkButton_.addSelectionListener((SelectionListener)this);
    }

    public AdapterWSServiceImplBean(ArtifactEdit anArtifactEdit, EObject eObject, CCombo serviceImplBeanCombo, Button ejbLinkButton, Button servletLinkButton) {
        this(anArtifactEdit, serviceImplBeanCombo, ejbLinkButton, servletLinkButton);
        this.adapt(eObject);
    }

    public void notifyChanged(Notification msg) {
        WsddPackage pkg = WsddPackage.eINSTANCE;
        int type = msg.getEventType();
        if ((type == 1 || type == 2) && msg.getFeature() == pkg.getPortComponent_ServiceImplBean()) {
            ServiceImplBean serviceImplBean = (ServiceImplBean)msg.getNewValue();
            byte beanType = this.getServiceImplBeanType(serviceImplBean);
            if (beanType == 0) {
                if (!this.ejbLinkButton_.getSelection()) {
                    this.populateServiceImplBeanCombo(beanType);
                    this.ejbLinkButton_.setSelection(true);
                    this.servletLinkButton_.setSelection(false);
                }
                this.serviceImplBeanCombo_.select(this.serviceImplBeanCombo_.indexOf(this.getEJBLinkString(serviceImplBean)));
            } else {
                if (!this.servletLinkButton_.getSelection()) {
                    this.populateServiceImplBeanCombo(beanType);
                    this.servletLinkButton_.setSelection(true);
                    this.ejbLinkButton_.setSelection(false);
                }
                this.serviceImplBeanCombo_.select(this.serviceImplBeanCombo_.indexOf(this.getServletLinkString(serviceImplBean)));
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        if (widget == this.serviceImplBeanCombo_) {
            this.serviceImplBeanComboSelected();
        } else if (widget == this.ejbLinkButton_) {
            this.ejbLinkButtonSelected();
        } else if (widget == this.servletLinkButton_) {
            this.servletLinkButtonSelected();
        }
    }

    private void serviceImplBeanComboSelected() {
        ServiceImplBean serviceImplBean = this.getServiceImplBean();
        EJBLink ejbLink = serviceImplBean.getEEJBLink();
        ServletLink servletLink = serviceImplBean.getEServletLink();
        String serviceImplBeanString = ejbLink != null ? ejbLink.getEjbLink() : (servletLink != null ? servletLink.getServletLink() : null);
        if (serviceImplBeanString == null || !serviceImplBeanString.equals(this.serviceImplBeanCombo_.getText())) {
            if (this.ejbLinkButton_.getSelection()) {
                this.setServiceImplBean(this.createServiceImplBean((byte)0));
            } else {
                this.setServiceImplBean(this.createServiceImplBean((byte)1));
            }
        }
    }

    private void ejbLinkButtonSelected() {
        EJBLink ejbLink;
        if (this.ejbLinkButton_.getSelection() && (ejbLink = this.getServiceImplBean().getEEJBLink()) == null) {
            this.populateServiceImplBeanCombo((byte)0);
            this.setServiceImplBean(this.createServiceImplBean((byte)0));
        }
    }

    private void servletLinkButtonSelected() {
        ServletLink servletLink;
        if (this.servletLinkButton_.getSelection() && (servletLink = this.getServiceImplBean().getEServletLink()) == null) {
            this.populateServiceImplBeanCombo((byte)1);
            this.setServiceImplBean(this.createServiceImplBean((byte)1));
        }
    }

    private ServiceImplBean createServiceImplBean(byte type) {
        WsddPackage pkg = WsddPackage.eINSTANCE;
        EFactory eFactory = pkg.getEFactoryInstance();
        ServiceImplBean serviceImplBean = (ServiceImplBean)eFactory.create(pkg.getServiceImplBean());
        String text = this.serviceImplBeanCombo_.getText();
        if (type == 0) {
            EJBLink ejbLink = (EJBLink)eFactory.create(pkg.getEJBLink());
            ejbLink.setEjbLink(text != null ? text : "");
            serviceImplBean.setEEJBLink(ejbLink);
        } else {
            ServletLink servletLink = (ServletLink)eFactory.create(pkg.getServletLink());
            servletLink.setServletLink(text != null ? text : "");
            serviceImplBean.setEServletLink(servletLink);
        }
        return serviceImplBean;
    }

    private ServiceImplBean getServiceImplBean() {
        if (this.eObject_ != null && this.eObject_ instanceof PortComponent) {
            return ((PortComponent)this.eObject_).getServiceImplBean();
        }
        return null;
    }

    private String getEJBLinkString(ServiceImplBean serviceImplBean) {
        EJBLink ejbLink = serviceImplBean.getEEJBLink();
        if (ejbLink != null) {
            return ejbLink.getEjbLink();
        }
        return "";
    }

    private String getServletLinkString(ServiceImplBean serviceImplBean) {
        ServletLink servletLink = serviceImplBean.getEServletLink();
        if (servletLink != null) {
            return servletLink.getServletLink();
        }
        return "";
    }

    private void setServiceImplBean(ServiceImplBean serviceImplBean) {
        WsddPackage pkg = WsddPackage.eINSTANCE;
        CommandAddElement command = new CommandAddElement(null, null, this.eObject_, (EStructuralFeature)pkg.getPortComponent_ServiceImplBean(), (Object)serviceImplBean);
        this.artifactEdit.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit.getCommandStack().execute((Command)command);
    }

    private byte getServiceImplBeanType(ServiceImplBean serviceImplBean) {
        if (serviceImplBean.getEEJBLink() != null) {
            return 0;
        }
        return 1;
    }

    private void setServiceImplBeanComboSelection(int index) {
        if (index >= 0 && index < this.serviceImplBeanCombo_.getItemCount()) {
            this.serviceImplBeanCombo_.select(index);
        } else {
            this.serviceImplBeanCombo_.deselectAll();
            this.serviceImplBeanCombo_.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateServiceImplBeanCombo(byte type) {
        IProject handle = this.artifactEdit.getProject();
        EJBArtifactEdit anArtifactEdit = null;
        this.serviceImplBeanCombo_.removeAll();
        try {
            if (type == 0) {
                EJBJar ejbJar;
                anArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)handle);
                if (anArtifactEdit != null && (ejbJar = anArtifactEdit.getEJBJar()) != null) {
                    List sessionBeans = ejbJar.getSessionBeans();
                    for (Session session : sessionBeans) {
                        SessionType sessionType = session.getSessionType();
                        if (sessionType == null || sessionType.getValue() != 1) continue;
                        this.serviceImplBeanCombo_.add(session.getName());
                    }
                }
            } else {
                WebApp webApp;
                anArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)handle);
                if (anArtifactEdit != null && (webApp = ((WebArtifactEdit)anArtifactEdit).getWebApp()) != null) {
                    List servletNames = webApp.getServletNames();
                    Iterator it = servletNames.iterator();
                    while (it.hasNext()) {
                        this.serviceImplBeanCombo_.add((String)it.next());
                    }
                }
            }
        }
        finally {
            if (anArtifactEdit != null) {
                anArtifactEdit.dispose();
            }
        }
        this.serviceImplBeanCombo_.select(0);
    }

    public void adapt(EObject eObject) {
        if (this.eObject_ != null) {
            this.eObject_.eAdapters().remove((Object)this);
        }
        this.eObject_ = eObject;
        if (this.eObject_ != null) {
            this.eObject_.eAdapters().add((Object)this);
            ServiceImplBean serviceImplBean = this.getServiceImplBean();
            byte type = this.getServiceImplBeanType(serviceImplBean);
            this.populateServiceImplBeanCombo(type);
            int selectionIndex = -1;
            if (type == 0) {
                this.ejbLinkButton_.setSelection(true);
                this.servletLinkButton_.setSelection(false);
                selectionIndex = this.serviceImplBeanCombo_.indexOf(this.getEJBLinkString(serviceImplBean));
            } else {
                this.servletLinkButton_.setSelection(true);
                this.ejbLinkButton_.setSelection(false);
                selectionIndex = this.serviceImplBeanCombo_.indexOf(this.getServletLinkString(serviceImplBean));
            }
            this.setServiceImplBeanComboSelection(selectionIndex);
        }
    }

    public void dispose() {
        if (this.eObject_ != null) {
            this.eObject_.eAdapters().remove((Object)this);
        }
        if (this.serviceImplBeanCombo_ != null && !this.serviceImplBeanCombo_.isDisposed()) {
            this.serviceImplBeanCombo_.removeSelectionListener((SelectionListener)this);
        }
        if (this.ejbLinkButton_ != null && !this.ejbLinkButton_.isDisposed()) {
            this.ejbLinkButton_.removeSelectionListener((SelectionListener)this);
        }
        if (this.servletLinkButton_ != null && !this.servletLinkButton_.isDisposed()) {
            this.servletLinkButton_.removeSelectionListener((SelectionListener)this);
        }
    }
}

