/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.common;

import com.ibm.etools.webservice.atk.ui.editor.IHyperLinkListener;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionEditableControlInitializer;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionViewer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandRemoveElement;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class SectionTableViewer
extends SectionViewer {
    private final int DEFAULT_TABLE_HEIGHT_HINT = 100;
    protected EObject parent_;
    protected EClass childEClass_;
    protected EStructuralFeature childFeature_;
    protected HyperLinkTracker hyperLinkTracker_;

    public SectionTableViewer(Composite parent, int style, String aTitle, String formInfo, SectionEditableControlInitializer initializer) {
        super(parent, style, aTitle, formInfo, initializer);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        Table table = this.getWf().createTable(parent, 66308);
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        TableViewer tableViewer = new TableViewer(table);
        SectionEditableControlInitializer sectionInitializer = this.getEditableInitializer();
        if (sectionInitializer.getUseHyperLinks()) {
            this.useHyperLinks(tableViewer);
        }
        return tableViewer;
    }

    protected void useHyperLinks(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        table.setForeground(this.blue);
        this.hyperLinkTracker_ = new HyperLinkTracker(tableViewer);
        table.addMouseTrackListener((MouseTrackListener)this.hyperLinkTracker_);
        table.addSelectionListener((SelectionListener)this.hyperLinkTracker_);
    }

    public void addHyperLinkListener(IHyperLinkListener listener) {
        if (this.hyperLinkTracker_ == null) {
            this.hyperLinkTracker_ = new HyperLinkTracker((TableViewer)this.viewer);
        }
        this.hyperLinkTracker_.addHyperLinkListener(listener);
    }

    public void removeHyperLinkListener(IHyperLinkListener listener) {
        if (this.hyperLinkTracker_ != null) {
            this.hyperLinkTracker_.removeHyperLinkListener(listener);
        }
    }

    protected void fireHyperLinkClickedEvent() {
        if (this.hyperLinkTracker_ != null) {
            this.hyperLinkTracker_.fireHyperLinkClickedEvent();
        }
    }

    @Override
    protected void handleAddButtonSelected(SelectionEvent event) {
        CommandAddElement command = new CommandAddElement(null, null, this.parent_, this.childEClass_, this.childFeature_, null, null);
        this.artifactEdit.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit.getCommandStack().execute((Command)command);
        Object object = command.getAddedObject();
        if (object != null) {
            this.setSelectionAsObject(object);
            if (this.hyperLinkTracker_ != null) {
                this.hyperLinkTracker_.fireHyperLinkClickedEvent();
            }
        }
    }

    @Override
    protected void handleRemoveButtonSelected(SelectionEvent event) {
        this.handleDeleteKeyPressed();
    }

    @Override
    protected void handleEditButtonSelected(SelectionEvent event) {
    }

    @Override
    protected void handleDeleteKeyPressed() {
        Object object = this.getSelectionAsObject();
        if (object != null && object instanceof EObject) {
            TableViewer tableViewer = (TableViewer)this.viewer;
            Table table = tableViewer.getTable();
            int selectionIndex = table.getSelectionIndex();
            int selectionCount = table.getItemCount();
            CommandRemoveElement command = new CommandRemoveElement(null, null, this.parent_, object, this.childFeature_);
            this.artifactEdit.getContentModelRoot().eResource().setModified(true);
            this.artifactEdit.getCommandStack().execute((Command)command);
            if (selectionIndex < selectionCount - 1) {
                this.setSelectionAsObject(tableViewer.getElementAt(selectionIndex));
            } else if (selectionCount - 2 >= 0) {
                this.setSelectionAsObject(tableViewer.getElementAt(selectionCount - 2));
            }
        }
    }

    public String getToolTipText() {
        return ((TableViewer)this.viewer).getTable().getToolTipText();
    }

    public void setToolTipText(String string) {
        ((TableViewer)this.viewer).getTable().setToolTipText(string);
    }

    public void setInfopop(String string) {
        Workbench.getInstance().getHelpSystem().setHelp((Control)((TableViewer)this.viewer).getTable(), string);
    }

    public Object getElementAt(int index) {
        return ((TableViewer)this.viewer).getElementAt(index);
    }

    public void deselectAll() {
        ((TableViewer)this.viewer).getTable().deselectAll();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public void dispose() {
        if (this.hyperLinkTracker_ != null) {
            this.hyperLinkTracker_.dispose();
        }
        super.dispose();
    }

    @Override
    public void adaptModel(EObject eObject) {
        super.adaptModel(eObject);
        this.parent_ = eObject;
    }

    public void setArtifactEdit(ArtifactEdit anArtifactEdit, EObject eObject, EClass childEClass, EStructuralFeature childFeature) {
        super.setArtifactEdit(anArtifactEdit);
        this.childEClass_ = childEClass;
        this.childFeature_ = childFeature;
        this.adapterViewer_.adaptFeature(this.childFeature_);
        this.adaptModel(eObject);
    }

    private class HyperLinkTracker
    implements MouseTrackListener,
    SelectionListener {
        private Cursor cursor_;
        private TableViewer tableViewer_;
        private ArrayList hyperLinkListeners_;

        public HyperLinkTracker(TableViewer tableViewer) {
            this.cursor_ = new Cursor((Device)SectionTableViewer.this.getDisplay(), 21);
            this.tableViewer_ = tableViewer;
            this.hyperLinkListeners_ = new ArrayList();
        }

        public void dispose() {
            if (this.cursor_ != null && !this.cursor_.isDisposed()) {
                this.cursor_.dispose();
            }
        }

        public void addHyperLinkListener(IHyperLinkListener listener) {
            this.hyperLinkListeners_.add(listener);
        }

        public void removeHyperLinkListener(IHyperLinkListener listener) {
            this.hyperLinkListeners_.remove(listener);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.tableViewer_.getTable().isFocusControl()) {
                this.fireHyperLinkClickedEvent();
            }
        }

        public void fireHyperLinkClickedEvent() {
            int selectionIndex = this.tableViewer_.getTable().getSelectionIndex();
            Object selectedObject = this.tableViewer_.getElementAt(selectionIndex);
            Iterator it = this.hyperLinkListeners_.iterator();
            while (it.hasNext()) {
                ((IHyperLinkListener)it.next()).jumpToHyperLink(selectedObject);
            }
        }

        public void mouseEnter(MouseEvent e) {
            this.tableViewer_.getTable().setCursor(this.cursor_);
        }

        public void mouseExit(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }
    }
}

