/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.common;

import com.ibm.etools.common.ui.nls.CommonAppEJBResourceHandler;
import com.ibm.etools.common.ui.presentation.FilteredFileSelectionDialog;
import com.ibm.etools.webservice.atk.ui.editor.common.BorderedImageLabel;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionControlInitializer;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionModelAbstract;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.webservice.adapter.AdapterText;
import org.eclipse.jst.j2ee.internal.webservice.constants.InfopopConstants;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SectionIcons
extends SectionModelAbstract {
    protected static final String[] extensions = new String[]{"gif", "jpeg", "jpg"};
    protected IContainer rootContainer;
    private BorderedImageLabel smallIconImageLabel_;
    private BorderedImageLabel largeIconImageLabel_;
    private Label smallIconLabel_;
    private Label largeIconLabel_;
    private Text smallIconText_;
    private Text largeIconText_;
    private Button smallIconButton_;
    private Button largeIconButton_;
    private AdapterText smallIconAdapter_;
    private AdapterText largeIconAdapter_;
    private EStructuralFeature smallIconFeature_;
    private EStructuralFeature largeIconFeature_;
    private Label messageLabel_;

    public SectionIcons(Composite parent, int style, String title, String desc, SectionControlInitializer sectionInitializer) {
        super(parent, style, title, desc, sectionInitializer);
    }

    @Override
    protected Composite createCollapsableClient(Composite parent) {
        Composite composite = this.getWf().createComposite(parent);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        gl.numColumns = 4;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        this.createControlsSmallIcon(composite);
        this.createControlsLargeIcon(composite);
        this.createControlsMessage(composite);
        composite.setTabList(new Control[]{this.smallIconText_, this.smallIconButton_, this.largeIconText_, this.largeIconButton_});
        this.getWf().paintBordersFor(composite);
        return composite;
    }

    private void createControlsSmallIcon(Composite parent) {
        this.smallIconImageLabel_ = new BorderedImageLabel(parent, 0);
        GridData gd = new GridData(64);
        this.smallIconImageLabel_.setLayoutData(gd);
        this.smallIconImageLabel_.setWidth(16);
        this.smallIconImageLabel_.setHeight(16);
        this.smallIconLabel_ = this.getWf().createLabel(parent, this.getMessage("%LABEL_SMALL_ICON"));
        this.smallIconLabel_.setLayoutData((Object)new GridData(256));
        this.smallIconText_ = this.getWf().createText(parent, "");
        gd = new GridData(768);
        this.smallIconText_.setLayoutData((Object)gd);
        this.smallIconText_.setToolTipText(this.getMessage("%TOOLTIP_SMALL_ICON"));
        Workbench.getInstance().getHelpSystem().setHelp((Control)this.smallIconText_, new InfopopConstants().getInfopopSmallIcon());
        this.smallIconText_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SectionIcons.this.handleSmallIconTextModified();
            }
        });
        this.smallIconButton_ = this.getWf().createButton(parent, this.getMessage("%LABEL_BROWSE"), 0x1000008);
        this.smallIconButton_.setLayoutData((Object)new GridData(256));
        this.smallIconButton_.setToolTipText(this.getMessage("%TOOLTIP_BROWSE_SMALL_ICON"));
        this.smallIconButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SectionIcons.this.handleIconBrowseButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void createControlsLargeIcon(Composite parent) {
        this.largeIconImageLabel_ = new BorderedImageLabel(parent, 0);
        GridData gd = new GridData(64);
        this.largeIconImageLabel_.setLayoutData(gd);
        this.largeIconImageLabel_.setWidth(32);
        this.largeIconImageLabel_.setHeight(32);
        this.largeIconLabel_ = this.getWf().createLabel(parent, this.getMessage("%LABEL_LARGE_ICON"));
        this.largeIconLabel_.setLayoutData((Object)new GridData(256));
        this.largeIconText_ = this.getWf().createText(parent, "");
        gd = new GridData(768);
        this.largeIconText_.setLayoutData((Object)gd);
        this.largeIconText_.setToolTipText(this.getMessage("%TOOLTIP_LARGE_ICON"));
        Workbench.getInstance().getHelpSystem().setHelp((Control)this.largeIconText_, new InfopopConstants().getInfopopLargeIcon());
        this.largeIconText_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SectionIcons.this.handleLargeIconTextModified();
            }
        });
        this.largeIconButton_ = this.getWf().createButton(parent, this.getMessage("%LABEL_BROWSE"), 0x1000008);
        this.largeIconButton_.setLayoutData((Object)new GridData(256));
        this.largeIconButton_.setToolTipText(this.getMessage("%TOOLTIP_BROWSE_LARGE_ICON"));
        this.largeIconButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SectionIcons.this.handleIconBrowseButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void createControlsMessage(Composite parent) {
        this.messageLabel_ = this.getWf().createLabel(parent, "");
        GridData gd = new GridData(256);
        gd.horizontalSpan = 4;
        this.messageLabel_.setLayoutData((Object)gd);
        this.messageLabel_.setForeground(this.messageLabel_.getDisplay().getSystemColor(3));
    }

    protected IContainer getRootContainer() {
        if (this.rootContainer == null) {
            IProject p = this.artifactEdit.getProject();
            IVirtualComponent component = ComponentCore.createComponent((IProject)p);
            this.rootContainer = component.getRootFolder().getUnderlyingFolder();
        }
        return this.rootContainer;
    }

    private void handleIconBrowseButtonSelected(SelectionEvent event) {
        String fileName = null;
        String[] theExtensions = new String[]{"gif", "jpeg", "jpg"};
        FilteredFileSelectionDialog ffsd = new FilteredFileSelectionDialog(this.getShell(), this.title, null, theExtensions, false);
        ffsd.setInput(this.getRootContainer());
        ffsd.open();
        Object[] results = ffsd.getResult();
        if (results == null || results.length == 0) {
            return;
        }
        if (results[0] != null && results[0] instanceof IFile) {
            IFile f = (IFile)results[0];
            IPath pFull = f.getFullPath();
            IPath pBase = this.getRootContainer().getFullPath();
            IPath newPath = pFull.removeFirstSegments(pBase.segmentCount());
            fileName = newPath.makeAbsolute().toString();
        }
        Widget widget = event.widget;
        if (fileName != null) {
            if (widget == this.smallIconButton_) {
                this.smallIconText_.setText(fileName);
                this.handleSmallIconTextModified();
            } else if (widget == this.largeIconButton_) {
                this.largeIconText_.setText(fileName);
                this.handleLargeIconTextModified();
            }
        }
    }

    private void handleSmallIconTextModified() {
        if (this.smallIconText_ != null && this.smallIconImageLabel_ != null) {
            this.smallIconImageLabel_.setImage(this.getImage(this.smallIconText_.getText()));
        }
    }

    private void handleLargeIconTextModified() {
        if (this.largeIconText_ != null && this.largeIconImageLabel_ != null) {
            this.largeIconImageLabel_.setImage(this.getImage(this.largeIconText_.getText()));
        }
    }

    private Image getImage(String imagePath) {
        Image image = null;
        IFile current = this.validateFileName(imagePath);
        if (current == null || !current.exists()) {
            return null;
        }
        try {
            File file = current.getLocation().toFile();
            image = ImageDescriptor.createFromURL((URL)file.toURL()).createImage();
        }
        catch (MalformedURLException ex) {
            return null;
        }
        catch (SWTException ex) {
            this.messageLabel.setText(CommonAppEJBResourceHandler.ERROR_LOADING_ICON_UI_);
            return null;
        }
        return image;
    }

    public void setEnabled(boolean enabled) {
        this.smallIconImageLabel_.setEnabled(enabled);
        this.largeIconImageLabel_.setEnabled(enabled);
        this.smallIconText_.setEnabled(enabled);
        this.largeIconText_.setEnabled(enabled);
        this.smallIconButton_.setEnabled(enabled);
        this.largeIconButton_.setEnabled(enabled);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.smallIconAdapter_ != null) {
            this.smallIconAdapter_.dispose();
        }
        if (this.largeIconAdapter_ != null) {
            this.largeIconAdapter_.dispose();
        }
    }

    @Override
    public void adaptModel(EObject eObject) {
        if (this.smallIconAdapter_ != null) {
            this.smallIconAdapter_.adapt(eObject);
        }
        if (this.largeIconAdapter_ != null) {
            this.largeIconAdapter_.adapt(eObject);
        }
        this.setEnabled(eObject != null);
    }

    public void setArtifactEdit(ArtifactEdit anArtifactEdit, EObject eObject, EStructuralFeature smallIconFeature, EStructuralFeature largeIconFeature) {
        super.setArtifactEdit(anArtifactEdit);
        this.smallIconFeature_ = smallIconFeature;
        this.largeIconFeature_ = largeIconFeature;
        this.smallIconAdapter_ = new AdapterText(anArtifactEdit, eObject, this.smallIconFeature_, this.smallIconText_, true);
        this.largeIconAdapter_ = new AdapterText(anArtifactEdit, eObject, this.largeIconFeature_, this.largeIconText_, true);
        this.setEnabled(eObject != null);
    }

    protected IFile getFile(String fileName) {
        this.messageLabel.setText("");
        Path currentPath = new Path(fileName);
        IFile file = null;
        try {
            file = this.getRootContainer().getFile((IPath)currentPath);
            if (!fileName.equals("*.gif")) {
                String ext = file.getFileExtension();
                boolean valid = false;
                if (ext != null) {
                    ext = ext.toLowerCase();
                    for (int i = 0; i < extensions.length; ++i) {
                        if (!extensions[i].equals(ext)) continue;
                        valid = true;
                        break;
                    }
                }
                if (!valid) {
                    this.messageLabel.setText(CommonAppEJBResourceHandler.INVALID_ICON_FILE_EXTENSION_UI_);
                    return null;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.messageLabel.setText(CommonAppEJBResourceHandler.ICON_FILE_NOT_EXIST_UI_);
            return null;
        }
        return file;
    }

    protected IFile validateFileName(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            this.messageLabel.setText("");
            return null;
        }
        return this.getFile(fileName);
    }
}

