/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.common;

import com.ibm.etools.webservice.atk.ui.editor.common.FormCommon;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionControlInitializer;
import com.ibm.etools.webtools.flatui.ToggleControl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class SectionCommon
extends FormCommon {
    protected Composite headerComposite;
    protected Composite separatorComposite;
    protected ToggleControl toggle;
    protected boolean readOnly = false;
    protected boolean collapsed;
    protected Composite collapsableClientComposite;

    public SectionCommon(Composite parent, int style, String aTitle, String formInfo, SectionControlInitializer initializer) {
        super(parent, style, aTitle, formInfo, initializer);
    }

    protected SectionControlInitializer getSectionControlInitializer() {
        return (SectionControlInitializer)this.controlInitializer;
    }

    @Override
    public void createPartControl(Composite parent) {
        if (this.controlInitializer == null) {
            this.controlInitializer = this.createDefaultControlInitializer();
        }
        this.setBackground(this.white);
        this.setLayout((Layout)this.commonGridLayout());
        this.setLayoutData(new GridData(768));
        if (this.title != null && this.title.trim().length() > 0) {
            this.headerComposite = this.createHeaderComposite(parent);
        }
        if (this.getSectionControlInitializer().hasSeparator()) {
            this.separatorComposite = this.createSeperatorComposite(parent);
        }
        this.addFormInfoIfNecessary(parent);
        if (this.getSectionControlInitializer().getCollapsable() && this.headerComposite != null) {
            SectionLayout sl = new SectionLayout();
            this.setLayout(sl);
        }
        this.collapsableClientComposite = this.createCollapsableClient(parent);
        this.setupInfopop();
    }

    protected SectionControlInitializer createDefaultControlInitializer() {
        return new SectionControlInitializer();
    }

    protected void launchGenericWizard(IWizard wizard) {
        WizardDialog dialog = new WizardDialog(this.getShell(), wizard);
        dialog.open();
    }

    public void collapse() {
        this.collapsed = true;
        this.layout();
        this.layoutParents((Control)this);
        this.updateScrollPostion();
    }

    public void expand() {
        this.collapsed = false;
        this.layout();
        this.layoutParents((Control)this);
        this.updateScrollPostion();
    }

    public void expandToggle() {
        this.expand();
        this.toggle.setSelection(true);
    }

    protected void updateScrollPostion() {
        if (this.getSectionControlInitializer().isFirstTimeLoad) {
            this.getSectionControlInitializer().isFirstTimeLoad = false;
        } else {
            ScrolledComposite scrollComp = (ScrolledComposite)this.findScrollComposite(this);
            if (scrollComp != null) {
                if (this.inStackComposite) {
                    this.reInitializeScrolledCompositeWithTopControl(scrollComp, this.topControlComposite);
                } else {
                    this.reInitializeScrolledComposite(scrollComp);
                }
                this.moveScrollBar(this, scrollComp);
            }
        }
    }

    @Override
    public Composite createHeaderComposite(Composite parent) {
        Composite aHeaderComposite = this.getWf().createComposite(parent);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 4;
        gl.marginHeight = 0;
        if (this.getSectionControlInitializer().getCollapsable()) {
            gl.numColumns = 2;
            aHeaderComposite.setLayout((Layout)gl);
            aHeaderComposite.setLayoutData((Object)new GridData(768));
            this.toggle = new ToggleControl(aHeaderComposite, 0);
            this.toggle.setBackground(this.getWf().getBackgroundColor());
            this.toggle.setActiveDecorationColor(this.getWf().getHyperlinkColor());
            this.toggle.setDecorationColor(this.getWf().getColor("__compSep"));
            this.toggle.setActiveCursor(this.getWf().getHyperlinkCursor());
            this.toggle.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (SectionCommon.this.collapsed) {
                        SectionCommon.this.expand();
                    } else {
                        SectionCommon.this.collapse();
                    }
                }
            });
        } else {
            gl.numColumns = 1;
            aHeaderComposite.setLayout((Layout)gl);
            aHeaderComposite.setLayoutData((Object)new GridData(768));
        }
        this.headerLabel = this.getWf().createText(aHeaderComposite, this.title, 8);
        this.headerLabel.setBackground(this.white);
        this.headerLabel.setForeground(this.black);
        this.headerLabel.setFont(JFaceResources.getBannerFont());
        if (this.getSectionControlInitializer().getCollapsable()) {
            this.initCollapseState(false);
        }
        return aHeaderComposite;
    }

    public void initCollapseState(boolean collapse) {
        if (collapse) {
            this.collapse();
            this.toggle.setSelection(true);
        } else {
            this.expand();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.headerLabel != null && !this.headerLabel.isDisposed()) {
            this.headerLabel.setFont(JFaceResources.getHeaderFont());
            this.headerLabel.redraw();
            this.layoutParents((Control)this.headerLabel);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected abstract Composite createCollapsableClient(Composite var1);

    class SectionLayout
    extends Layout {
        int vSpacing = 3;
        int sepHeight = 2;

        SectionLayout() {
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flush) {
            int width = 0;
            if (wHint != -1) {
                width = wHint;
            }
            int x = 0;
            int y = 0;
            Point size = null;
            if (SectionCommon.this.headerComposite != null) {
                size = SectionCommon.this.headerComposite.computeSize(-1, -1, flush);
                x = size.x;
                x = Math.max(width, x);
                y += size.y;
            }
            if (SectionCommon.this.separatorComposite != null) {
                size = SectionCommon.this.separatorComposite.computeSize(-1, 2, flush);
                x = size.x;
                x = Math.max(width, x);
                y += size.y;
            }
            if (SectionCommon.this.collapsed) {
                return new Point(x, y + 2);
            }
            if (SectionCommon.this.messageComposite != null) {
                size = SectionCommon.this.messageComposite.computeSize(-1, -1, flush);
                x = size.x;
                x = Math.max(width, x);
                y += size.y;
            }
            if (SectionCommon.this.collapsableClientComposite != null) {
                size = SectionCommon.this.collapsableClientComposite.computeSize(-1, -1, flush);
                x = size.x;
                x = Math.max(width, x);
                y += size.y;
            }
            return new Point(x, y + 2);
        }

        protected void layout(Composite parent, boolean flush) {
            int width = parent.getClientArea().width;
            int y = 0;
            Point size = null;
            if (SectionCommon.this.headerComposite != null) {
                size = SectionCommon.this.headerComposite.computeSize(-1, -1, flush);
                SectionCommon.this.headerComposite.setBounds(0, y, width, size.y);
                SectionCommon.this.headerComposite.setVisible(true);
                y += size.y + 2;
            }
            if (SectionCommon.this.separatorComposite != null) {
                size = SectionCommon.this.separatorComposite.computeSize(-1, 2, flush);
                SectionCommon.this.separatorComposite.setBounds(0, y, width, size.y);
                SectionCommon.this.separatorComposite.setVisible(true);
                y += size.y + 2;
            }
            if (!SectionCommon.this.collapsed) {
                if (SectionCommon.this.messageComposite != null) {
                    size = SectionCommon.this.messageComposite.computeSize(-1, -1, flush);
                    SectionCommon.this.messageComposite.setBounds(0, y, width, size.y);
                    SectionCommon.this.messageComposite.setVisible(true);
                    y += size.y + 2;
                }
                if (SectionCommon.this.collapsableClientComposite != null) {
                    size = SectionCommon.this.collapsableClientComposite.computeSize(-1, -1, flush);
                    SectionCommon.this.collapsableClientComposite.setBounds(0, y, width, size.y);
                    SectionCommon.this.collapsableClientComposite.setVisible(true);
                }
            }
        }
    }
}

