/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.common;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class BorderedImageLabel
extends Canvas {
    private Image image;
    private Color imageBackgroundColor = this.getDisplay().getSystemColor(25);
    private Color borderColor = this.getDisplay().getSystemColor(24);
    private int width;
    private int height;

    public BorderedImageLabel(Composite parent, int style) {
        super(parent, style);
        this.setBackground(this.imageBackgroundColor);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BorderedImageLabel.this.widgetDisposed(e);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                BorderedImageLabel.this.paintControl(e);
            }
        });
    }

    protected void widgetDisposed(DisposeEvent e) {
        if (this.image != null) {
            this.image.dispose();
        }
    }

    protected void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Rectangle bounds = new Rectangle(0, 0, this.width, this.height);
        if (this.imageBackgroundColor != null) {
            gc.setBackground(this.imageBackgroundColor);
            gc.fillRectangle(0, 0, this.width, this.height);
        }
        if (this.image != null) {
            Rectangle imageBounds = this.image.getBounds();
            int x = (this.width - imageBounds.width) / 2;
            int y = (this.height - imageBounds.height) / 2;
            if ((this.getStyle() & 0x800) != 0) {
                x -= 2;
                y -= 2;
            }
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            gc.drawImage(this.image, x, y);
        }
        if ((this.getStyle() & 0x800) != 0) {
            gc.setForeground(this.borderColor);
            gc.drawRectangle(bounds);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.redraw();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.redraw();
    }

    public Color getImageBackgroundColor() {
        return this.imageBackgroundColor;
    }

    public void setImageBackgroundColor(Color imageBackgroundColor) {
        if (imageBackgroundColor == null) {
            return;
        }
        this.imageBackgroundColor = imageBackgroundColor;
        this.redraw();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            return;
        }
        this.borderColor = borderColor;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.width, this.height);
    }
}

