/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.common;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.webservice.atk.ui.editor.IAbstractMultiPageEditor;
import com.ibm.etools.webservice.atk.ui.editor.IPage;
import com.ibm.etools.webservice.atk.ui.editor.IPageContainer;
import com.ibm.etools.webservice.atk.ui.editor.common.ErrorPageContainer;
import com.ibm.etools.webservice.atk.ui.editor.common.PageCollection;
import com.ibm.etools.webservice.atk.ui.editor.common.PageItem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.internal.webservice.WebServicesNavigatorSynchronizer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public abstract class AbstractMultiPageEditor
extends MultiPageEditorPart
implements IAbstractMultiPageEditor {
    protected final String XML_EDITOR_ID = "com.ibm.sed.editor.StructuredTextMultiPageEditorPart";
    protected final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    protected IFile fFile;
    protected IProject fProject;
    protected ArtifactEdit artifactEdit;
    protected boolean fInitializedEditModel = false;
    protected ErrorPageContainer fErrorPageContainer = null;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("InvalidInput");
        }
        super.init(site, editorInput);
        this.fFile = ((IFileEditorInput)this.getEditorInput()).getFile();
        this.fProject = this.fFile.getProject();
    }

    @Override
    public ArtifactEdit getArtifactEdit() {
        return this.artifactEdit;
    }

    protected void createPages() {
        this.initialize();
        this.primCreatePages();
        this.setActivePage(0);
        if (!this.fInitializedEditModel) {
            this.openRedirectedEditor();
        }
    }

    protected void primCreatePages() {
        if (this.fInitializedEditModel) {
            PageItem[] items = this.getPageCollection().getItemsSortByIndex();
            for (int i = 0; i < items.length; ++i) {
                IPageContainer pageContainer = items[i].getPageContainer();
                Control page = pageContainer.getPage(this, this.artifactEdit, this.getContainer());
                if (page == null) continue;
                int pageIndex = this.addPage(pageContainer.getPage(this, this.artifactEdit, this.getContainer()));
                this.setPageText(pageIndex, items[i].getName());
            }
        } else {
            this.fErrorPageContainer = new ErrorPageContainer();
            this.addPage(this.fErrorPageContainer.getPage(this, this.artifactEdit, this.getContainer()));
        }
    }

    protected abstract PageCollection getPageCollection();

    protected void initialize() {
        this.initializeArtifactEdit();
    }

    public void doSave(IProgressMonitor monitor) {
        this.artifactEdit.save(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return ((ArtifactEditModel)this.getArtifactEdit().getAdapter(ArtifactEditModel.ADAPTER_TYPE)).isDirty();
    }

    @Override
    public abstract void initializeArtifactEdit();

    public void editModelChanged(EditModelEvent anEvent) {
        int code = anEvent.getEventCode();
        switch (code) {
            case 3: 
            case 5: {
                this.closeEditorWithSaveOption();
                break;
            }
            default: {
                if (code == 4 || code == 6) break;
                this.syncFirePropertyChange(257);
            }
        }
    }

    private void syncFirePropertyChange(final int anInt) {
        Display d = null;
        try {
            if (!this.getContainer().isDisposed()) {
                d = this.getContainer().getDisplay();
            }
        }
        catch (Exception e) {
            J2EEUIPlugin.logError(e);
        }
        if (d != Display.getCurrent() && d != null) {
            d.syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractMultiPageEditor.this.firePropertyChange(anInt);
                }
            });
        } else {
            this.firePropertyChange(anInt);
        }
    }

    public boolean isDirty() {
        if (this.artifactEdit == null) {
            return false;
        }
        return ((ArtifactEditModel)this.artifactEdit.getAdapter(ArtifactEditModel.ADAPTER_TYPE)).isDirty();
    }

    public void dispose() {
        super.dispose();
        if (this.fInitializedEditModel) {
            PageItem[] items = this.getPageCollection().getItemsSortByIndex();
            for (int i = 0; i < items.length; ++i) {
                IPageContainer pageContainer = items[i].getPageContainer();
                Control page = pageContainer.getPage(this, this.artifactEdit, this.getContainer());
                if (page == null) continue;
                page.dispose();
            }
        } else {
            this.fErrorPageContainer.getPage(this, this.artifactEdit, this.getContainer()).dispose();
        }
        WebServicesNavigatorSynchronizer synchronizer = WebServicesNavigatorSynchronizer.getInstance();
        if (this.artifactEdit != null) {
            EObject root = this.artifactEdit.getContentModelRoot();
            if (synchronizer != null && root != null) {
                root.eAdapters().remove((Object)synchronizer);
            }
            this.artifactEdit.removeListener((EditModelListener)this);
            this.artifactEdit.dispose();
        }
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
    }

    @Override
    public int findPageIndexByPageId(String pageId) {
        PageItem[] items = this.getPageCollection().getItemsSortByIndex();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getId().equals(pageId)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IPage getPageById(String pageId) {
        int index = this.findPageIndexByPageId(pageId);
        if (index != -1) {
            return (IPage)this.getControl(index);
        }
        return null;
    }

    @Override
    public void pageChangeByPageId(String pageId) {
        int index = this.findPageIndexByPageId(pageId);
        if (index != -1) {
            this.pageChange(index);
            this.setActivePage(index);
        }
    }

    public void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractMultiPageEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)AbstractMultiPageEditor.this, false);
            }
        });
    }

    protected void closeEditorWithSaveOption() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean save;
                if (AbstractMultiPageEditor.this.artifactEdit.isDirty() && (save = MessageDialog.openQuestion(null, (String)J2EEUIPlugin.getResourceString("%TITLE_CLOSE"), (String)J2EEUIPlugin.getResourceString("%MSG_SAVE_CONTENTS", new String[]{AbstractMultiPageEditor.this.fFile.getFullPath().toString()})))) {
                    AbstractMultiPageEditor.this.artifactEdit.save(null);
                }
                AbstractMultiPageEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)AbstractMultiPageEditor.this, false);
            }
        });
    }

    protected void openRedirectedEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractMultiPageEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)AbstractMultiPageEditor.this, false);
                MessageDialog.openError(null, (String)J2EEUIPlugin.getResourceString("%TITLE_REDIRECT"), (String)J2EEUIPlugin.getResourceString("%MSG_REDIRECT_ERROR"));
                IWorkbenchPage page = null;
                try {
                    page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.openEditor(AbstractMultiPageEditor.this.getEditorInput(), AbstractMultiPageEditor.this.getRedirectedEditorID());
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)J2EEUIPlugin.getResourceString("%MSG_OPEN_EDITOR2_ERROR"), (String)e.toString());
                }
            }
        });
    }

    protected String getRedirectedEditorID() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            return "com.ibm.sed.editor.StructuredTextMultiPageEditorPart";
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }
}

