/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.web.ui.actions;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import com.ibm.etools.javaee.project.facet.IEJBinWARCreateDeploymentFilesDataModelProperties;
import com.ibm.etools.javaee.web.internal.provider.EJBJarInWarItemProvider;
import com.ibm.etools.web.ui.nls.WebUIResourceHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.actions.BaseAction;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class CreateEJBDeploymentFilesActionDelegate
extends BaseAction {
    public void selectionChanged(IAction action, ISelection aSelection) {
        super.selectionChanged(action, aSelection);
        boolean isEnabled = false;
        if (aSelection != null) {
            IStructuredSelection structuredSelection = (IStructuredSelection)aSelection;
            Object selectedObject = structuredSelection.getFirstElement();
            if (selectedObject instanceof EJBJarInWarItemProvider) {
                EJBJarInWarItemProvider object = (EJBJarInWarItemProvider)((Object)selectedObject);
                IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)object.getCachedEJBJar()));
                if (resource == null) {
                    return;
                }
                IProject project = resource.getProject();
                isEnabled = this.isValidSelection(project, null);
            } else {
                isEnabled = this.isValidSelection(JavaEEProjectUtilities.getProject((Object)structuredSelection.getFirstElement()), null);
            }
        }
        this.setEnabled(isEnabled);
        action.setEnabled(isEnabled);
    }

    private boolean isValidSelection(IProject project, Shell shell) {
        int j2eeFacetVersion;
        IProjectFacetVersion webFacetVersion;
        boolean retVal = false;
        if (project != null && (webFacetVersion = JavaEEProjectUtilities.getProjectFacetVersion((IProject)project, (String)"jst.web")) != null && (j2eeFacetVersion = J2EEVersionUtil.convertVersionStringToInt((String)webFacetVersion.getVersionString())) >= 30) {
            retVal = !this.hasDeploymentDescriptor(project, shell);
        }
        return retVal;
    }

    private boolean hasDeploymentDescriptor(IProject project, Shell shell) {
        boolean ret = true;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component.getRootFolder() != null && component.getRootFolder().getUnderlyingFolder() != null) {
            IFile ddXmlFile = component.getRootFolder().getUnderlyingFolder().getFile(IJEE5ModelProvider.EJB_IN_WAR_DD_MODEL_XML_NODEVICE);
            ret = ddXmlFile.exists();
            if (shell != null && ret) {
                MessageDialog.openInformation((Shell)shell, (String)WebUIResourceHandler.INVALID_SELECTION_TITLE, (String)WebUIResourceHandler.INFORM_INVALID_WEB_EJB_SELECTION);
            }
        }
        return ret;
    }

    protected void primRun(Shell shell) {
        IProject project = null;
        Object selectedObject = this.selection.getFirstElement();
        if (selectedObject instanceof EJBJarInWarItemProvider) {
            EJBJarInWarItemProvider object = (EJBJarInWarItemProvider)((Object)selectedObject);
            IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)object.getCachedEJBJar()));
            if (resource == null) {
                return;
            }
            project = resource.getProject();
        } else {
            project = JavaEEProjectUtilities.getProject((Object)this.selection.getFirstElement());
        }
        if (project != null && this.isValidSelection(project, shell)) {
            try {
                IDataModel dataModel = DataModelFactory.createDataModel(IEJBinWARCreateDeploymentFilesDataModelProperties.class);
                dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)project);
                dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                J2EEUIPlugin.logError(e);
            }
        }
    }
}

