/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ui.navigator.framework;

import com.ibm.etools.annotations.core.Activator;
import com.ibm.etools.annotations.core.AnnotationsCoreConstants;
import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfosRepository;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.annotations.core.utils.ResourceUtils;
import com.ibm.etools.jee.ui.navigator.internal.WebSocketNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;

public class WebSocketUtil {
    private WebSocketUtil() {
    }

    public static Collection getWebSocketEndpoints(Object object) {
        final ArrayList<WebSocketNode> result = new ArrayList<WebSocketNode>();
        final ArrayList addedList = new ArrayList();
        String socketAnnotation = "ServerEndpoint";
        String mainServletAtt = "value";
        IProject project = JavaEEProjectUtilities.getProject((Object)object);
        AnnotatedProjectInfo projectAntns = AnnotatedProjectInfosRepository.getInstance().getAnnotatedProjectInfoForWeb(project, false, true);
        AnnotatedClassInfo[] pkgAntns = projectAntns.getAnnotatedClassInfos("ServerEndpoint");
        boolean found = false;
        for (int i = 0; i < pkgAntns.length; ++i) {
            AnnotatedClassInfo aci = pkgAntns[i];
            List objs = AnnotationUtils.getAnnotationInfosForJavaElementInfo((AnnotatedClassInfo)aci, (boolean)false);
            Iterator objIter = objs.iterator();
            found = false;
            while (objIter.hasNext() && !found) {
                AnnotationInfo ai = (AnnotationInfo)objIter.next();
                if (!ai.getAnnotationName().equalsIgnoreCase("ServerEndpoint")) continue;
                SingleValueArgumentProperty ap = (SingleValueArgumentProperty)ai.getAttribute("value");
                String socketName = (String)ap.getValue();
                if (socketName == null) {
                    socketName = (String)ap.getImpliedValue();
                }
                if (socketName == null) continue;
                WebSocketNode wsn = new WebSocketNode(aci, socketName);
                result.add(wsn);
                found = true;
            }
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        SearchPattern pattern = SearchPattern.createPattern((String)"javax.websocket.Endpoint", (int)0, (int)1, (int)8);
        SuperTypeReferencePattern superPattern = new SuperTypeReferencePattern("javax.websocket".toCharArray(), "Endpoint".toCharArray(), 2, 8);
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getElement() instanceof IType) {
                    IType t = (IType)match.getElement();
                    IJavaElement ije = t.getParent();
                    ((IOpenable)ije).open((IProgressMonitor)new NullProgressMonitor());
                    String sPack = t.getPackageFragment().getElementName();
                    String name = t.getElementName();
                    if (!addedList.contains(t)) {
                        WebSocketNode wsn = new WebSocketNode(t, name);
                        result.add(wsn);
                        addedList.add(t);
                    }
                }
            }
        };
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        try {
            SearchEngine se = new SearchEngine();
            IJavaElement[] els = new IJavaElement[]{javaProject};
            ArrayList<IJavaElement> ar = WebSocketUtil.getIJavaElementsForClassPathEntries(javaProject);
            IJavaElement[] arEls = new IJavaElement[ar.size()];
            arEls = ar.toArray(arEls);
            se.search(pattern, participants, SearchEngine.createJavaSearchScope((IJavaElement[])els), requestor, (IProgressMonitor)new NullProgressMonitor());
            se.search((SearchPattern)superPattern, participants, SearchEngine.createJavaSearchScope((IJavaElement[])arEls), requestor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ArrayList<IJavaElement> getIJavaElementsForClassPathEntries(IJavaProject pr) {
        ArrayList<IJavaElement> ar = new ArrayList<IJavaElement>();
        try {
            IClasspathEntry[] entries;
            for (IClasspathEntry ice : entries = pr.getRawClasspath()) {
                IPackageFragmentRoot[] roots;
                String sPath;
                if (ice.getEntryKind() == 1 || ice.getEntryKind() == 3) {
                    IJavaElement newEl;
                    if (ice.getPath().isValidSegment(".apt_generated")) continue;
                    IPath path = ice.getPath();
                    IPackageFragmentRoot root = pr.findPackageFragmentRoot(path.makeAbsolute());
                    if (root != null) {
                        ar.add((IJavaElement)root);
                        continue;
                    }
                    IResource ir = ResourceUtils.getWorkspace().getRoot().findMember(path);
                    if (ir == null || (newEl = JavaCore.create((IResource)ir)) == null) continue;
                    if (newEl instanceof IJavaProject) {
                        IPackageFragmentRoot[] packFragRoots = pr.findPackageFragmentRoots(ice);
                        Activator.debug((String)"      Adding package fragments for project where root folder is marked as source");
                        ar.addAll(Arrays.asList(packFragRoots));
                        continue;
                    }
                    Activator.debug((String)("      Adding: " + path.toOSString()));
                    ar.add(newEl);
                    continue;
                }
                if (ice.getEntryKind() != 5 || AnnotationsCoreConstants.stopSCanningContainers_ || (sPath = ice.getPath().toOSString()).indexOf("org.eclipse.jst.server.core.container") >= 0 || sPath.indexOf("JRE_CONTAINER") >= 0) continue;
                if (AnnotationsCoreConstants.excludedContainers_ != null) {
                    boolean shouldBeIgnored = false;
                    for (String excludedContainer : AnnotationsCoreConstants.excludedContainers_) {
                        if (sPath.indexOf(excludedContainer) == -1) continue;
                        shouldBeIgnored = true;
                        break;
                    }
                    if (shouldBeIgnored) continue;
                }
                if ((roots = pr.findPackageFragmentRoots(ice)) == null || roots.length <= 0) continue;
                ar.addAll(Arrays.asList(roots));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ar;
    }
}

