/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ui.navigator.framework;

import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.jee.ui.navigator.internal.WebSocketRootNode;
import com.ibm.etools.ui.navigator.framework.WebSocketUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.j2ee.navigator.internal.EMFRootObjectProvider;

public class WebSocketRootObjectProvider
extends EMFRootObjectProvider {
    private final HashSet initializedProjectCache = new HashSet();
    private static final int WEB_PROJECT_TYPE = 2;

    public void dispose() {
        this.initializedProjectCache.clear();
        super.dispose();
    }

    public Object[] getModels(IProject project) {
        ArrayList<WebSocketRootNode> children = new ArrayList<WebSocketRootNode>();
        this.waitForAnnotationModelInitialization(project);
        if (!WebSocketUtil.getWebSocketEndpoints(project).isEmpty()) {
            children.add(WebSocketRootNode.createRootNode(project));
            this.initializedProjectCache.add(project);
        }
        return children.toArray();
    }

    private void waitForAnnotationModelInitialization(IProject project) {
        IJobManager jobManager = Job.getJobManager();
        Job updateJob = AnnotationUtils.findAnnotationModelUpdateJob((IJobManager)jobManager, (IProject)project, (int)2);
        while (updateJob != null) {
            try {
                updateJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                return;
            }
            updateJob = AnnotationUtils.findAnnotationModelUpdateJob((IJobManager)jobManager, (IProject)project, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLoadedModels(IProject project) {
        HashSet hashSet = this.initializedProjectCache;
        synchronized (hashSet) {
            return this.initializedProjectCache.contains(project);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        boolean retVal = super.visit(delta);
        if (resource != null) {
            switch (resource.getType()) {
                case 4: {
                    boolean projectOpenStateChanged;
                    boolean bl = projectOpenStateChanged = (delta.getFlags() & 0x4000) != 0;
                    if (delta.getKind() != 2 && !projectOpenStateChanged) break;
                    IProject project = (IProject)resource;
                    WebSocketRootNode.disposeRootNode(project);
                }
            }
        }
        return retVal;
    }
}

