/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.project.workingset;

import com.ibm.etools.project.workingset.JEEWorkingSetPageContentProvider;
import com.ibm.etools.project.workingset.WorkingSetMessages;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class JEEWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_ID = "jeeWorkingSetPage";
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private ITreeContentProvider fTreeContentProvider;
    private boolean fFirstCheck;
    private IWorkingSet fWorkingSet;
    private String[] facetTypes;

    public JEEWorkingSetPage(String pageTitle, String aFacetType, ImageDescriptor imgDescriptor) {
        super(PAGE_ID, pageTitle, imgDescriptor);
        this.setDescription(WorkingSetMessages.JEEWorkingSetPage_Description);
        this.fFirstCheck = true;
        this.facetTypes = new String[]{aFacetType};
    }

    public JEEWorkingSetPage(String pageTitle, String[] theFacetTypes, ImageDescriptor imgDescriptor) {
        super(PAGE_ID, pageTitle, imgDescriptor);
        this.setDescription(WorkingSetMessages.JEEWorkingSetPage_Description);
        this.fFirstCheck = true;
        this.facetTypes = theFacetTypes;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.JEEWorkingSetPage_Set_Name);
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JEEWorkingSetPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(WorkingSetMessages.JEEWorkingSetPage_Set_COntent);
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fTree = new CheckboxTreeViewer(composite, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTreeContentProvider = new JEEWorkingSetPageContentProvider(this.facetTypes);
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fTree.setComparator((ViewerComparator)new ResourceComparator(1));
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JEEWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(WorkingSetMessages.JEEWorkingSetPage_SelectAll);
        selectAllButton.setToolTipText(WorkingSetMessages.JEEWorkingSetPage_SelectAllToolTip);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JEEWorkingSetPage.this.fTree.setCheckedElements(JEEWorkingSetPage.this.fTreeContentProvider.getElements(JEEWorkingSetPage.this.fTree.getInput()));
                JEEWorkingSetPage.this.validateInput();
            }
        });
        selectAllButton.setLayoutData((Object)new GridData());
        JEEWorkingSetPage.setButtonDimensionHint(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(WorkingSetMessages.JEEWorkingSetPage_DeSelectAll);
        deselectAllButton.setToolTipText(WorkingSetMessages.JEEWorkingSetPage_DeSelectAllToolTip);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JEEWorkingSetPage.this.fTree.setCheckedElements(new Object[0]);
                JEEWorkingSetPage.this.validateInput();
            }
        });
        deselectAllButton.setLayoutData((Object)new GridData());
        JEEWorkingSetPage.setButtonDimensionHint(deselectAllButton);
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite);
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    public void finish() {
        Object[] checked = this.fTree.getCheckedElements();
        List<Object> list = Arrays.asList(checked);
        String workingSetName = this.fWorkingSetName.getText().trim();
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, list.toArray(new IAdaptable[list.size()]));
        } else {
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(list.toArray(new IAdaptable[list.size()]));
        }
    }

    private void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.JEEWorkingSetPage_warning_nameWhitespace;
        }
        if (newText.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = WorkingSetMessages.JEEWorkingSetPage_warning_nameMustNotBeEmpty;
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            for (int i = 0; i < workingSets.length; ++i) {
                if (!newText.equals(workingSets[i].getName())) continue;
                errorMessage = WorkingSetMessages.JEEWorkingSetPage_warning_workingSetExists;
            }
        }
        if (!this.hasCheckedElement()) {
            infoMessage = WorkingSetMessages.JEEWorkingSetPage_warning_resourceMustBeChecked;
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private boolean hasCheckedElement() {
        TreeItem[] items = this.fTree.getTree().getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getChecked()) continue;
            return true;
        }
        return false;
    }

    private void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IAdaptable element = (IAdaptable)event.getElement();
                boolean state = event.getChecked();
                JEEWorkingSetPage.this.fTree.setGrayed((Object)element, false);
                JEEWorkingSetPage.this.updateParentState(element, state);
                JEEWorkingSetPage.this.validateInput();
            }
        });
    }

    private void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        if (!(parent instanceof IAdaptable)) {
            return;
        }
        IContainer container = (IContainer)((IAdaptable)parent).getAdapter(IContainer.class);
        if (!this.fTree.getExpandedState(parent) && checkExpandedState || container != null && !container.isAccessible()) {
            return;
        }
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        for (int i = children.length - 1; i >= 0; --i) {
            Object element = children[i];
            if (state) {
                this.fTree.setChecked(element, true);
                this.fTree.setGrayed(element, false);
            } else {
                this.fTree.setGrayChecked(element, false);
            }
            if (!this.isExpandable(element)) continue;
            this.setSubtreeChecked(element, state, true);
        }
    }

    private void updateParentState(Object child, boolean baseChildState) {
        IResource resource;
        if (child == null) {
            return;
        }
        if (child instanceof IAdaptable && (resource = (IResource)((IAdaptable)child).getAdapter(IResource.class)) != null && !resource.isAccessible()) {
            return;
        }
        Object parent = this.fTreeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.fTreeContentProvider.getChildren(parent);
        for (int i = children.length - 1; i >= 0; --i) {
            if (this.fTree.getChecked(children[i]) == baseChildState && !this.fTree.getGrayed(children[i])) continue;
            allSameState = false;
            break;
        }
        this.fTree.setGrayed(parent, !allSameState);
        this.fTree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Object element;
                int i;
                Object[] elements;
                if (JEEWorkingSetPage.this.fWorkingSet == null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page == null) {
                        return;
                    }
                    IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                    if (part == null) {
                        return;
                    }
                    try {
                        elements = JEEWorkingSetPage.getStructuredSelection(part).toArray();
                        for (int i2 = 0; i2 < elements.length; ++i2) {
                            IJavaElement je;
                            if (!(elements[i2] instanceof IResource) || (je = (IJavaElement)((IResource)elements[i2]).getAdapter(IJavaElement.class)) == null || !je.exists() || !je.getJavaProject().isOnClasspath((IResource)elements[i2])) continue;
                            elements[i2] = je;
                        }
                    }
                    catch (JavaModelException e) {
                        return;
                    }
                } else {
                    elements = JEEWorkingSetPage.this.fWorkingSet.getElements();
                }
                for (i = 0; i < elements.length; ++i) {
                    IJavaProject jProject;
                    IProject project;
                    element = elements[i];
                    if (element instanceof IResource && !(project = ((IResource)element).getProject()).isAccessible()) {
                        elements[i] = project;
                    }
                    if (!(element instanceof IJavaElement) || (jProject = ((IJavaElement)element).getJavaProject()) == null || jProject.getProject().isAccessible()) continue;
                    elements[i] = jProject.getProject();
                }
                JEEWorkingSetPage.this.fTree.setCheckedElements(elements);
                for (i = 0; i < elements.length; ++i) {
                    element = elements[i];
                    if (JEEWorkingSetPage.this.isExpandable(element)) {
                        JEEWorkingSetPage.this.setSubtreeChecked(element, true, true);
                    }
                    JEEWorkingSetPage.this.updateParentState(element, true);
                }
            }
        });
    }

    private boolean isExpandable(Object element) {
        return false;
    }

    public static void setButtonDimensionHint(Button button) {
        Object gd;
        if (button != null && (gd = button.getLayoutData()) instanceof GridData) {
            ((GridData)gd).widthHint = JEEWorkingSetPage.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws JavaModelException {
        ISelection selection;
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }
}

