/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jee.ui.navigator.internal;

import com.ibm.etools.jee.ui.navigator.internal.EMFRootObjectProvider;
import com.ibm.etools.jee.ui.navigator.internal.LoadingWebSocketNode;
import com.ibm.etools.jee.ui.navigator.internal.WebSocketNode;
import com.ibm.etools.jee.ui.navigator.internal.WebSocketRootNode;
import com.ibm.etools.ui.navigator.framework.WebSocketRootObjectProvider;
import com.ibm.etools.ui.navigator.framework.WebSocketUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.navigator.internal.EMFRootObjectProvider;
import org.eclipse.jst.j2ee.navigator.internal.LoadingDDJob;
import org.eclipse.jst.j2ee.navigator.internal.LoadingDDNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;

public class WebSocketContentProvider
implements ITreeContentProvider,
EMFRootObjectProvider.IRefreshHandlerListener {
    private String viewerId = null;
    private AbstractTreeViewer viewer;
    private WebSocketRootNode rootNode;
    private final EMFRootObjectProvider rootObjectProvider = new WebSocketRootObjectProvider();
    private static final Map placeHolders = new HashMap();

    public WebSocketContentProvider() {
    }

    public WebSocketContentProvider(String aViewerId) {
    }

    public boolean hasChildren(Object element) {
        boolean retVal = false;
        if (element instanceof WebSocketRootNode) {
            retVal = true;
        } else if (element instanceof WebSocketNode) {
            retVal = false;
        }
        return retVal;
    }

    public Object[] getChildren(Object aParentElement) {
        IProject project = null;
        Collection<WebSocketRootNode> children = new ArrayList();
        if (aParentElement instanceof WebSocketRootNode) {
            children = WebSocketUtil.getWebSocketEndpoints(((WebSocketRootNode)((Object)aParentElement)).getProject());
        } else if (aParentElement instanceof IAdaptable && !(aParentElement instanceof EObject) && !(aParentElement instanceof ItemProvider)) {
            project = (IProject)((IAdaptable)aParentElement).getAdapter(IProject.class);
            if (LoadingWebSocketNode.isBeingLoaded(project)) {
                children.add((WebSocketRootNode)((Object)LoadingWebSocketNode.createPlaceHolder(project)));
            } else if (this.rootObjectProvider.hasLoadedModels(project)) {
                this.rootNode = WebSocketRootNode.createRootNode(project);
                children.add(this.rootNode);
            } else if (project != null) {
                LoadingWebSocketNode placeHolder = LoadingWebSocketNode.createPlaceHolder(project);
                if (LoadingWebSocketNode.canBeginLoading(project)) {
                    new LoadingDDJob(this.viewer, (LoadingDDNode)placeHolder, (IAdaptable)aParentElement, this.rootObjectProvider).schedule();
                }
                children.add((WebSocketRootNode)((Object)placeHolder));
            }
        }
        return children.toArray();
    }

    public void dispose() {
        this.rootNode = null;
        placeHolders.clear();
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        String newViewerId = null;
        this.viewer = (AbstractTreeViewer)aViewer;
        if (aViewer instanceof CommonViewer) {
            newViewerId = ((CommonViewer)aViewer).getNavigatorContentService().getViewerId();
        }
        if (!(newViewerId == null || this.viewerId != null && this.viewerId.equals(newViewerId))) {
            this.updateContentProviders(newViewerId);
        }
    }

    private void updateContentProviders(String aViewerId) {
        this.viewerId = aViewerId;
    }

    @Override
    public void onRefresh(final Object element) {
        if (Display.getCurrent() != null) {
            this.viewer.refresh(element, true);
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!WebSocketContentProvider.this.viewer.getControl().isDisposed()) {
                        WebSocketContentProvider.this.viewer.refresh(element, true);
                    }
                }
            });
        }
    }

    public Object[] getElements(Object anInputElement) {
        return this.getChildren(anInputElement);
    }

    public Object getParent(Object element) {
        return null;
    }
}

