/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jee.ui.navigator.internal;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.jee.ui.navigator.internal.EMFModelManager;
import com.ibm.etools.jee.ui.navigator.internal.EMFRootObjectProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;

public class FlexibleEMFModelManager
extends EMFModelManager
implements IModelProviderListener {
    private List rootObjects = new ArrayList();
    private static final Object[] EMPTY_OBJECT = new Object[0];
    private final List modelProviders = new ArrayList();
    private final Map modelProvidersToRootObject = new HashMap();

    public FlexibleEMFModelManager(IProject aProject, EMFRootObjectProvider provider) {
        super(aProject, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getModels() {
        try {
            IProject project = this.getProject();
            if (project == null || !project.isAccessible()) {
                return EMPTY_OBJECT;
            }
            List list = this.rootObjects;
            synchronized (list) {
                if (!this.isValid(this.rootObjects)) {
                    this.rootObjects = this.getRootObjects();
                }
            }
        }
        catch (Exception ex) {
            J2EEUIPlugin.logError(ex);
        }
        if (this.rootObjects != null) {
            return this.rootObjects.toArray();
        }
        return EMPTY_OBJECT;
    }

    private boolean isValid(List rootObjects) {
        if (rootObjects == null || rootObjects.size() == 0) {
            return false;
        }
        for (int x = 0; x < rootObjects.size(); ++x) {
            EObject eObject = (EObject)rootObjects.get(x);
            if (eObject == null || eObject.eResource() != null) continue;
            return false;
        }
        return true;
    }

    private List getRootObjects() {
        List mods = this.getModelProviders();
        ArrayList<EObject> flexibleObjects = new ArrayList<EObject>();
        IModelProvider mod = null;
        EObject contentModelRoot = null;
        for (int x = 0; x < mods.size(); ++x) {
            mod = (IModelProvider)mods.get(x);
            contentModelRoot = (EObject)mod.getModelObject();
            if (contentModelRoot == null) continue;
            flexibleObjects.add(contentModelRoot);
            if (!this.rootObjects.contains(contentModelRoot)) {
                this.rootObjects.add(contentModelRoot);
            }
            this.modelProvidersToRootObject.put(mod, contentModelRoot);
        }
        return flexibleObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getModelProviders() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        List list = this.modelProviders;
        synchronized (list) {
            if (this.modelProviders.size() == 0 && project.isAccessible()) {
                IModelProvider model = null;
                try {
                    model = ModelProviderManager.getModelProvider((IProject)project);
                    if (model != null) {
                        this.modelProviders.add(model);
                        model.addListener((IModelProviderListener)this);
                    }
                }
                catch (Exception e) {
                    J2EEUIPlugin.logError(e);
                }
            }
        }
        return this.modelProviders;
    }

    @Override
    public void dispose() {
        if (this.modelProviders != null) {
            for (int x = 0; x < this.modelProviders.size(); ++x) {
                IModelProvider model = (IModelProvider)this.modelProviders.get(x);
                if (model == null) continue;
                model.removeListener((IModelProviderListener)this);
            }
        }
        this.rootObjects.clear();
        this.modelProviders.clear();
        this.modelProvidersToRootObject.clear();
    }

    public void modelsChanged(IModelProviderEvent anEvent) {
        IProject affectedProject = anEvent.getProject();
        switch (anEvent.getEventCode()) {
            case 64: {
                Object oldRootObject = this.removeRootObject(anEvent.getModel(), affectedProject);
                this.dispose(anEvent.getModel(), affectedProject);
                this.getRootObjects();
                if (oldRootObject == null) break;
                this.notifyListeners(affectedProject);
                break;
            }
            case 4: {
                this.removeRootObject(anEvent.getModel(), affectedProject);
                this.dispose(anEvent.getModel(), affectedProject);
                break;
            }
            case 1: {
                Object oldRootObject = this.getRootObject(affectedProject);
                if (oldRootObject != null) break;
                this.notifyListeners(affectedProject);
                break;
            }
            case 16: {
                this.dispose(anEvent.getModel(), affectedProject);
                break;
            }
        }
    }

    private Object getRootObject(IProject project) {
        IModelProvider mod = this.getModel(project);
        if (mod != null) {
            return this.modelProvidersToRootObject.get(mod);
        }
        return null;
    }

    private Object removeRootObject(IModelProvider model, IProject project) {
        IModelProvider mod = this.getModel(project);
        if (mod != null) {
            this.rootObjects.remove(this.modelProvidersToRootObject.get(mod));
            this.modelProvidersToRootObject.remove(mod);
        }
        return mod;
    }

    private void dispose(IModelProvider model, IProject project) {
        if (this.hasModelProvider(model)) {
            model.removeListener((IModelProviderListener)this);
            this.modelProviders.remove(model);
            this.modelProvidersToRootObject.get(model);
            this.modelProvidersToRootObject.remove(model);
        }
    }

    private boolean hasModelProvider(IModelProvider model) {
        return this.modelProviders.contains(model);
    }

    private IModelProvider getModel(IProject project) {
        if (this.modelProviders != null && !this.modelProviders.isEmpty()) {
            return (IModelProvider)this.modelProviders.get(0);
        }
        return null;
    }
}

