/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jee.ui.navigator.internal;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.jee.ui.navigator.internal.EMFModelManager;
import com.ibm.etools.jee.ui.navigator.internal.EMFModelManagerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;

public class EMFRootObjectProvider
implements IResourceChangeListener,
IResourceDeltaVisitor,
IElementChangedListener {
    private final HashMap emfModelCache = new HashMap();
    private final List listeners = new ArrayList();
    private boolean enableTestFix;

    public EMFRootObjectProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        IEclipsePreferences j2eeUIPrefs = new InstanceScope().getNode("com.ibm.etools.j2ee.ui");
        this.enableTestFix = j2eeUIPrefs.getBoolean("com.ibm.etools.j2ee.preferences.enterpriseExplorerRefreshFix", false);
        if (J2EEUIPlugin.getDefault().isDebugging() && this.enableTestFix) {
            J2EEUIPlugin.logInfo("Enterprise Explorer Testfix enabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getModels(IProject project) {
        try {
            EMFModelManager modelManager = null;
            HashMap hashMap = this.emfModelCache;
            synchronized (hashMap) {
                modelManager = (EMFModelManager)this.emfModelCache.get(project);
                if (modelManager == null) {
                    modelManager = EMFModelManagerFactory.createEMFModelManager(project, this);
                    this.emfModelCache.put(project, modelManager);
                }
            }
            return modelManager.getModels();
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLoadedModels(IProject project) {
        HashMap hashMap = this.emfModelCache;
        synchronized (hashMap) {
            return this.emfModelCache.get(project) != null;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                J2EEUIPlugin.logError(e);
            }
            catch (SWTException swte) {
                J2EEUIPlugin.logError(swte);
            }
            catch (SWTError swte) {
                J2EEUIPlugin.logError(swte);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    boolean projectBeingClosed;
                    IProject project = (IProject)resource;
                    boolean bl = projectBeingClosed = (delta.getFlags() & 0x4000) != 0 && !project.isOpen();
                    if (delta.getKind() == 2 || projectBeingClosed) {
                        this.dispose(project);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private void dispose(IProject project) {
        if (project == null) {
            return;
        }
        EMFModelManager modelManager = (EMFModelManager)this.emfModelCache.remove(project);
        if (modelManager != null) {
            modelManager.dispose();
            modelManager = null;
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        EMFModelManager modelManager = null;
        Object[] keys = this.emfModelCache.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            modelManager = (EMFModelManager)this.emfModelCache.remove(keys[i]);
            if (modelManager == null) continue;
            modelManager.dispose();
        }
    }

    public void notifyListeners(IProject aProject) {
        for (int x = 0; x < this.listeners.size(); ++x) {
            IRefreshHandlerListener refreshHandler = (IRefreshHandlerListener)this.listeners.get(x);
            refreshHandler.onRefresh(aProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.getListeners();
        synchronized (list) {
            if (aListener != null && !this.getListeners().contains(aListener)) {
                this.getListeners().add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(aListener);
        }
    }

    protected List getListeners() {
        return this.listeners;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (!this.enableTestFix) {
            this.processDelta(event.getDelta());
        } else {
            this.processDeltaWithFix(event.getDelta());
        }
    }

    private void processDelta(IJavaElementDelta delta) {
        IJavaElement jElement = delta.getElement();
        int type = jElement.getElementType();
        if (type == 1) {
            IJavaElementDelta[] deltas = delta.getChangedChildren();
            for (int i = 0; i < deltas.length; ++i) {
                IJavaElementDelta javaElementDelta = deltas[i];
                this.processDelta(javaElementDelta);
            }
        } else if (type == 2) {
            IJavaProject jproj = (IJavaProject)jElement;
            int kind = delta.getKind();
            if (kind == 4 && this.hasLoadedModels(jproj.getProject())) {
                this.notifyListeners(jproj.getProject());
            }
        }
    }

    private void processDeltaWithFix(IJavaElementDelta delta) {
        IJavaElement jElement = delta.getElement();
        int type = jElement.getElementType();
        if (type == 1) {
            IJavaElementDelta[] deltas = delta.getChangedChildren();
            for (int i = 0; i < deltas.length; ++i) {
                IJavaElementDelta javaElementDelta = deltas[i];
                this.processDeltaWithFix(javaElementDelta);
            }
        } else if (type == 2) {
            IJavaProject jproj = (IJavaProject)jElement;
            int kind = delta.getKind();
            if (kind == 4) {
                if ((delta.getFlags() & 0x20000) != 0) {
                    if (this.hasLoadedModels(jproj.getProject())) {
                        this.notifyListeners(jproj.getProject());
                    }
                } else if ((delta.getFlags() & 8) != 0) {
                    IJavaElementDelta[] deltas = delta.getChangedChildren();
                    for (int i = 0; i < deltas.length; ++i) {
                        IJavaElementDelta javaElementDelta = deltas[i];
                        this.processDeltaWithFix(javaElementDelta);
                    }
                }
            }
        } else if (type == 3 || type == 4) {
            IJavaElementDelta[] deltas = delta.getChangedChildren();
            for (int i = 0; i < deltas.length; ++i) {
                IJavaElementDelta javaElementDelta = deltas[i];
                this.processDeltaWithFix(javaElementDelta);
            }
        } else if (type == 5) {
            IJavaProject jproj = ((ICompilationUnit)jElement).getJavaProject();
            if ((delta.getFlags() & 0x4000) != 0 && this.hasLoadedModels(jproj.getProject())) {
                this.notifyListeners(jproj.getProject());
            }
        }
    }

    public static interface IRefreshHandlerListener {
        public void onRefresh(Object var1);
    }
}

