/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.ltk.ui.processor;

import com.ibm.etools.javaee.annotations.ejb.utils.ModelProviderUtil;
import com.ibm.etools.javaee.ltk.core.change.DeleteEntityBeanChange;
import com.ibm.etools.javaee.ltk.core.change.DeleteJavaEEResourceChange;
import com.ibm.etools.javaee.ltk.core.change.DeleteMDBChange;
import com.ibm.etools.javaee.ltk.core.change.DeleteSessionBeanChange;
import com.ibm.etools.javaee.ltk.core.nls.RefactoringUIResourceHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class DeleteEnterpriseBeanProcessor
extends DeleteProcessor {
    ArrayList beansToDelete = null;
    List<IResource> allAffectedResources = null;
    Map<JavaEEObject, List<IResource>> affectedResourcesByBean = null;

    public DeleteEnterpriseBeanProcessor(ArrayList bd, boolean deleteContents) {
        this.beansToDelete = bd;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = null;
        if (this.beansToDelete.size() <= 0) {
            return null;
        }
        result = new CompositeChange(RefactoringUIResourceHandler.Delete_Enterprise_Beans);
        for (int i = 0; i < this.beansToDelete.size(); ++i) {
            if (this.beansToDelete.get(i) instanceof SessionBean) {
                CompositeChange sessionBeanComposite = new CompositeChange(RefactoringUIResourceHandler.Delete_Session_Bean + ((SessionBean)this.beansToDelete.get(i)).getEjbName());
                this.createAndAddSessionBeanDeleteChanges(sessionBeanComposite, (SessionBean)this.beansToDelete.get(i));
                result.add((Change)sessionBeanComposite);
            }
            if (this.beansToDelete.get(i) instanceof MessageDrivenBean) {
                CompositeChange mdBeanComposite = new CompositeChange(RefactoringUIResourceHandler.Delete_MD_Bean + ((MessageDrivenBean)this.beansToDelete.get(i)).getEjbName());
                this.createAndAddMessageDrivenBeanDeleteChanges(mdBeanComposite, (MessageDrivenBean)this.beansToDelete.get(i));
                result.add((Change)mdBeanComposite);
            }
            if (!(this.beansToDelete.get(i) instanceof EntityBean)) continue;
            CompositeChange entityBeanComposite = new CompositeChange(RefactoringUIResourceHandler.Delete_Entity_Bean + ((EntityBean)this.beansToDelete.get(i)).getEjbName());
            this.createAndAddEntityBeanDeleteChanges(entityBeanComposite, (EntityBean)this.beansToDelete.get(i));
            result.add((Change)entityBeanComposite);
        }
        return result;
    }

    public void createAndAddSessionBeanDeleteChanges(CompositeChange compositeChange, SessionBean sessBean) {
        IProject project;
        IJavaProject javaProject;
        List<IResource> affectedResources = this.getAffectedResourcesForBean((JavaEEObject)sessBean);
        if (affectedResources != null) {
            for (IResource resource : affectedResources) {
                DeleteJavaEEResourceChange dc = new DeleteJavaEEResourceChange(resource.getFullPath(), true, true);
                compositeChange.add((Change)dc);
            }
        }
        IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)sessBean));
        SessionBean beanInDD = null;
        EJBJar ejbjar = ModelProviderUtil.getEJBJar((IProject)resource.getProject());
        EnterpriseBeans ebs = ejbjar.getEnterpriseBeans();
        if (ebs != null) {
            List sessbs = ebs.getSessionBeans();
            for (int i = 0; i < sessbs.size(); ++i) {
                if (!((SessionBean)sessbs.get(i)).getEjbName().equals(sessBean.getEjbName())) continue;
                beanInDD = (SessionBean)sessbs.get(i);
            }
        }
        if ((javaProject = JavaCore.create((IProject)(project = resource.getProject()))).exists() && beanInDD != null) {
            DeleteSessionBeanChange dsc = new DeleteSessionBeanChange(ejbjar, beanInDD);
            compositeChange.add((Change)dsc);
        }
    }

    public void createAndAddMessageDrivenBeanDeleteChanges(CompositeChange compositeChange, MessageDrivenBean messDrivenBean) throws JavaModelException {
        IProject project;
        IJavaProject javaProject;
        IFile resource;
        List<IResource> affectedResources = this.getAffectedResourcesForBean((JavaEEObject)messDrivenBean);
        if (affectedResources != null) {
            for (IResource resource2 : affectedResources) {
                DeleteJavaEEResourceChange dc = new DeleteJavaEEResourceChange(resource2.getFullPath(), true, true);
                compositeChange.add((Change)dc);
            }
        }
        if ((resource = WorkbenchResourceHelper.getFile((EObject)((EObject)messDrivenBean))) == null) {
            return;
        }
        EJBJar ejbjar = ModelProviderUtil.getEJBJar((IProject)resource.getProject());
        EnterpriseBeans ebs = ejbjar.getEnterpriseBeans();
        MessageDrivenBean beanInDD = null;
        if (ebs != null) {
            List mdbs = ebs.getMessageDrivenBeans();
            for (int i = 0; i < mdbs.size(); ++i) {
                if (!((MessageDrivenBean)mdbs.get(i)).getEjbName().equals(messDrivenBean.getEjbName())) continue;
                beanInDD = (MessageDrivenBean)mdbs.get(i);
            }
        }
        if ((javaProject = JavaCore.create((IProject)(project = resource.getProject()))).exists() && beanInDD != null) {
            DeleteMDBChange dsc = new DeleteMDBChange(ejbjar, beanInDD);
            compositeChange.add((Change)dsc);
        }
    }

    public void createAndAddEntityBeanDeleteChanges(CompositeChange compositeChange, EntityBean entityBean) throws JavaModelException {
        IProject project;
        IJavaProject javaProject;
        IFile resource;
        List<IResource> affectedResources = this.getAffectedResourcesForBean((JavaEEObject)entityBean);
        if (affectedResources != null) {
            for (IResource resource2 : affectedResources) {
                DeleteJavaEEResourceChange dc = new DeleteJavaEEResourceChange(resource2.getFullPath(), true, true);
                compositeChange.add((Change)dc);
            }
        }
        if ((resource = WorkbenchResourceHelper.getFile((EObject)((EObject)entityBean))) == null) {
            return;
        }
        EJBJar ejbjar = ModelProviderUtil.getEJBJar((IProject)resource.getProject());
        EnterpriseBeans ebs = ejbjar.getEnterpriseBeans();
        EntityBean beanInDD = null;
        if (ebs != null) {
            List entBeans = ebs.getEntityBeans();
            for (int i = 0; i < entBeans.size(); ++i) {
                if (!((EntityBean)entBeans.get(i)).getEjbName().equals(entityBean.getEjbName())) continue;
                beanInDD = (EntityBean)entBeans.get(i);
            }
        }
        if ((javaProject = JavaCore.create((IProject)(project = resource.getProject()))).exists() && beanInDD != null) {
            DeleteEntityBeanChange dsc = new DeleteEntityBeanChange(ejbjar, beanInDD);
            compositeChange.add((Change)dsc);
        }
    }

    private void cacheResources() {
        this.allAffectedResources = new ArrayList<IResource>();
        this.affectedResourcesByBean = new HashMap<JavaEEObject, List<IResource>>();
        for (Object bean : this.beansToDelete) {
            if (bean instanceof SessionBean) {
                this.getResources(this.allAffectedResources, (SessionBean)bean);
                continue;
            }
            if (bean instanceof MessageDrivenBean) {
                this.getResources(this.allAffectedResources, (MessageDrivenBean)bean);
                continue;
            }
            if (!(bean instanceof EntityBean)) continue;
            this.getResources(this.allAffectedResources, (EntityBean)bean);
        }
    }

    public List<IResource> getAffectedResources() {
        if (this.allAffectedResources == null) {
            this.cacheResources();
        }
        return this.allAffectedResources;
    }

    public List<IResource> getAffectedResourcesForBean(JavaEEObject bean) {
        if (this.affectedResourcesByBean == null) {
            this.cacheResources();
        }
        return this.affectedResourcesByBean.get(bean);
    }

    private void getResources(List<IResource> resourceList, SessionBean sessBean) {
        IProject project;
        IJavaProject javaProject;
        ArrayList<IResource> affectedResourcesForBean = new ArrayList<IResource>();
        String beanClassName = sessBean.getEjbClass();
        List localInterfaceName = sessBean.getBusinessLocals();
        List remoteInterfaceName = sessBean.getBusinessRemotes();
        IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)sessBean));
        SessionBean beanInDD = null;
        EJBJar ejbjar = ModelProviderUtil.getEJBJar((IProject)resource.getProject());
        EnterpriseBeans ebs = ejbjar.getEnterpriseBeans();
        if (ebs != null) {
            List sessbs = ebs.getSessionBeans();
            for (int i = 0; i < sessbs.size(); ++i) {
                if (!((SessionBean)sessbs.get(i)).getEjbName().equals(sessBean.getEjbName())) continue;
                beanInDD = (SessionBean)sessbs.get(i);
            }
        }
        if ((javaProject = JavaCore.create((IProject)(project = resource.getProject()))).exists()) {
            try {
                IResource res;
                ICompilationUnit cu;
                IResource res2;
                ICompilationUnit cu2;
                IType beanType = null;
                if (beanClassName != null) {
                    beanType = javaProject.findType(beanClassName);
                }
                if (beanType != null && (cu2 = beanType.getCompilationUnit()) != null && (res2 = cu2.getResource()).isAccessible()) {
                    resourceList.add(res2);
                    affectedResourcesForBean.add(res2);
                }
                IType localType = null;
                for (int i = 0; i < localInterfaceName.size(); ++i) {
                    IResource res3;
                    ICompilationUnit cu3;
                    String local = (String)localInterfaceName.get(i);
                    if (local != null) {
                        localType = javaProject.findType(local);
                    }
                    if (localType == null || (cu3 = localType.getCompilationUnit()) == null || !(res3 = cu3.getResource()).isAccessible()) continue;
                    resourceList.add(res3);
                    affectedResourcesForBean.add(res3);
                }
                IType remoteType = null;
                for (int i = 0; i < remoteInterfaceName.size(); ++i) {
                    String remote = (String)remoteInterfaceName.get(i);
                    if (remote != null) {
                        remoteType = javaProject.findType(remote);
                    }
                    if (remoteType == null || (cu = remoteType.getCompilationUnit()) == null || !(res = cu.getResource()).isAccessible()) continue;
                    resourceList.add(res);
                    affectedResourcesForBean.add(res);
                }
                if (beanInDD != null) {
                    IResource res4;
                    ICompilationUnit cu4;
                    IType remoteDDType;
                    String remote;
                    IResource res5;
                    ICompilationUnit cu5;
                    IType localDDType;
                    String local;
                    IResource res6;
                    ICompilationUnit cu6;
                    IType localHomeDDType;
                    String localHome;
                    IResource res7;
                    ICompilationUnit cu7;
                    IType homeDDType;
                    String home;
                    IType servEndpointDDType;
                    String serviceEndPoint = beanInDD.getServiceEndpoint();
                    if (serviceEndPoint != null && (servEndpointDDType = javaProject.findType(serviceEndPoint)) != null && (cu = servEndpointDDType.getCompilationUnit()) != null && (res = cu.getResource()).isAccessible()) {
                        resourceList.add(res);
                        affectedResourcesForBean.add(res);
                    }
                    if ((home = beanInDD.getHome()) != null && (homeDDType = javaProject.findType(home)) != null && (cu7 = homeDDType.getCompilationUnit()) != null && (res7 = cu7.getResource()).isAccessible()) {
                        resourceList.add(res7);
                        affectedResourcesForBean.add(res7);
                    }
                    if ((localHome = beanInDD.getLocalHome()) != null && (localHomeDDType = javaProject.findType(localHome)) != null && (cu6 = localHomeDDType.getCompilationUnit()) != null && (res6 = cu6.getResource()).isAccessible()) {
                        resourceList.add(res6);
                        affectedResourcesForBean.add(res6);
                    }
                    if ((local = beanInDD.getLocal()) != null && (localDDType = javaProject.findType(local)) != null && (cu5 = localDDType.getCompilationUnit()) != null && (res5 = cu5.getResource()).isAccessible()) {
                        resourceList.add(res5);
                        affectedResourcesForBean.add(res5);
                    }
                    if ((remote = beanInDD.getRemote()) != null && (remoteDDType = javaProject.findType(remote)) != null && (cu4 = remoteDDType.getCompilationUnit()) != null && (res4 = cu4.getResource()).isAccessible()) {
                        resourceList.add(res4);
                        affectedResourcesForBean.add(res4);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        this.affectedResourcesByBean.put((JavaEEObject)sessBean, affectedResourcesForBean);
    }

    private void getResources(List<IResource> resourceList, MessageDrivenBean messDrivenBean) {
        ArrayList<IResource> affectedResourcesForBean = new ArrayList<IResource>();
        String beanClassName = messDrivenBean.getEjbClass();
        IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)messDrivenBean));
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            try {
                IResource res;
                ICompilationUnit cu;
                IType beanType = null;
                if (beanClassName != null) {
                    beanType = javaProject.findType(beanClassName);
                }
                if (beanType != null && (cu = beanType.getCompilationUnit()) != null && (res = cu.getResource()).isAccessible()) {
                    resourceList.add(res);
                    affectedResourcesForBean.add(res);
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        this.affectedResourcesByBean.put((JavaEEObject)messDrivenBean, affectedResourcesForBean);
    }

    private void getResources(List<IResource> resourceList, EntityBean entityBean) {
        IProject project;
        IJavaProject javaProject;
        ArrayList<IResource> affectedResourcesForBean = new ArrayList<IResource>();
        String beanClassName = entityBean.getEjbClass();
        IFile resource = WorkbenchResourceHelper.getFile((EObject)((EObject)entityBean));
        if (resource == null) {
            return;
        }
        EJBJar ejbjar = ModelProviderUtil.getEJBJar((IProject)resource.getProject());
        EnterpriseBeans ebs = ejbjar.getEnterpriseBeans();
        EntityBean beanInDD = null;
        if (ebs != null) {
            List entBeans = ebs.getEntityBeans();
            for (int i = 0; i < entBeans.size(); ++i) {
                if (!((EntityBean)entBeans.get(i)).getEjbName().equals(entityBean.getEjbName())) continue;
                beanInDD = (EntityBean)entBeans.get(i);
            }
        }
        if ((javaProject = JavaCore.create((IProject)(project = resource.getProject()))).exists()) {
            try {
                IResource res;
                ICompilationUnit cu;
                IType beanType = null;
                if (beanClassName != null) {
                    beanType = javaProject.findType(beanClassName);
                }
                if (beanType != null && (cu = beanType.getCompilationUnit()) != null && (res = cu.getResource()).isAccessible()) {
                    resourceList.add(res);
                    affectedResourcesForBean.add(res);
                }
                if (beanInDD != null) {
                    IResource res2;
                    ICompilationUnit cu2;
                    IType remoteType;
                    String remote;
                    IResource res3;
                    ICompilationUnit cu3;
                    IType localType;
                    String local;
                    IResource res4;
                    ICompilationUnit cu4;
                    IType localHomeType;
                    String localHome;
                    IResource res5;
                    ICompilationUnit cu5;
                    IType homeType;
                    String home;
                    IResource res6;
                    ICompilationUnit cu6;
                    IType keyClassType;
                    String keyClass = beanInDD.getPrimKeyClass();
                    if (keyClass != null && (keyClassType = javaProject.findType(keyClass)) != null && (cu6 = keyClassType.getCompilationUnit()) != null && (res6 = cu6.getResource()).isAccessible()) {
                        resourceList.add(res6);
                        affectedResourcesForBean.add(res6);
                    }
                    if ((home = beanInDD.getHome()) != null && (homeType = javaProject.findType(home)) != null && (cu5 = homeType.getCompilationUnit()) != null && (res5 = cu5.getResource()).isAccessible()) {
                        resourceList.add(res5);
                        affectedResourcesForBean.add(res5);
                    }
                    if ((localHome = beanInDD.getLocalHome()) != null && (localHomeType = javaProject.findType(localHome)) != null && (cu4 = localHomeType.getCompilationUnit()) != null && (res4 = cu4.getResource()).isAccessible()) {
                        resourceList.add(res4);
                        affectedResourcesForBean.add(res4);
                    }
                    if ((local = beanInDD.getLocal()) != null && (localType = javaProject.findType(local)) != null && (cu3 = localType.getCompilationUnit()) != null && (res3 = cu3.getResource()).isAccessible()) {
                        resourceList.add(res3);
                        affectedResourcesForBean.add(res3);
                    }
                    if ((remote = beanInDD.getRemote()) != null && (remoteType = javaProject.findType(remote)) != null && (cu2 = remoteType.getCompilationUnit()) != null && (res2 = cu2.getResource()).isAccessible()) {
                        resourceList.add(res2);
                        affectedResourcesForBean.add(res2);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            this.affectedResourcesByBean.put((JavaEEObject)entityBean, affectedResourcesForBean);
        }
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return RefactoringUIResourceHandler.Java_EE_Refactorings;
    }

    public String getProcessorName() {
        return RefactoringUIResourceHandler.Java_EE_Refactorings;
    }

    public boolean isApplicable() throws CoreException {
        return this.beansToDelete.size() > 0;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<DeleteParticipant> participants = new ArrayList<DeleteParticipant>();
        if (!this.isApplicable()) {
            return new RefactoringParticipant[0];
        }
        List<IResource> allResources = this.getAffectedResources();
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures((IResource[])allResources.toArray(new IResource[0]));
        DeleteArguments deleteArguments = new DeleteArguments();
        for (IResource resourceToDelete : allResources) {
            participants.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)resourceToDelete, (DeleteArguments)deleteArguments, (String[])affectedNatures, (SharableParticipants)sharedParticipants)));
        }
        return participants.toArray(new RefactoringParticipant[0]);
    }
}

