/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee.datamodel;

import com.ibm.etools.j2ee.ui.webproject.configuration.deployment.datamodel.DefaultDeploymentDataModelProvider;
import com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee.EarProjectUtil;
import com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee.datamodel.IJavaeeDeploymentDataModelProvider;
import com.ibm.etools.j2ee.ui.webproject.internal.nls.WebProjectMessages;
import com.ibm.faceted.project.wizard.core.configuration.IContributionProjectManager;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class JavaeeDeploymentDataModelProvider
extends DefaultDeploymentDataModelProvider
implements IJavaeeDeploymentDataModelProvider {
    private static final String EAR_PROJECT_NAME = "IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME";
    private static final String ADD_TO_EAR = "IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR";
    private IDataModel j2eeDelegateModel;

    public JavaeeDeploymentDataModelProvider(IDataModel baseDelegateDataModel, IDataModel j2eeDelegateModel, IContributionProjectManager projectManager) {
        super(baseDelegateDataModel, projectManager);
        this.j2eeDelegateModel = j2eeDelegateModel;
    }

    @Override
    public void dispose() {
        this.j2eeDelegateModel = null;
        super.dispose();
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        Object result = null;
        if ("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME".equals(propertyName)) {
            Object earName = null;
            IProjectFacetVersion webVersion = (IProjectFacetVersion)this.getProperty("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING");
            if (webVersion != null) {
                String lastEarName;
                Set<String> compatibleEarProjects = EarProjectUtil.getCompatibleEarProjectNames(webVersion, false);
                if (this.isPropertySet("IJavaeeDeploymentDataModelProvider.JAVAEE_LAST_EAR_NAME") && compatibleEarProjects.contains(lastEarName = this.getStringProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_LAST_EAR_NAME"))) {
                    earName = lastEarName;
                }
            }
            if (earName == null) {
                IProject earProject;
                earName = this.delegateDataModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME") + "EAR";
                Path path = new Path((String)earName);
                IProject iProject = earProject = ((String)earName).length() > 0 && path.isValidSegment((String)earName) ? ResourcesPlugin.getWorkspace().getRoot().getProject((String)earName) : null;
                if (earProject == null) {
                    return null;
                }
                int count = 0;
                while (earProject != null && earProject.exists()) {
                    earName = this.delegateDataModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME") + count + "EAR";
                    earProject = ResourcesPlugin.getWorkspace().getRoot().getProject((String)earName);
                }
            }
            result = earName;
        } else {
            result = "IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR".equals(propertyName) ? this.j2eeDelegateModel.getDefaultProperty(ADD_TO_EAR) : super.getDefaultProperty(propertyName);
        }
        this.autoSyncProperty(propertyName, result);
        return result;
    }

    @Override
    public Set<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        names.add("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME");
        names.add("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR");
        names.add("IJavaeeDeploymentDataModelProvider.JAVAEE_LAST_EAR_NAME");
        names.add("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME");
        names.add("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR");
        names.add("IJ2EEFacetProjectCreationDataModelProperties.MODULE_URI");
        names.addAll(super.getPropertyNames());
        return names;
    }

    @Override
    public void init() {
        super.init();
        this.addPropertyToAutoSync("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR", ADD_TO_EAR, this.j2eeDelegateModel);
        this.addPropertyToAutoSync("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", EAR_PROJECT_NAME, this.j2eeDelegateModel);
        this.addPropertyToAutoSync("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", this.j2eeDelegateModel);
        this.addPropertyToAutoSync("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR", "IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", this.getDataModel());
        this.addPropertyToAutoSync("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", "IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", this.getDataModel());
        this.addPropertyToAutoSync("IJ2EEFacetProjectCreationDataModelProperties.MODULE_URI", "IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI", this.j2eeDelegateModel);
    }

    @Override
    public boolean isPropertyEnabled(String propertyName) {
        if ("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME".equals(propertyName)) {
            return this.getBooleanProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR") && this.isPropertyEnabled("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR");
        }
        if ("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR".equals(propertyName)) {
            IRuntime rt = (IRuntime)this.model.getProperty("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME");
            boolean enabled = true;
            if (rt != null) {
                enabled = rt.supports(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET);
            }
            return enabled;
        }
        return super.isPropertyEnabled(propertyName);
    }

    @Override
    public boolean propertySet(String propertyName, Object propertyValue) {
        this.autoSyncProperty(propertyName, propertyValue);
        if ("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR".equals(propertyName)) {
            this.model.notifyPropertyChange("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", 3);
        } else if ("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME".equals(propertyName)) {
            this.model.notifyPropertyChange("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR", 3);
        } else if ("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME".equals(propertyName)) {
            this.model.notifyPropertyChange("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR", 1);
            this.model.notifyPropertyChange("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", 3);
        } else if ("IJavaeeDeploymentDataModelProvider.JAVAEE_LAST_EAR_NAME".equals(propertyName)) {
            IProject earProject;
            String earName = (String)propertyValue;
            if (earName != null && !earName.isEmpty() && (earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(earName)) != null && earProject.exists() && JavaEEProjectUtilities.isEARProject((IProject)earProject)) {
                this.model.setProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", propertyValue);
            }
        } else if ("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING".equals(propertyName)) {
            this.model.notifyPropertyChange("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", 1);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    @Override
    public IStatus validate(String propertyName) {
        if ("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME".equals(propertyName) && this.getBooleanProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR")) {
            Object status = this.j2eeDelegateModel.validateProperty(EAR_PROJECT_NAME);
            if (status.isOK()) {
                IProject project;
                String projectName = this.getDataModel().getStringProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME");
                Path path = new Path(projectName);
                IProject iProject = project = projectName.length() > 0 && path.isValidSegment(projectName) ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
                if (project != null && project.exists()) {
                    status = !JavaEEProjectUtilities.isEARProject((IProject)project) ? new Status(4, "com.ibm.etools.j2ee.ui", WebProjectMessages.JavaeeDeploymentDataModelProvider_EarProjectNameConflictsWithExistingProject) : EarProjectUtil.validateEarCompabilityWithRuntime(project, (IRuntime)this.getProperty("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME"));
                }
            }
            return status;
        }
        return super.validate(propertyName);
    }
}

