/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee;

import com.ibm.etools.j2ee.ui.webproject.configuration.deployment.AbstractDeploymentConfigurationDelegate;
import com.ibm.etools.j2ee.ui.webproject.configuration.deployment.AbstractDeploymentPage;
import com.ibm.etools.j2ee.ui.webproject.configuration.deployment.datamodel.DefaultDeploymentDataModelProvider;
import com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee.EarProjectUtil;
import com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee.EarSelectionDialog;
import com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee.datamodel.JavaeeDeploymentDataModelProvider;
import com.ibm.etools.j2ee.ui.webproject.internal.nls.WebProjectMessages;
import com.ibm.faceted.project.wizard.core.configuration.IContributionProjectManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class JavaeeDeploymentPage
extends AbstractDeploymentPage {
    private static final String DIALOG_SETTING_KEY_LAST_EAR = "com.ibm.etools.webtools.javaee.internal.webproject.configuration.deployment.javaee.ui.LAST_EAR";
    private final IDataModel j2eeFacetDataModel;
    private Composite informationComposite;
    private Label informationLabel;
    private Text earNameText;

    public JavaeeDeploymentPage(IDataModel baseDataModel, IDataModel j2eeFacetDataModel, String pageName, AbstractDeploymentConfigurationDelegate delegate) {
        super(baseDataModel, pageName, delegate);
        this.j2eeFacetDataModel = j2eeFacetDataModel;
    }

    @Override
    protected void createProgrammingModelSpecificComposite(Composite parent) {
        IStatus tempStatus;
        IProject project;
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(WebProjectMessages.JavaeeDeploymentPage_EarMembershipGroup);
        Button addToEarButton = new Button((Composite)group, 32);
        addToEarButton.setText(WebProjectMessages.JavaeeDeploymentPage_AddToEar);
        GridDataFactory.defaultsFor((Control)addToEarButton).span(3, 1).applyTo((Control)addToEarButton);
        Label earNameLabel = new Label((Composite)group, 0);
        earNameLabel.setText(WebProjectMessages.JavaeeDeploymentPage_EarProjectName);
        this.earNameText = new Text((Composite)group, 2048);
        this.earNameText.setLayoutData((Object)new GridData(768));
        Button browseEarButton = new Button((Composite)group, 8);
        browseEarButton.setText(WebProjectMessages.JavaeeDeploymentPage_Browse);
        GridDataFactory.defaultsFor((Control)browseEarButton).applyTo((Control)browseEarButton);
        browseEarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaeeDeploymentPage.this.handleBrowseForEarProject();
            }
        });
        this.informationComposite = new Composite((Composite)group, 0);
        this.informationComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.informationComposite.setLayoutData((Object)data);
        Label informationLabelIcon = new Label(this.informationComposite, 0);
        informationLabelIcon.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        this.informationLabel = new Label(this.informationComposite, 0);
        this.informationLabel.setText(NLS.bind((String)WebProjectMessages.JavaeeDeploymentPage_EarVersionNumberInfoMessage, (Object)"0.0"));
        String lastEarName = this.getWizard().getDialogSettings().get(DIALOG_SETTING_KEY_LAST_EAR);
        if (lastEarName != null && !lastEarName.isEmpty() && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(lastEarName)) != null && project.exists() && JavaEEProjectUtilities.isEARProject((IProject)project) && (tempStatus = EarProjectUtil.validateEarCompabilityWithRuntime(project, this.projectManager.getRuntime())).getSeverity() != 4) {
            this.getDataModel().setProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_LAST_EAR_NAME", (Object)lastEarName);
        }
        this.synchHelper.synchCheckbox(addToEarButton, "IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR", null);
        this.synchHelper.synchText(this.earNameText, "IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", new Control[]{earNameLabel, browseEarButton});
        this.updateInformationMessage();
    }

    @Override
    protected DefaultDeploymentDataModelProvider getDeploymentDataModelProvider(IDataModel baseModel, IContributionProjectManager projectManager) {
        return new JavaeeDeploymentDataModelProvider(baseModel, this.j2eeFacetDataModel, projectManager);
    }

    @Override
    public String[] getValidationPropertyNames() {
        ArrayList<String> validationProperties = new ArrayList<String>();
        for (String name : super.getValidationPropertyNames()) {
            validationProperties.add(name);
        }
        validationProperties.add("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME");
        return validationProperties.toArray(new String[0]);
    }

    private void handleBrowseForEarProject() {
        EarSelectionDialog earDialog = new EarSelectionDialog(this.getShell(), (IRuntime)this.getDataModel().getProperty("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME"));
        int result = earDialog.open();
        if (result == 0) {
            String earName = earDialog.getEarName();
            this.getDataModel().setProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", (Object)earName);
        }
    }

    @Override
    public void propertyChanged(DataModelEvent event) {
        String propertyName = event.getPropertyName();
        if ("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME".equals(propertyName) || "IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING".equals(propertyName)) {
            if (Thread.currentThread() == Display.getDefault().getThread()) {
                this.updateInformationMessage();
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JavaeeDeploymentPage.this.updateInformationMessage();
                    }
                });
            }
        } else if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            this.getDataModel().notifyPropertyChange("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME", 1);
        }
        super.propertyChanged(event);
    }

    private void updateInformationMessage() {
        boolean showInformationComposite;
        if (this.informationLabel == null) {
            return;
        }
        String projectName = this.getDataModel().getStringProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_EAR_PROJECT_NAME");
        boolean bl = showInformationComposite = projectName != null && !projectName.isEmpty();
        if (showInformationComposite) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            boolean bl2 = showInformationComposite = (project == null || !project.exists()) && this.getDataModel().isPropertyEnabled("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR") && this.getDataModel().getBooleanProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR");
            if (showInformationComposite) {
                String webVersion = this.j2eeFacetDataModel.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
                int javaEEVersionInt = J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)webVersion);
                String javaEEVersion = J2EEVersionUtil.getJ2EETextVersion((int)javaEEVersionInt);
                this.informationLabel.setText(NLS.bind((String)WebProjectMessages.JavaeeDeploymentPage_EarVersionNumberInfoMessage, (Object)javaEEVersion));
            }
        }
        this.informationComposite.setVisible(showInformationComposite);
    }

    public void wizardFinished() {
        String lastEar;
        boolean saved = false;
        if (this.getDataModel().getBooleanProperty("IJavaeeDeploymentDataModelProvider.JAVAEE_ADD_TO_EAR") && (lastEar = this.earNameText.getText()) != null && !lastEar.isEmpty()) {
            this.getWizard().getDialogSettings().put(DIALOG_SETTING_KEY_LAST_EAR, lastEar);
            saved = true;
        }
        if (!saved) {
            this.getWizard().getDialogSettings().put(DIALOG_SETTING_KEY_LAST_EAR, "");
        }
    }
}

