/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee;

import com.ibm.etools.j2ee.ui.webproject.internal.Logger;
import com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee.EarProjectUtil;
import com.ibm.etools.j2ee.ui.webproject.internal.nls.WebProjectMessages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EarSelectionDialog
extends TitleAreaDialog {
    private Image smallEARProjectImage = null;
    private Image largeEARProjectImage;
    private String earName;
    private String[] allEarNames;
    private final IRuntime targetRuntime;

    public EarSelectionDialog(Shell parentShell, IRuntime targetRuntime) {
        super(parentShell);
        this.targetRuntime = targetRuntime;
        this.setShellStyle(0x10C70 | EarSelectionDialog.getDefaultOrientation());
        EarSelectionDialog.setDialogHelpAvailable((boolean)false);
        this.allEarNames = EarProjectUtil.getEarProjectNames();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(WebProjectMessages.EarSelectionDialog_ShellTitle);
        int width = 450;
        int height = 500;
        newShell.setSize(new Point(width, height));
        Point parentLocation = newShell.getParent().getLocation();
        Point parentSize = newShell.getParent().getSize();
        newShell.setLocation(parentLocation.x + (parentSize.x - width) / 2, parentLocation.y + (parentSize.y - height) / 2);
        super.configureShell(newShell);
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        if (this.allEarNames.length == 0) {
            this.getButton(0).setEnabled(false);
        }
        return createButtonBar;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(WebProjectMessages.EarSelectionDialog_TitleAreaTitle);
        this.setMessage(WebProjectMessages.EarSelectionDialog_Description);
        this.setTitleImage(this.getLargeEarImage());
        Composite top = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(1, false);
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(1808));
        Label topSeperator = new Label(top, 258);
        topSeperator.setLayoutData((Object)new GridData(768));
        Composite content = new Composite(top, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(1808));
        Label earLabel = new Label(content, 0);
        earLabel.setText(WebProjectMessages.EarSelectionDialog_EarProjects);
        Composite tableComposite = new Composite(content, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 25;
        tableComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        tableComposite.setLayoutData((Object)data);
        TableViewer earProjectList = new TableViewer(tableComposite, 2048);
        earProjectList.getControl().setLayoutData((Object)new GridData(1808));
        earProjectList.setContentProvider((IContentProvider)new EarProjectContentProvider());
        earProjectList.setLabelProvider((IBaseLabelProvider)new EarProjectLabelProvider());
        earProjectList.setInput((Object)this);
        if (this.allEarNames.length > 0) {
            this.earName = this.allEarNames[0];
            earProjectList.setSelection((ISelection)new StructuredSelection((Object)this.earName));
            this.updateValidationMessage();
        }
        earProjectList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EarSelectionDialog.this.handleEarProjectSelectionChanged(event);
            }
        });
        Label bottomSeperator = new Label(top, 258);
        bottomSeperator.setLayoutData((Object)new GridData(768));
        return top;
    }

    private Image getEarDialogImage(String path) {
        Image result = null;
        try {
            URL url = new URL(path);
            result = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        catch (MalformedURLException e) {
            Logger.logException(e);
        }
        return result;
    }

    public String getEarName() {
        return this.earName;
    }

    private Image getLargeEarImage() {
        if (this.largeEARProjectImage == null) {
            this.largeEARProjectImage = this.getEarDialogImage("platform:/plugin/org.eclipse.jst.j2ee.ui/icons/full/wizban/ear_wiz.gif");
        }
        return this.largeEARProjectImage;
    }

    private Image getSmallEarImage() {
        if (this.smallEARProjectImage == null) {
            this.smallEARProjectImage = this.getEarDialogImage("platform:/plugin/org.eclipse.jst.j2ee.ui/icons/ear.gif");
        }
        return this.smallEARProjectImage;
    }

    private void handleEarProjectSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object o = selection.getFirstElement();
        if (o instanceof String) {
            this.earName = (String)o;
            this.updateValidationMessage();
        }
    }

    protected void okPressed() {
        if (this.smallEARProjectImage != null) {
            this.smallEARProjectImage.dispose();
        }
        if (this.largeEARProjectImage != null) {
            this.largeEARProjectImage.dispose();
        }
        super.okPressed();
    }

    private void updateValidationMessage() {
        IProject earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.earName);
        IStatus status = Status.OK_STATUS;
        status = EarProjectUtil.validateEarCompabilityWithRuntime(earProject, this.targetRuntime);
        if (!status.isOK()) {
            this.setMessage(status.getMessage(), 2);
        } else {
            this.setMessage(WebProjectMessages.EarSelectionDialog_Description);
        }
    }

    private class EarProjectContentProvider
    implements IStructuredContentProvider {
        private EarProjectContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return EarSelectionDialog.this.allEarNames;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class EarProjectLabelProvider
    extends LabelProvider {
        private EarProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return EarSelectionDialog.this.getSmallEarImage();
        }

        public String getText(Object element) {
            return (String)element;
        }
    }
}

