/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.webproject.internal.configuration.deployment.javaee;

import com.ibm.etools.j2ee.ui.webproject.internal.Logger;
import com.ibm.etools.j2ee.ui.webproject.internal.nls.WebProjectMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EarProjectUtil {
    public static Set<String> getCompatibleEarProjectNames(IProjectFacetVersion webVersion, boolean exactMatch) {
        HashSet<String> earProjects = new HashSet<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int webPreferredJavaEEVersionInt = J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)webVersion.getVersionString());
        for (IProject project : projects) {
            if (!JavaEEProjectUtilities.isEARProject((IProject)project)) continue;
            int earVersion = J2EEVersionUtil.convertVersionStringToInt((String)J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project));
            if ((!exactMatch || earVersion != webPreferredJavaEEVersionInt) && (exactMatch || earVersion < webPreferredJavaEEVersionInt)) continue;
            earProjects.add(project.getName());
        }
        return earProjects;
    }

    public static String[] getEarProjectNames() {
        IProject[] projects;
        ArrayList<String> earProjects = new ArrayList<String>();
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!JavaEEProjectUtilities.isEARProject((IProject)project)) continue;
            earProjects.add(project.getName());
        }
        Collections.sort(earProjects);
        return earProjects.toArray(new String[0]);
    }

    public static IStatus validateEarCompabilityWithRuntime(IProject project, IRuntime runtime) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            Set targetedRuntimes = facetedProject.getTargetedRuntimes();
            boolean foundConfict = false;
            if (targetedRuntimes == null || targetedRuntimes.isEmpty()) {
                foundConfict = runtime != null;
            } else if (!targetedRuntimes.contains(runtime)) {
                foundConfict = true;
            }
            if (foundConfict) {
                IRuntime primaryRuntime = facetedProject.getPrimaryRuntime();
                String primaryRuntimeName = primaryRuntime == null ? "<NONE>" : primaryRuntime.getLocalizedName();
                return new Status(4, "com.ibm.etools.j2ee.ui", NLS.bind((String)WebProjectMessages.EarProjectUtil_RuntimeInvalidForEar, (Object[])new String[]{project.getName(), primaryRuntimeName}));
            }
        }
        catch (CoreException e) {
            Logger.logException((Exception)((Object)e));
        }
        return Status.OK_STATUS;
    }
}

