/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.webproject.configuration.deployment.datamodel;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.j2ee.ui.webproject.configuration.deployment.datamodel.IDeploymentDataModelProvider;
import com.ibm.etools.j2ee.ui.webproject.internal.nls.WebProjectMessages;
import com.ibm.faceted.project.wizard.core.configuration.IContributionProjectManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class DefaultDeploymentDataModelProvider
extends AbstractDataModelProvider
implements IDeploymentDataModelProvider {
    public static final String WAS_WEB_EXTENDED_FACET_ID = "com.ibm.websphere.extended.web";
    public static final String WAS_WEB_COEXIST_FACET_ID = "com.ibm.websphere.coexistence.web";
    public static final boolean websphereSupportDefined = ProjectFacetsManager.isProjectFacetDefined((String)"com.ibm.websphere.extended.web") && ProjectFacetsManager.isProjectFacetDefined((String)"com.ibm.websphere.coexistence.web");
    public static final IProjectFacet WAS_WEB_COEXIST_FACET = websphereSupportDefined ? ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.coexistence.web") : null;
    public static final IProjectFacet WAS_WEB_EXTENDED_FACET = websphereSupportDefined ? ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.extended.web") : null;
    public static final String WEB_FACET_ID = "jst.web";
    public static final IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    public static final String JAVA_FACET_ID = "java";
    public static final IProjectFacet JAVA_FACET = ProjectFacetsManager.getProjectFacet((String)"java");
    public static List<IProjectFacetVersion> WEB_FACET_VERSIONS = null;
    public static final String FACET_RUNTIME = "IFacetProjectCreationDataModelProperties.FACET_RUNTIME";
    protected IDataModel delegateDataModel;
    protected IContributionProjectManager projectManager;
    protected Map<String, Map<IDataModel, Set<String>>> autoSyncProperties;

    public DefaultDeploymentDataModelProvider(IDataModel delegateDataModel, IContributionProjectManager projectManager) {
        this.delegateDataModel = delegateDataModel;
        this.projectManager = projectManager;
        this.autoSyncProperties = new HashMap<String, Map<IDataModel, Set<String>>>();
    }

    public static IProjectFacetVersion getWebModuleFacet(Set<IProjectFacetVersion> projectFacetVersions) {
        IProjectFacetVersion webFacetVersion = null;
        for (IProjectFacetVersion projectFacetVersion : projectFacetVersions) {
            if (!projectFacetVersion.getProjectFacet().equals((Object)WEB_FACET)) continue;
            webFacetVersion = projectFacetVersion;
            break;
        }
        return webFacetVersion;
    }

    protected void addPropertyToAutoSync(String propertyName, String otherPropertyName, IDataModel otherModel) {
        if (otherModel.isProperty(otherPropertyName)) {
            Set<String> otherPropertyNames;
            Map<IDataModel, Set<String>> dataModelMap = this.autoSyncProperties.get(propertyName);
            if (dataModelMap == null) {
                dataModelMap = new HashMap<IDataModel, Set<String>>();
                this.autoSyncProperties.put(propertyName, dataModelMap);
            }
            if ((otherPropertyNames = dataModelMap.get(otherModel)) == null) {
                otherPropertyNames = new HashSet<String>();
                dataModelMap.put(otherModel, otherPropertyNames);
            }
            otherPropertyNames.add(otherPropertyName);
        } else {
            System.out.println(otherPropertyName);
        }
    }

    protected void autoSyncProperty(String propertyName, Object propertyValue) {
        if (this.autoSyncProperties.containsKey(propertyName)) {
            Map<IDataModel, Set<String>> propertyToSyncMap = this.autoSyncProperties.get(propertyName);
            for (IDataModel otherModel : propertyToSyncMap.keySet()) {
                Set<String> propertiesToSync = propertyToSyncMap.get(otherModel);
                for (String otherPropertyName : propertiesToSync) {
                    otherModel.setProperty(otherPropertyName, propertyValue);
                }
            }
        }
    }

    public void dispose() {
        this.autoSyncProperties = null;
        this.delegateDataModel = null;
        this.projectManager = null;
    }

    public Object getDefaultProperty(String propertyName) {
        IStatus status;
        Object result = null;
        result = "IDeploymentDataModelProvider.FACETS_AND_RUNTIME_ARE_COMPATIBLE".equals(propertyName) ? Boolean.valueOf((status = this.validate("IDeploymentDataModelProvider.FACETS_AND_RUNTIME_ARE_COMPATIBLE")).getSeverity() != 4) : ("IDeploymentDataModelProvider.USE_WAS_EXTENDED_FEATURES".equals(propertyName) ? Boolean.valueOf(websphereSupportDefined && this.isWebsphereRuntime(this.projectManager.getRuntime())) : super.getDefaultProperty(propertyName));
        this.autoSyncProperty(propertyName, result);
        return result;
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        IProjectFacetVersion pfv;
        if ("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME".equals(propertyName)) {
            IRuntime runtime = (IRuntime)this.getProperty(propertyName);
            if (null != runtime) {
                return new DataModelPropertyDescriptor((Object)runtime, runtime.getLocalizedName());
            }
            return new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null));
        }
        if ("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING".equals(propertyName) && (pfv = (IProjectFacetVersion)this.getProperty(propertyName)) != null) {
            return new DataModelPropertyDescriptor((Object)pfv, pfv.getVersionString());
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public Set<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        names.add("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME");
        names.add("IDeploymentDataModelProvider.USE_WAS_EXTENDED_FEATURES");
        names.add("IDeploymentDataModelProvider.FACETS_AND_RUNTIME_ARE_COMPATIBLE");
        names.add("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME");
        names.add("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING");
        return names;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME".equals(propertyName)) {
            Set fixedFacets = this.projectManager.getFixedProjectFacets();
            ArrayList<DataModelPropertyDescriptor> descriptors = new ArrayList<DataModelPropertyDescriptor>();
            for (IRuntime runtime : RuntimeManager.getRuntimes()) {
                boolean supports = true;
                for (IProjectFacet facet : fixedFacets) {
                    if (runtime.supports(facet)) continue;
                    supports = false;
                    break;
                }
                if (!supports) continue;
                descriptors.add(new DataModelPropertyDescriptor((Object)runtime, runtime.getLocalizedName()));
            }
            Collections.sort(descriptors, new Comparator<DataModelPropertyDescriptor>(){

                @Override
                public int compare(DataModelPropertyDescriptor object1, DataModelPropertyDescriptor object2) {
                    return object1.getPropertyDescription().compareTo(object2.getPropertyDescription());
                }
            });
            descriptors.add(new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null)));
            return descriptors.toArray(new DataModelPropertyDescriptor[0]);
        }
        if ("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING".equals(propertyName)) {
            IRuntime runtime = (IRuntime)this.getProperty("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME");
            ArrayList<IProjectFacetVersion> supportedVersions = new ArrayList<IProjectFacetVersion>();
            for (IProjectFacetVersion projectFacetVersion : WEB_FACET_VERSIONS) {
                if (runtime != null && !runtime.supports(projectFacetVersion)) continue;
                supportedVersions.add(projectFacetVersion);
            }
            ArrayList<DataModelPropertyDescriptor> versionDescriptors = new ArrayList<DataModelPropertyDescriptor>();
            for (IProjectFacetVersion projectFacetVersion : supportedVersions) {
                versionDescriptors.add(new DataModelPropertyDescriptor((Object)projectFacetVersion, projectFacetVersion.getVersionString()));
            }
            Collections.reverse(versionDescriptors);
            return versionDescriptors.toArray(new DataModelPropertyDescriptor[0]);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public void init() {
        super.init();
        this.addPropertyToAutoSync("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME", FACET_RUNTIME, this.delegateDataModel);
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IDeploymentDataModelProvider.USE_WAS_EXTENDED_FEATURES".equals(propertyName)) {
            IRuntime primaryRuntime = this.projectManager.getRuntime();
            return websphereSupportDefined && this.isWebsphereRuntime(primaryRuntime);
        }
        return super.isPropertyEnabled(propertyName);
    }

    protected boolean isWebsphereRuntime(IRuntime primaryRuntime) {
        if (primaryRuntime != null) {
            return primaryRuntime.supports(WAS_WEB_COEXIST_FACET) && primaryRuntime.supports(WAS_WEB_EXTENDED_FACET);
        }
        return false;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        this.autoSyncProperty(propertyName, propertyValue);
        if ("IDeploymentDataModelProvider.USE_WAS_EXTENDED_FEATURES".equals(propertyName)) {
            this.updateWASFacets();
        } else if ("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME".equals(propertyName)) {
            this.removeWASFacets();
            this.model.notifyPropertyChange("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING", 4);
            this.model.setProperty("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING", (Object)DefaultDeploymentDataModelProvider.getWebModuleFacet(this.projectManager.getProjectFacetVersions()));
            this.model.notifyPropertyChange("IDeploymentDataModelProvider.USE_WAS_EXTENDED_FEATURES", 1);
            this.model.notifyPropertyChange("IDeploymentDataModelProvider.USE_WAS_EXTENDED_FEATURES", 3);
            this.updateWASFacets();
        } else if ("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING".equals(propertyName)) {
            IProjectFacetVersion facetVersion = (IProjectFacetVersion)propertyValue;
            this.projectManager.changeFacetVersion(facetVersion);
            HashSet projectFacetVersions = new HashSet(this.projectManager.getProjectFacetVersions());
            IProjectFacetVersion oldJavaFacetVersion = null;
            for (IProjectFacetVersion projectFacetVersion : projectFacetVersions) {
                if (!projectFacetVersion.getProjectFacet().equals((Object)JAVA_FACET)) continue;
                oldJavaFacetVersion = projectFacetVersion;
                break;
            }
            if (oldJavaFacetVersion != null) {
                projectFacetVersions.remove(oldJavaFacetVersion);
                IRuntime runtime = (IRuntime)this.getProperty("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME");
                HashSet<IFacetedProject.Action> javaActionSet = new HashSet<IFacetedProject.Action>();
                javaActionSet.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, oldJavaFacetVersion, null));
                IStatus javaStatus = ProjectFacetsManager.check(projectFacetVersions, javaActionSet);
                if (javaStatus.getSeverity() == 4) {
                    IProjectFacetVersion newJavaVersion;
                    block14: {
                        newJavaVersion = null;
                        try {
                            IProjectFacetVersion latestJaveVersion = oldJavaFacetVersion.getProjectFacet().getLatestSupportedVersion(runtime);
                            javaActionSet = new HashSet();
                            javaActionSet.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, latestJaveVersion, null));
                            javaStatus = ProjectFacetsManager.check(projectFacetVersions, javaActionSet);
                            if (javaStatus.getSeverity() != 4) {
                                newJavaVersion = latestJaveVersion;
                                break block14;
                            }
                            List javaVersions = oldJavaFacetVersion.getProjectFacet().getSortedVersions(false);
                            for (IProjectFacetVersion javaFacetVersion : javaVersions) {
                                if (runtime != null && !runtime.supports(javaFacetVersion)) continue;
                                javaActionSet = new HashSet();
                                javaActionSet.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javaFacetVersion, null));
                                javaStatus = ProjectFacetsManager.check(projectFacetVersions, javaActionSet);
                                if (javaStatus.getSeverity() == 4) continue;
                                newJavaVersion = javaFacetVersion;
                                if (javaStatus.getSeverity() == 4) continue;
                                break;
                            }
                        }
                        catch (VersionFormatException versionFormatException) {
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    if (newJavaVersion != null) {
                        javaStatus = this.projectManager.changeFacetVersion(newJavaVersion);
                    }
                }
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    protected void removeWASFacets() {
        if (this.projectManager.hasFacet(WAS_WEB_EXTENDED_FACET_ID) && this.projectManager.hasFacet(WAS_WEB_EXTENDED_FACET_ID)) {
            this.projectManager.removeFacet(WAS_WEB_EXTENDED_FACET_ID);
        }
        if (this.projectManager.hasFacet(WAS_WEB_COEXIST_FACET_ID)) {
            this.projectManager.removeFacet(WAS_WEB_COEXIST_FACET_ID);
        }
    }

    public void updateWASFacets() {
        IRuntime primaryRuntime = this.projectManager.getRuntime();
        try {
            if (WAS_WEB_COEXIST_FACET != null && !this.projectManager.hasFacet(WAS_WEB_COEXIST_FACET_ID)) {
                IProjectFacetVersion latestSupportedVersion;
                IProjectFacetVersion iProjectFacetVersion = latestSupportedVersion = primaryRuntime != null && primaryRuntime.supports(WAS_WEB_COEXIST_FACET) ? WAS_WEB_COEXIST_FACET.getLatestSupportedVersion(primaryRuntime) : null;
                if (latestSupportedVersion != null) {
                    this.projectManager.addFacetVersion(latestSupportedVersion);
                }
            }
        }
        catch (CoreException latestSupportedVersion) {
            // empty catch block
        }
        if (this.getBooleanProperty("IDeploymentDataModelProvider.USE_WAS_EXTENDED_FEATURES") && WAS_WEB_EXTENDED_FACET != null) {
            try {
                IProjectFacetVersion iProjectFacetVersion = latestSupportedVersion = primaryRuntime != null && primaryRuntime.supports(WAS_WEB_EXTENDED_FACET) ? WAS_WEB_EXTENDED_FACET.getLatestSupportedVersion(primaryRuntime) : null;
                if (latestSupportedVersion != null) {
                    this.projectManager.addFacetVersion(latestSupportedVersion);
                }
            }
            catch (CoreException coreException) {}
        } else {
            this.projectManager.removeFacet(WAS_WEB_EXTENDED_FACET_ID);
        }
    }

    public IStatus validate(String propertyName) {
        if ("IDeploymentDataModelProvider.FACETS_AND_RUNTIME_ARE_COMPATIBLE".equals(propertyName) || "IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING".equals("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING")) {
            IStatus status = Status.OK_STATUS;
            Set projectFacetVersions = this.projectManager.getProjectFacetVersions();
            HashSet<IFacetedProject.Action> facetActions = new HashSet<IFacetedProject.Action>();
            for (IProjectFacetVersion projectFacetVersion : projectFacetVersions) {
                facetActions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, projectFacetVersion, null));
            }
            IStatus newStatus = ProjectFacetsManager.check(new HashSet(), facetActions);
            if (newStatus.getSeverity() != 4 && this.projectManager.getRuntime() != null) {
                boolean facetNotSupportedOnRuntime = false;
                for (IProjectFacetVersion projectFacetVersion : projectFacetVersions) {
                    if (this.projectManager.getRuntime().supports(projectFacetVersion)) continue;
                    facetNotSupportedOnRuntime = true;
                    break;
                }
                if (facetNotSupportedOnRuntime) {
                    status = new Status(4, "com.ibm.etools.j2ee.ui", WebProjectMessages.JavaeeProjectDeploymentConfigurationDelegate_FeaturesConflictWithSelectedRuntimeValidationMessage);
                }
            }
            return status;
        }
        return super.validate(propertyName);
    }

    static {
        try {
            WEB_FACET_VERSIONS = WEB_FACET.getSortedVersions(false);
        }
        catch (VersionFormatException e) {
            J2EEUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.etools.j2ee.ui", "Couldn't read the jst.web facet versions"));
        }
        catch (CoreException e) {
            J2EEUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.ibm.etools.j2ee.ui", "Couldn't read the jst.web facet versions"));
        }
    }
}

