/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.webproject.configuration.deployment;

import com.ibm.etools.j2ee.ui.webproject.configuration.deployment.AbstractDeploymentConfigurationDelegate;
import com.ibm.etools.j2ee.ui.webproject.configuration.deployment.datamodel.DefaultDeploymentDataModelProvider;
import com.ibm.etools.j2ee.ui.webproject.internal.nls.WebProjectMessages;
import com.ibm.faceted.project.wizard.core.configuration.IContributionProjectManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetsChangedEvent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.ui.ServerUIUtil;

public abstract class AbstractDeploymentPage
extends DataModelWizardPage
implements IFacetedProjectListener {
    protected final AbstractDeploymentConfigurationDelegate delegate;
    protected final IContributionProjectManager projectManager;
    private DefaultDeploymentDataModelProvider deploymentDataModelProvider;
    private Button addWebsphereSpecificFeatures;
    private volatile boolean silenceEvents = false;
    protected Combo runtimeCombo;
    private Combo webModuleVersionCombo;

    public AbstractDeploymentPage(IDataModel dataModel, String pageName, AbstractDeploymentConfigurationDelegate delegate) {
        super(dataModel, pageName);
        this.delegate = delegate;
        this.projectManager = delegate.getProjectManager();
    }

    public void addFacetVersion(IProjectFacetVersion facetVersion) {
        this.silenceEvents = true;
        this.delegate.getProjectManager().addFacetVersion(facetVersion);
        this.silenceEvents = false;
    }

    protected void createProgrammingModelSpecificComposite(Composite parent) {
    }

    protected void createRuntimeComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(WebProjectMessages.AbstractDeploymentPage_TargetRuntime);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        this.runtimeCombo = new Combo((Composite)group, 2056);
        this.runtimeCombo.setLayoutData((Object)new GridData(768));
        Button newServerTargetButton = new Button((Composite)group, 0);
        newServerTargetButton.setText(WebProjectMessages.DeploymentPage_NewRuntime);
        GridDataFactory.defaultsFor((Control)newServerTargetButton).applyTo((Control)newServerTargetButton);
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDeploymentPage.this.launchNewRuntimeWizard(AbstractDeploymentPage.this.getShell(), AbstractDeploymentPage.this.model);
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.runtimeCombo, "IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME", deps);
        this.addWebsphereSpecificFeatures = new Button((Composite)group, 32);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.addWebsphereSpecificFeatures.setLayoutData((Object)data);
        this.addWebsphereSpecificFeatures.setText(WebProjectMessages.DeploymentPage_AddWebsphereSpecificFunction);
        this.synchHelper.synchCheckbox(this.addWebsphereSpecificFeatures, "IDeploymentDataModelProvider.USE_WAS_EXTENDED_FEATURES", null);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.deploymentDataModelProvider = this.getDeploymentDataModelProvider(this.getDataModel(), this.projectManager);
        this.getDataModel().addNestedModel(this.deploymentDataModelProvider.getID(), DataModelFactory.createDataModel((IDataModelProvider)this.deploymentDataModelProvider));
        Composite top = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)top, this.getInfopopID());
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(1808));
        this.createRuntimeComposite(top);
        this.createWebModuleVersionComposite(top);
        this.createProgrammingModelSpecificComposite(top);
        this.deploymentDataModelProvider.getDataModel().setProperty("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME", (Object)this.projectManager.getRuntime());
        this.deploymentDataModelProvider.getDataModel().setProperty("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME", (Object)this.projectManager.getRuntime());
        this.updateWebModuleVersionFromProjectManagerVersion(this.projectManager.getProjectFacetVersions());
        this.deploymentDataModelProvider.getDataModel().addListener((IDataModelListener)this);
        this.projectManager.addWorkingCopyListener((IFacetedProjectListener)this, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED, IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
        if (this.runtimeCombo.getSelectionIndex() == -1 && this.runtimeCombo.getVisibleItemCount() != 0) {
            this.runtimeCombo.select(0);
        }
        if (this.webModuleVersionCombo.getSelectionIndex() == -1 && this.webModuleVersionCombo.getVisibleItemCount() != 0) {
            this.webModuleVersionCombo.select(0);
        }
        return top;
    }

    protected void createWebModuleVersionComposite(Composite top) {
        Group webModuleVersionGroup = new Group(top, 0);
        webModuleVersionGroup.setLayoutData((Object)new GridData(768));
        webModuleVersionGroup.setLayout((Layout)new GridLayout(1, false));
        webModuleVersionGroup.setText(WebProjectMessages.AbstractDeploymentPage_0);
        this.webModuleVersionCombo = new Combo((Composite)webModuleVersionGroup, 2056);
        this.webModuleVersionCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.webModuleVersionCombo, "IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING", null);
    }

    public void dispose() {
        this.projectManager.removeWorkingCopyListener((IFacetedProjectListener)this);
        this.deploymentDataModelProvider.getDataModel().removeListener((IDataModelListener)this);
        this.getDataModel().removeNestedModel(this.deploymentDataModelProvider.getID());
        super.dispose();
    }

    public void doHandleEvent(IFacetedProjectEvent event) {
        switch (event.getType()) {
            case PRIMARY_RUNTIME_CHANGED: {
                IStatus status;
                this.deploymentDataModelProvider.getDataModel().setProperty("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME", (Object)this.projectManager.getRuntime());
                String newSeverDescription = this.getDataModel().getPropertyDescriptor("IFacetProjectCreationDataModelProperties.FACET_RUNTIME").getPropertyDescription();
                if (!newSeverDescription.equals(this.runtimeCombo.getText())) {
                    this.runtimeCombo.setText(newSeverDescription);
                }
                if ((status = this.deploymentDataModelProvider.getDataModel().validateProperty("IDeploymentDataModelProvider.FACETS_AND_RUNTIME_ARE_COMPATIBLE")).getSeverity() != 4) break;
                this.delegate.updateValidationState(status);
                break;
            }
            case PROJECT_FACETS_CHANGED: {
                IProjectFacetsChangedEvent actionEvent = (IProjectFacetsChangedEvent)event;
                this.updateWebModuleVersionFromProjectManagerVersion(actionEvent.getFacetsWithChangedVersions());
                IStatus status = this.deploymentDataModelProvider.getDataModel().validateProperty("IDeploymentDataModelProvider.FACETS_AND_RUNTIME_ARE_COMPATIBLE");
                if (status.getSeverity() == 4) {
                    this.delegate.updateValidationState(status);
                }
                this.refreshRuntimeCombo();
                break;
            }
        }
    }

    protected void enter() {
        super.enter();
        this.refreshRuntimeCombo();
    }

    private boolean equal(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2.equals(o1);
    }

    protected DefaultDeploymentDataModelProvider getDeploymentDataModelProvider(IDataModel baseModel, IContributionProjectManager projectManager) {
        return new DefaultDeploymentDataModelProvider(baseModel, projectManager);
    }

    protected String[] getValidationPropertyNames() {
        ArrayList<String> validationProperties = new ArrayList<String>();
        validationProperties.add("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        validationProperties.add("IDeploymentDataModelProvider.FACETS_AND_RUNTIME_ARE_COMPATIBLE");
        return validationProperties.toArray(new String[0]);
    }

    public void handleEvent(final IFacetedProjectEvent event) {
        if (!this.silenceEvents) {
            if (Thread.currentThread() == Display.getDefault().getThread()) {
                this.doHandleEvent(event);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDeploymentPage.this.doHandleEvent(event);
                    }
                });
            }
        }
    }

    public boolean hasFacet(String facetId) {
        return this.delegate.getProjectManager().hasFacet(facetId);
    }

    private void launchNewRuntimeWizard(Shell shell, final IDataModel model) {
        final HashSet<IRuntime> preDescriptors = new HashSet<IRuntime>();
        for (DataModelPropertyDescriptor propertyDescriptor : model.getValidPropertyDescriptors("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME")) {
            Object preRuntime = propertyDescriptor.getPropertyValue();
            if (!(preRuntime instanceof IRuntime)) continue;
            preDescriptors.add((IRuntime)preRuntime);
        }
        final boolean[] keepWaiting = new boolean[]{true};
        IDataModelListener listener = new IDataModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChanged(DataModelEvent event) {
                if (!event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME") || event.getFlag() != 4) return;
                boolean[] blArray = keepWaiting;
                synchronized (keepWaiting) {
                    keepWaiting[0] = false;
                    keepWaiting.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    model.removeListener((IDataModelListener)this);
                    return;
                }
            }
        };
        model.addListener(listener);
        boolean serverCreated = ServerUIUtil.showNewRuntimeWizard((Shell)shell, (String)"jst.web", null);
        if (serverCreated) {
            Thread newRuntimeSelectionThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    RuntimeManager.getRuntimes();
                    boolean[] blArray = keepWaiting;
                    synchronized (keepWaiting) {
                        while (keepWaiting[0]) {
                            try {
                                keepWaiting.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        AbstractDeploymentPage.this.getDataModel().notifyPropertyChange("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME", 4);
                        DataModelPropertyDescriptor[] postAdditionDescriptors = model.getValidPropertyDescriptors("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME");
                        DataModelPropertyDescriptor newDesc = null;
                        for (DataModelPropertyDescriptor postDescriptor : postAdditionDescriptors) {
                            Object postRuntime = postDescriptor.getPropertyValue();
                            if (!(postRuntime instanceof IRuntime) || preDescriptors.contains(postRuntime)) continue;
                            newDesc = postDescriptor;
                            break;
                        }
                        if (newDesc != null) {
                            AbstractDeploymentPage.this.getDataModel().setProperty("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME", newDesc.getPropertyValue());
                        }
                        return;
                    }
                }
            };
            newRuntimeSelectionThread.start();
        } else {
            model.removeListener(listener);
        }
    }

    public void propertyChanged(DataModelEvent event) {
        if (event.getPropertyName().equals("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME")) {
            IRuntime oldRuntime;
            this.silenceEvents = true;
            final IRuntime newRuntime = (IRuntime)event.getProperty();
            if (!this.equal(newRuntime, oldRuntime = this.projectManager.getRuntime())) {
                boolean updateCoreFacets = true;
                IStatus status = this.delegate.getProjectManager().validateRuntimeChange(newRuntime, true);
                boolean changeRuntime = true;
                if (!status.isOK()) {
                    changeRuntime = false;
                    if (status.getSeverity() == 2) {
                        Set incompatibleFacets = this.delegate.getProjectManager().getIncompatibleFacets(newRuntime, true);
                        HashSet<IProjectFacetVersion> finalPromptFacets = new HashSet<IProjectFacetVersion>();
                        for (IProjectFacetVersion projectFacetVersion : incompatibleFacets) {
                            IProjectFacet projectFacet = projectFacetVersion.getProjectFacet();
                            if (projectFacet.equals((Object)DefaultDeploymentDataModelProvider.WAS_WEB_COEXIST_FACET) || projectFacet.equals((Object)DefaultDeploymentDataModelProvider.WAS_WEB_EXTENDED_FACET)) continue;
                            finalPromptFacets.add(projectFacetVersion);
                        }
                        if (!finalPromptFacets.isEmpty()) {
                            Object message = NLS.bind((String)WebProjectMessages.ProjectTemplateFacetManager_FeatureToRemoveDialogMessage, (Object)newRuntime.getLocalizedName());
                            for (IProjectFacetVersion projectFacetVersion : finalPromptFacets) {
                                message = (String)message + projectFacetVersion.getProjectFacet().getLabel() + " " + projectFacetVersion.getVersionString() + "\n";
                            }
                            message = ((String)message).substring(0, ((String)message).length() - 1);
                            message = (String)message + "\n\n" + WebProjectMessages.AbstractDeploymentPage_ChangeRuntimePrompt;
                            changeRuntime = MessageDialog.openQuestion((Shell)this.getShell(), (String)WebProjectMessages.AbstractDeploymentPage_ChangeRuntimeDialogTitle, (String)message);
                        } else {
                            changeRuntime = true;
                        }
                    }
                }
                if (changeRuntime) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            IStatus status = AbstractDeploymentPage.this.delegate.getProjectManager().changeRuntime(newRuntime, true);
                            AbstractDeploymentPage.this.deploymentDataModelProvider.getDataModel().setProperty("IDeploymentDataModelProvider.ACTUAL_TARGET_RUNTIME", (Object)AbstractDeploymentPage.this.projectManager.getRuntime());
                            if (status.getSeverity() == 4) {
                                AbstractDeploymentPage.this.delegate.updateValidationState(status);
                            }
                        }
                    };
                    if (Display.getDefault().getThread() == Thread.currentThread()) {
                        runnable.run();
                    } else {
                        Display.getDefault().syncExec(runnable);
                    }
                } else {
                    this.runtimeCombo.setText(this.getDataModel().getPropertyDescriptor("IFacetProjectCreationDataModelProperties.FACET_RUNTIME").getPropertyDescription());
                }
            }
            this.silenceEvents = false;
        } else if (!this.silenceEvents && "IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP".equals(event.getPropertyName())) {
            this.deploymentDataModelProvider.updateWASFacets();
        }
        super.propertyChanged(event);
    }

    private void refreshRuntimeCombo() {
        this.synchHelper.synchUIWithModel("IDeploymentDataModelProvider.PROPOSED_TARGET_RUNTIME", 4);
    }

    private void updateWebModuleVersionFromProjectManagerVersion(Set<IProjectFacetVersion> projectFacetVersions) {
        if (!this.silenceEvents) {
            this.silenceEvents = true;
            IProjectFacetVersion webFacetVersion = DefaultDeploymentDataModelProvider.getWebModuleFacet(projectFacetVersions);
            if (webFacetVersion != null) {
                this.deploymentDataModelProvider.getDataModel().setProperty("IDeploymentDataModelProvider.WEB_FACET_VERSION_STRING", (Object)webFacetVersion);
            }
            this.silenceEvents = false;
        }
    }
}

