/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.validator;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.j2ee.ui.validator.Messages;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.AbstractDeploymentAssemblyVerifier;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.DeploymentAssemblyVerifierData;

public class SharedEarAssemblyVerifier
extends AbstractDeploymentAssemblyVerifier {
    private final IPath TEAM_SHARE_PATH = new Path(".settings").append("com.ibm.etools.j2ee.teamshare");

    public IStatus verify(DeploymentAssemblyVerifierData data) {
        IStatus status = Status.OK_STATUS;
        IVirtualComponent comp = data.getComponent();
        IProject project = data.getComponent().getProject();
        if (J2EEProjectUtilities.isEARComponent((IVirtualComponent)comp) && project.findMember(this.TEAM_SHARE_PATH) != null) {
            IVirtualComponent referencedComp = null;
            HashMap<String, IVirtualReference> missingReferences = new HashMap<String, IVirtualReference>();
            for (IVirtualReference ref : data.getCurrentReferences()) {
                referencedComp = ref.getReferencedComponent();
                if (referencedComp.exists() || referencedComp.isBinary()) continue;
                missingReferences.put(ref.getArchiveName(), ref);
            }
            if (missingReferences.size() != 0) {
                String compName = null;
                for (IVirtualReference compRef : comp.getReferences()) {
                    compName = compRef.getArchiveName();
                    if (!missingReferences.containsKey(compName) || !compRef.getReferencedComponent().exists()) continue;
                    String projectName = ((IVirtualReference)missingReferences.get(compName)).getReferencedComponent().getName();
                    String msg = Messages.bind((String)Messages.MappingNotFoundSharedEARInfo, (Object[])new Object[]{projectName, compName});
                    status = this.appendStatusMessage(status, msg, 1);
                }
            }
        }
        return status;
    }

    private IStatus appendStatusMessage(IStatus existingStatus, String message, int severity) {
        MultiStatus multiStatus;
        Status newStatus = new Status(severity, "com.ibm.etools.j2ee.ui", message);
        int newSeverity = severity;
        if (existingStatus.getSeverity() > severity) {
            newSeverity = existingStatus.getSeverity();
        }
        if (existingStatus instanceof MultiStatus) {
            multiStatus = (MultiStatus)existingStatus;
            multiStatus.merge((IStatus)newStatus);
        } else {
            if (!existingStatus.isMultiStatus() && existingStatus.isOK()) {
                return newStatus;
            }
            IStatus[] children = new IStatus[]{existingStatus, newStatus};
            multiStatus = new MultiStatus("com.ibm.etools.j2ee.ui", newSeverity, children, null, null);
        }
        return multiStatus;
    }
}

