/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.validator;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.manifest.ClasspathDependenciesDiscerner;
import com.ibm.etools.j2ee.ui.validator.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.internal.modulecore.ClasspathContainerVirtualComponent;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.ui.J2EEModuleDependenciesPropertyPage;
import org.eclipse.jst.j2ee.internal.ui.J2EEModuleDeploymentAssemblyVerifierData;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.VirtualReferenceUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.AbstractDeploymentAssemblyVerifier;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.DeploymentAssemblyVerifierData;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;

public class AssemblyVerifier
extends AbstractDeploymentAssemblyVerifier {
    IPath WEB_INF_LIB = new Path("WEB-INF/lib").makeAbsolute();

    public IStatus verify(DeploymentAssemblyVerifierData data) {
        IStatus status = Status.OK_STATUS;
        Hashtable<String, String> messages = new Hashtable<String, String>();
        IProject dataProject = data.getComponent().getProject();
        if (JavaEEProjectUtilities.isEARProject((IProject)dataProject)) {
            boolean nestedEAR = false;
            for (IVirtualReference ref : data.getCurrentReferences()) {
                IVirtualComponent refComp = ref.getReferencedComponent();
                if (refComp.isBinary() || JavaEEProjectUtilities.isEARProject((IProject)refComp.getProject())) {
                    String archiveName = ref.getArchiveName();
                    if (archiveName == null) {
                        archiveName = VirtualReferenceUtilities.INSTANCE.getDefaultArchiveName(ref);
                    }
                    if (!nestedEAR && archiveName != null && archiveName.toLowerCase().endsWith(".ear")) {
                        status = this.appendStatusMessage(status, Messages.NestedEarNotSupported, 2);
                        nestedEAR = true;
                    }
                }
                status = this.validateDeployPathAndArchiveName(ref, status);
            }
        } else {
            IStatus mess = this.validateExistingClasspathEntries(data, messages);
            if (mess.getSeverity() == 4) {
                return mess;
            }
            if (JavaEEProjectUtilities.isUtilityProject((IProject)dataProject)) {
                boolean jarNotInClasspath = false;
                for (IVirtualReference ref : data.getCurrentReferences()) {
                    IVirtualComponent refComp = ref.getReferencedComponent();
                    status = this.validateDeployPathAndArchiveName(ref, status);
                    messages.putAll(this.verifyIfJarReferenceExistInEAR(data, ref));
                    if (jarNotInClasspath || !refComp.isBinary() && refComp.getProject() == dataProject) continue;
                    String archiveName = ref.getArchiveName();
                    if (archiveName == null) {
                        archiveName = VirtualReferenceUtilities.INSTANCE.getDefaultArchiveName(ref);
                    }
                    if (archiveName == null || !(archiveName = archiveName.toLowerCase()).endsWith(".jar") && !archiveName.endsWith(".war") && !archiveName.endsWith(".rar") && !archiveName.endsWith(".ear") && !archiveName.endsWith(".zip")) continue;
                    jarNotInClasspath = true;
                    status = this.appendStatusMessage(status, Messages.bind((String)Messages.JarFilesAssembledNotInClasspath, (Object[])new Object[]{data.getComponent().getName()}), 2);
                }
            } else {
                boolean nestedModule = false;
                boolean nestedModuleAC = false;
                boolean nestedModuleWeb = false;
                boolean nestedModuleJCA = false;
                boolean earInModule = false;
                if (JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)data.getComponent())) {
                    boolean jarNotInWebInf = false;
                    String versionString = JavaEEProjectUtilities.getProjectFacetVersion((IProject)dataProject, (String)"jst.web").getVersionString();
                    int version = J2EEVersionUtil.convertVersionStringToInt((String)versionString);
                    for (IVirtualReference ref : data.getCurrentReferences()) {
                        IVirtualComponent refComp = ref.getReferencedComponent();
                        status = this.validateDeployPathAndArchiveName(ref, status);
                        messages.putAll(this.verifyIfJarReferenceExistInEAR(data, ref));
                        if (refComp.isBinary() || refComp.getProject() != dataProject) {
                            String type = JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)refComp);
                            if (!earInModule && "jst.ear".equals(type)) {
                                earInModule = true;
                                status = this.appendStatusMessage(status, Messages.EarWithinModuleNotSupported, 2);
                            } else if (version < 30) {
                                if (!nestedModule && ("jst.appclient".equals(type) || "jst.connector".equals(type) || "jst.web".equals(type) || "jst.ejb".equals(type))) {
                                    nestedModule = true;
                                    status = this.appendStatusMessage(status, Messages.NestedModulesNotSupported, 2);
                                }
                            } else if (!nestedModuleAC && "jst.appclient".equals(type)) {
                                nestedModuleAC = true;
                                status = this.appendStatusMessage(status, Messages.NestedACModulesNotSupported, 2);
                            } else if (!nestedModuleJCA && "jst.connector".equals(type)) {
                                nestedModuleJCA = true;
                                status = this.appendStatusMessage(status, Messages.NestedJCAModulesNotSupported, 2);
                            } else if (!nestedModuleWeb && "jst.web".equals(type)) {
                                nestedModuleWeb = true;
                                status = this.appendStatusMessage(status, Messages.NestedWebModulesNotSupported, 2);
                            }
                        }
                        if (jarNotInWebInf) continue;
                        String archiveName = ref.getArchiveName();
                        if (archiveName == null) {
                            archiveName = VirtualReferenceUtilities.INSTANCE.getDefaultArchiveName(ref);
                        }
                        if (!(refComp instanceof ClasspathContainerVirtualComponent) && (archiveName == null || !archiveName.toLowerCase().endsWith(".jar")) || ref.getRuntimePath().equals((Object)this.WEB_INF_LIB)) continue;
                        jarNotInWebInf = true;
                        status = this.appendStatusMessage(status, Messages.JarFilesForWebShouldBeInWebInf, 2);
                    }
                } else if (JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)data.getComponent()) || JavaEEProjectUtilities.isApplicationClientComponent((IVirtualComponent)data.getComponent()) || JavaEEProjectUtilities.isWebFragmentProject((IVirtualComponent)data.getComponent())) {
                    boolean jarNotInClasspath = false;
                    for (IVirtualReference ref : data.getCurrentReferences()) {
                        IVirtualComponent refComp = ref.getReferencedComponent();
                        status = this.validateDeployPathAndArchiveName(ref, status);
                        messages.putAll(this.verifyIfJarReferenceExistInEAR(data, ref));
                        if (earInModule && nestedModule && jarNotInClasspath || !refComp.isBinary() && refComp.getProject() == dataProject) continue;
                        String type = JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)refComp);
                        if (!earInModule && "jst.ear".equals(type)) {
                            earInModule = true;
                            status = this.appendStatusMessage(status, Messages.EarWithinModuleNotSupported, 2);
                            continue;
                        }
                        if (!nestedModule && ("jst.appclient".equals(type) || "jst.connector".equals(type) || "jst.web".equals(type) || "jst.ejb".equals(type))) {
                            nestedModule = true;
                            status = this.appendStatusMessage(status, Messages.NestedModulesNotSupported, 2);
                            continue;
                        }
                        if (jarNotInClasspath) continue;
                        String archiveName = ref.getArchiveName();
                        if (archiveName == null) {
                            archiveName = VirtualReferenceUtilities.INSTANCE.getDefaultArchiveName(ref);
                        }
                        if (archiveName == null || !archiveName.toLowerCase().endsWith(".jar")) continue;
                        jarNotInClasspath = true;
                        status = this.appendStatusMessage(status, Messages.bind((String)Messages.JarAssembledNotInClasspath, (Object[])new Object[]{data.getComponent().getName()}), 2);
                    }
                } else if (JavaEEProjectUtilities.isJCAComponent((IVirtualComponent)data.getComponent())) {
                    for (IVirtualReference ref : data.getCurrentReferences()) {
                        IVirtualComponent refComp = ref.getReferencedComponent();
                        status = this.validateDeployPathAndArchiveName(ref, status);
                        messages.putAll(this.verifyIfJarReferenceExistInEAR(data, ref));
                        if (earInModule && nestedModule || !refComp.isBinary() && refComp.getProject() == dataProject) continue;
                        String type = JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)refComp);
                        if (!earInModule && "jst.ear".equals(type)) {
                            earInModule = true;
                            status = this.appendStatusMessage(status, Messages.EarWithinModuleNotSupported, 2);
                            continue;
                        }
                        if (nestedModule || !"jst.appclient".equals(type) && !"jst.connector".equals(type) && !"jst.web".equals(type) && !"jst.ejb".equals(type)) continue;
                        nestedModule = true;
                        status = this.appendStatusMessage(status, Messages.NestedModulesNotSupported, 2);
                    }
                }
            }
            status = this.checkManifestFileFound(data, status);
            status = this.appendMultipleStatusMessage(status, messages.values().toArray(new String[messages.values().size()]), 2);
        }
        return status;
    }

    private IStatus appendStatusMessage(IStatus existingStatus, String message, int severity) {
        MultiStatus multiStatus;
        Status newStatus = new Status(severity, "com.ibm.etools.j2ee.ui", message);
        int newSeverity = severity;
        if (existingStatus.getSeverity() > severity) {
            newSeverity = existingStatus.getSeverity();
        }
        if (existingStatus instanceof MultiStatus) {
            multiStatus = (MultiStatus)existingStatus;
            multiStatus.merge((IStatus)newStatus);
        } else {
            if (!existingStatus.isMultiStatus() && existingStatus.isOK()) {
                return newStatus;
            }
            IStatus[] children = new IStatus[]{existingStatus, newStatus};
            multiStatus = new MultiStatus("com.ibm.etools.j2ee.ui", newSeverity, children, null, null);
        }
        return multiStatus;
    }

    private IStatus appendMultipleStatusMessage(IStatus status, String[] messages, int severity) {
        IStatus newStatus = status;
        for (int i = 0; i < messages.length; ++i) {
            newStatus = this.appendStatusMessage(newStatus, messages[i], severity);
        }
        return newStatus;
    }

    private Hashtable<String, String> verifyIfJarReferenceExistInEAR(DeploymentAssemblyVerifierData data, IVirtualReference ref) {
        IProject[] earProjects;
        Hashtable<String, String> messages = new Hashtable<String, String>();
        String refName = ref.getArchiveName();
        IVirtualComponent refComp = ref.getReferencedComponent();
        if (refName == null) {
            refName = refComp.getName();
        }
        if ((refName != null && refName.toLowerCase().endsWith(".jar") || refComp instanceof VirtualArchiveComponent && ((VirtualArchiveComponent)refComp).getArchivePath().getFileExtension() != null && ((VirtualArchiveComponent)refComp).getArchivePath().getFileExtension().equals(".jar") || JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)refComp) || JavaEEProjectUtilities.isApplicationClientComponent((IVirtualComponent)refComp) || refComp instanceof ClasspathContainerVirtualComponent) && (earProjects = EarUtilities.getReferencingEARProjects((IProject)data.getComponent().getProject())).length > 0) {
            block0: for (int y = 0; y < earProjects.length; ++y) {
                IProject earProject = earProjects[y];
                IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                IVirtualReference[] earRefs = earComponent.getReferences();
                for (int i = 0; i < earRefs.length; ++i) {
                    refName = ref.getArchiveName();
                    String earRefName = earRefs[i].getArchiveName();
                    IVirtualComponent earRefComp = earRefs[i].getReferencedComponent();
                    if (refName == null || earRefName == null) {
                        refName = refComp.getName();
                        earRefName = earRefComp.getName();
                    }
                    if ((refName == null || earRefName == null || !refName.equals(earRefName)) && (!(refComp instanceof VirtualArchiveComponent) || !(earRefComp instanceof VirtualArchiveComponent) || !((VirtualArchiveComponent)refComp).getArchivePath().equals((Object)((VirtualArchiveComponent)earRefComp).getArchivePath()))) continue;
                    String earLibDir = EarUtilities.getEARLibDir((IVirtualComponent)earComponent);
                    IPath earLibDirPath = null;
                    if (earLibDir != null) {
                        earLibDirPath = new Path(earLibDir).makeRelative();
                    }
                    String mappingExistsMessage = null;
                    mappingExistsMessage = earLibDirPath == null || earLibDirPath.isEmpty() || !earRefs[i].getRuntimePath().makeRelative().equals((Object)earLibDirPath) ? Messages.bind((String)Messages.MappingExistsAddThroughManifest, (Object[])new Object[]{earComponent.getName(), refName}) : Messages.bind((String)Messages.MappingExistsShouldBeRemoved, (Object[])new Object[]{earComponent.getName(), refName});
                    messages.put(mappingExistsMessage, mappingExistsMessage);
                    continue block0;
                }
            }
        }
        return messages;
    }

    private IStatus checkManifestFileFound(DeploymentAssemblyVerifierData data, IStatus status) {
        IStatus resultStatus = status;
        boolean manifestFound = false;
        IFile manifest = J2EEProjectUtilities.getManifestFile((IProject)data.getComponent().getProject(), (boolean)false);
        if (manifest != null && manifest.exists()) {
            Iterator iterator = data.getResourceMappings().iterator();
            while (iterator.hasNext() && !manifestFound) {
                AddModuleDependenciesPropertiesPage.ComponentResourceProxy mapping = (AddModuleDependenciesPropertiesPage.ComponentResourceProxy)iterator.next();
                String osPath = mapping.source.makeAbsolute().toString();
                if (osPath != null) {
                    String manifestFolderPath = manifest.getFullPath().removeFirstSegments(1).makeAbsolute().toString();
                    if (!manifestFolderPath.startsWith(osPath)) continue;
                    manifestFound = true;
                    break;
                }
                manifestFound = true;
            }
            if (!manifestFound) {
                resultStatus = this.appendStatusMessage(resultStatus, Messages.ManifestNotFoundOnModified, 2);
            }
        } else {
            IVirtualFolder virtualFolder = data.getComponent().getRootFolder();
            Path manifestPath = new Path("META-INF/MANIFEST.MF");
            manifest = virtualFolder.getUnderlyingFolder().getFile((IPath)manifestPath);
            if (manifest != null && !manifest.exists()) {
                String manifestFolderPath = manifest.getFullPath().removeFirstSegments(1).makeAbsolute().toString();
                if (!(manifestFolderPath = manifestFolderPath.replace(manifestPath.makeAbsolute().toString(), "")).isEmpty() && !manifestFolderPath.equals("/")) {
                    manifest = J2EEProjectUtilities.getManifestFile((IProject)data.getComponent().getProject(), (boolean)true);
                    if (manifest != null && !manifest.exists()) {
                        resultStatus = this.appendStatusMessage(resultStatus, Messages.ManifestNotFoundOnOpen, 2);
                    }
                } else {
                    resultStatus = this.appendStatusMessage(resultStatus, Messages.ManifestNotFoundOnOpen, 2);
                }
            }
        }
        return resultStatus;
    }

    private IStatus validateExistingClasspathEntries(DeploymentAssemblyVerifierData data, Hashtable<String, String> warningMessages) {
        IStatus resultStatus = Status.OK_STATUS;
        if (data instanceof J2EEModuleDeploymentAssemblyVerifierData) {
            IVirtualComponent component = data.getComponent();
            IVirtualComponent referencingEARorWeb = AssemblyVerifier.getReferencingEARorWebComponent(component);
            String correctRelativeRuntimePath = null;
            boolean referencingComponentIsEAR = false;
            String libDir = null;
            if (referencingEARorWeb != null) {
                if (JavaEEProjectUtilities.isEARProject((IProject)referencingEARorWeb.getProject())) {
                    referencingComponentIsEAR = true;
                    libDir = EarUtilities.getEARLibDir((IVirtualComponent)referencingEARorWeb);
                }
                correctRelativeRuntimePath = AssemblyVerifier.calculateRelativeRuntimePath(referencingEARorWeb, component, libDir);
            }
            List classpathEntries = ((J2EEModuleDeploymentAssemblyVerifierData)data).getCurrentClasspathEntries();
            for (J2EEModuleDependenciesPropertyPage.ClasspathEntryProxy classpathEntryProxy : classpathEntries) {
                String warning;
                IClasspathEntry classpathEntry = classpathEntryProxy.entry;
                String archiveName = classpathEntry.getPath().lastSegment();
                String runtimePath = null;
                IClasspathAttribute attribute = ClasspathDependencyUtil.checkForComponentDependencyAttribute((IClasspathEntry)classpathEntry, (IClasspathDependencyConstants.DependencyAttributeType)IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY);
                if (attribute == null) continue;
                runtimePath = new Path(attribute.getValue()).toString();
                if (JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
                    if (new Path(runtimePath).makeRelative().toString().equals("WEB-INF/lib")) continue;
                    boolean showWarning = false;
                    if (referencingComponentIsEAR) {
                        if (!JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)referencingEARorWeb)) {
                            if (!runtimePath.startsWith("../")) {
                                showWarning = true;
                            }
                        } else if (!(correctRelativeRuntimePath == null || AssemblyVerifier.isValidEE5DeployPathForBuildPathEntry(referencingEARorWeb, component, runtimePath, libDir) || runtimePath.startsWith("../") && this.isEntryInManifest(classpathEntry, component, new Path(runtimePath).removeFirstSegments(1)))) {
                            showWarning = true;
                        }
                    } else {
                        warning = Messages.bind((String)Messages.IncorrectDeployPath, (Object[])new Object[]{archiveName, "WEB-INF/lib"});
                        warningMessages.put(warning, warning);
                    }
                    if (!showWarning) continue;
                    warning = Messages.bind((String)Messages.IncorrectDeployPathForWeb, (Object[])new Object[]{archiveName});
                    warningMessages.put(warning, warning);
                    continue;
                }
                if (referencingEARorWeb == null) continue;
                if (referencingComponentIsEAR) {
                    if (!JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)referencingEARorWeb)) {
                        if (runtimePath.startsWith("../")) continue;
                        String warning2 = Messages.bind((String)Messages.IncorrectDeployPath, (Object[])new Object[]{archiveName, "../"});
                        warningMessages.put(warning2, warning2);
                        continue;
                    }
                    if (correctRelativeRuntimePath == null || AssemblyVerifier.isValidEE5DeployPathForBuildPathEntry(referencingEARorWeb, component, runtimePath, libDir) || runtimePath.startsWith("../") && this.isEntryInManifest(classpathEntry, component, new Path(runtimePath).removeFirstSegments(1))) continue;
                    String warning3 = Messages.bind((String)Messages.IncorrectDeployPath, (Object[])new Object[]{archiveName, correctRelativeRuntimePath});
                    warningMessages.put(warning3, warning3);
                    continue;
                }
                IVirtualReference targetRef = referencingEARorWeb.getReference(component.getName());
                if (targetRef.getRuntimePath().makeAbsolute().equals((Object)this.WEB_INF_LIB)) {
                    if (runtimePath.equals("../")) continue;
                    warning = Messages.bind((String)Messages.IncorrectDeployPath, (Object[])new Object[]{archiveName, "../"});
                    warningMessages.put(warning, warning);
                    continue;
                }
                warning = Messages.bind((String)Messages.ProjectDeployPathNotInWEBINFlib, (Object[])new Object[]{archiveName, referencingEARorWeb.getName(), component.getName()});
                warningMessages.put(warning, warning);
            }
        }
        return resultStatus;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isEntryInManifest(IClasspathEntry entry, IVirtualComponent component, IPath runtimePath) {
        resolvedEntries = new ArrayList<String>();
        if (entry.getEntryKind() == 5) {
            javaProj = JavaCore.create((IProject)component.getProject());
            try {
                container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProj);
                if (container == null) ** GOTO lbl27
                for (j = 0; j < container.getClasspathEntries().length; ++j) {
                    childEntry = container.getClasspathEntries()[j];
                    archivePath = new Path(ClasspathDependencyUtil.getArchiveName((IClasspathEntry)childEntry));
                    resolvedEntries.add(runtimePath.append((IPath)archivePath).toString());
                }
            }
            catch (JavaModelException e) {
                J2eePlugin.logError((CoreException)e);
            }
        } else if (entry.getEntryKind() == 4) {
            varEntry = ClasspathDependenciesDiscerner.getResolvedVarEntry((IProject)component.getProject(), (IClasspathEntry)entry);
            if (varEntry != null) {
                archivePath = new Path(ClasspathDependencyUtil.getArchiveName((IClasspathEntry)varEntry));
                resolvedEntries.add(runtimePath.append((IPath)archivePath).toString());
            }
        } else {
            archivePath = new Path(ClasspathDependencyUtil.getArchiveName((IClasspathEntry)entry));
            resolvedEntries.add(runtimePath.append((IPath)archivePath).toString());
        }
lbl27:
        // 5 sources

        existingEntries = Arrays.asList(ManifestUtilities.getManifestClasspath((IVirtualComponent)component, (IPath)new Path("META-INF/MANIFEST.MF")));
        iterator = resolvedEntries.iterator();
        while (iterator.hasNext()) {
            if (!existingEntries.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private static IVirtualComponent getReferencingEARorWebComponent(IVirtualComponent targetComponent) {
        IVirtualComponent[] referencingComponents = targetComponent.getReferencingComponents();
        IVirtualComponent referencingEARorWeb = null;
        for (IVirtualComponent refComp : referencingComponents) {
            if (JavaEEProjectUtilities.isEARProject((IProject)refComp.getProject())) {
                referencingEARorWeb = refComp;
                break;
            }
            if (referencingEARorWeb != null || !JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)refComp)) continue;
            referencingEARorWeb = refComp;
        }
        return referencingEARorWeb;
    }

    private static boolean isValidEE5DeployPathForBuildPathEntry(IVirtualComponent earComponent, IVirtualComponent targetComponent, String currentPath, String libDir) {
        IVirtualReference targetRef = earComponent.getReference(targetComponent.getName());
        IPath projectPath = targetComponent.getProject().getFullPath();
        IPath targetRuntime = targetRef.getRuntimePath();
        IPath targetProjectFullPath = targetRuntime.append(projectPath);
        if (libDir == null) {
            return false;
        }
        IPath libDirPath = new Path(libDir).makeAbsolute();
        IPath tmpCurrentPath = targetProjectFullPath.append(currentPath).makeAbsolute();
        return tmpCurrentPath.makeAbsolute().equals((Object)libDirPath);
    }

    private static String calculateRelativeRuntimePath(IVirtualComponent earComponent, IVirtualComponent targetComponent, String libDir) {
        if (libDir != null && libDir.length() > 0) {
            IVirtualReference targetRef = earComponent.getReference(targetComponent.getName());
            String upOneLevel = "../";
            Path libDirPath = new Path(libDir);
            if (targetRef == null || targetRef.getRuntimePath().equals((Object)"/")) {
                return new Path("../").append(libDirPath.makeAbsolute()).toString();
            }
            IPath childProjectRuntimePath = targetRef.getRuntimePath();
            String[] childProjectFolders = childProjectRuntimePath.segments();
            String[] libFolders = libDirPath.segments();
            int commonFolderCount = 0;
            for (int i = 0; i < childProjectFolders.length && i < libFolders.length && childProjectFolders[i].equals(libFolders[i]); ++i) {
                ++commonFolderCount;
            }
            Object resultString = "../";
            for (int i = 0; i < childProjectFolders.length - commonFolderCount; ++i) {
                resultString = (String)resultString + "../";
            }
            return new Path((String)resultString).append(libDirPath.removeFirstSegments(commonFolderCount)).toString();
        }
        return null;
    }

    private IStatus validateDeployPathAndArchiveName(IVirtualReference ref, IStatus status) {
        IPath deployPath = ref.getRuntimePath();
        String currentArchiveName = ref.getArchiveName();
        IStatus resultStatus = status;
        if (currentArchiveName != null && currentArchiveName.length() > 0) {
            boolean invalidDeployPath = false;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus fileStatus = workspace.validateName(currentArchiveName, 1);
            if (!fileStatus.isOK()) {
                invalidDeployPath = true;
            }
            if (!invalidDeployPath) {
                if (deployPath == null || deployPath.makeRelative().toString().length() == 0) {
                    return resultStatus;
                }
                int max = deployPath.segmentCount();
                for (int i = 0; i < max && !invalidDeployPath; ++i) {
                    IStatus folderStatus = workspace.validateName(deployPath.segment(i), 2);
                    if (folderStatus.isOK()) continue;
                    invalidDeployPath = true;
                }
            }
            if (invalidDeployPath) {
                String defaultArchiveName = VirtualReferenceUtilities.INSTANCE.getDefaultArchiveName(ref);
                IVirtualComponent refComp = ref.getReferencedComponent();
                if (refComp instanceof VirtualArchiveComponent && defaultArchiveName != null) {
                    if (((VirtualArchiveComponent)refComp).getArchiveType().equals("var")) {
                        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)new Path(defaultArchiveName));
                        defaultArchiveName = resolvedPath.toString();
                    } else {
                        defaultArchiveName = ((VirtualArchiveComponent)refComp).getArchivePath().toString();
                    }
                }
                String error = Messages.bind((String)Messages.InvalidDeployPath, (Object[])new Object[]{deployPath.makeRelative().append(currentArchiveName).toString(), defaultArchiveName});
                resultStatus = this.appendStatusMessage(resultStatus, error, 4);
            }
        }
        return resultStatus;
    }
}

