/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.common.internal.provider.CommonItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.internal.actions.AbstractOpenWizardWorkbenchAction;
import org.eclipse.jst.j2ee.internal.application.provider.ApplicationItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.internal.ejb.provider.EjbItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.internal.provider.J2EEItemProvider;
import org.eclipse.jst.j2ee.internal.provider.J2EEUIEditingDomain;
import org.eclipse.jst.j2ee.internal.web.providers.WebapplicationItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.internal.webservice.provider.WsddItemProviderAdapterFactory;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class NewWizardAction
extends AbstractOpenWizardWorkbenchAction {
    protected EditingDomain domain;
    protected IProject project;
    protected ArtifactEdit artifactEdit;
    private AdapterFactory adapterFactory;

    public NewWizardAction() {
    }

    public NewWizardAction(IWorkbench workbench, String label, Class[] activatedOnTypes, boolean acceptEmptySelection) {
        super(workbench, label, activatedOnTypes, acceptEmptySelection);
    }

    public NewWizardAction(IWorkbench workbench, String label, boolean acceptEmptySelection) {
        super(workbench, label, acceptEmptySelection);
    }

    protected Wizard createWizard() {
        this.initWizard();
        return this.getWizard();
    }

    protected abstract Wizard getWizard();

    protected IStructuredSelection getStructuredSelection() {
        return this.getCurrentSelection();
    }

    protected boolean shouldAcceptElement(Object obj) {
        return true;
    }

    public void run() {
        try {
            Wizard wizard = this.createWizard();
            if (wizard instanceof IWorkbenchWizard) {
                IStructuredSelection sel = this.getStructuredSelection();
                if (sel == null) {
                    sel = new StructuredSelection();
                }
                ((IWorkbenchWizard)wizard).init(JavaPlugin.getDefault().getWorkbench(), sel);
            }
            WizardDialog dialog = new WizardDialog(JavaPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
        finally {
            if (this.artifactEdit != null) {
                this.artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            this.artifactEdit.dispose();
        }
    }

    protected void initWizard() {
        Object selection = this.getStructuredSelection().getFirstElement();
        WebApp webApp = null;
        if (selection instanceof WebApp) {
            webApp = (WebApp)selection;
        } else {
            J2EEItemProvider provider = (J2EEItemProvider)selection;
            if (provider == null) {
                return;
            }
            webApp = (WebApp)provider.getParent((Object)this);
        }
        this.project = ProjectUtilities.getProject((EObject)webApp);
        IVirtualResource[] resources = ComponentCore.createResources((IResource)WorkbenchResourceHelper.getFile((Resource)webApp.eResource()));
        if (resources != null && resources.length > 0) {
            this.artifactEdit = ArtifactEdit.getArtifactEditForWrite((IVirtualComponent)resources[0].getComponent());
            this.domain = new J2EEUIEditingDomain(this.getAdapterFactory(), this.artifactEdit.getCommandStack());
        }
    }

    protected AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            EjbItemProviderAdapterFactory ejbFactory = new EjbItemProviderAdapterFactory();
            ApplicationItemProviderAdapterFactory appFactory = new ApplicationItemProviderAdapterFactory();
            WebapplicationItemProviderAdapterFactory webFactory = new WebapplicationItemProviderAdapterFactory();
            CommonItemProviderAdapterFactory commonFactory = new CommonItemProviderAdapterFactory();
            WsddItemProviderAdapterFactory wsddFactory = new WsddItemProviderAdapterFactory();
            ComposedAdapterFactory combinedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{ejbFactory, appFactory, webFactory, commonFactory, wsddFactory});
            this.adapterFactory = combinedAdapterFactory;
        }
        return this.adapterFactory;
    }

    public void dispose() {
        super.dispose();
    }
}

