/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.wizard;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.common.frameworks.internal.ui.ValidationStatus;

public abstract class J2EEWizardPage
extends WizardPage
implements Listener {
    protected static final int NEXT = 1;
    protected static final int PREVIOUS = 2;
    protected static final int COMPOSITE_BORDER = 0;
    private ValidationStatus status = new ValidationStatus();
    private boolean isValidating = false;
    protected boolean isFirstTimeToPage = true;

    protected J2EEWizardPage(String pageName) {
        super(pageName);
    }

    protected J2EEWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected IPath convertPackageNameToPath(String qualifiedName) {
        String name = qualifiedName.replace('.', '/');
        return new Path(name);
    }

    public void createControl(Composite parent) {
        Composite top = this.createTopLevelComposite(parent);
        this.setControl((Control)top);
        this.setupInfopop((Control)top);
        this.setDefaults();
        this.addListeners();
    }

    protected abstract Composite createTopLevelComposite(Composite var1);

    protected void setupInfopop(Control parent) {
    }

    protected void setDefaults() {
        this.restoreDefaultSettings();
    }

    protected void restoreDefaultSettings() {
    }

    protected void addListeners() {
    }

    protected void enter() {
        try {
            this.validatePage(this.showValidationErrorsOnEnter());
        }
        finally {
            this.isFirstTimeToPage = false;
        }
    }

    protected boolean showValidationErrorsOnEnter() {
        return !this.isFirstTimeToPage();
    }

    protected boolean shouldValidateOnEnter() {
        return this.showValidationErrorsOnEnter();
    }

    protected void exit() {
    }

    protected boolean getStatus(Integer key) {
        return this.status.hasError(key);
    }

    public void handleEvent(Event event) {
        this.validatePage();
    }

    protected void setErrorMessage() {
        String error = this.status.getLastErrMsg();
        if (error == null) {
            String warning;
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if ((warning = this.status.getLastWarningMsg()) == null) {
                if (this.getMessage() != null && this.getMessageType() == 2) {
                    this.setMessage(null, 2);
                }
            } else if (!warning.equals(this.getMessage())) {
                this.setMessage(warning, 2);
            }
        } else if (!error.equals(this.getErrorMessage())) {
            this.setErrorMessage(error);
        }
    }

    protected void setErrorStatus(Integer key, String errorMessage) {
        this.status.setErrorStatus(key, errorMessage);
    }

    protected void setWarningStatus(Integer key, String warningMessage) {
        this.status.setWarningStatus(key, warningMessage);
    }

    protected void setOKStatus(Integer key) {
        this.status.setOKStatus(key);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.enter();
        } else {
            this.exit();
        }
    }

    public void storeDefaultSettings() {
    }

    protected void validatePage() {
        this.validatePage(true);
    }

    protected void validatePage(boolean showMessage) {
        if (!this.isValidating) {
            this.isValidating = true;
            try {
                this.validateControls();
                this.updateControls();
                if (showMessage) {
                    this.setErrorMessage();
                }
                this.setPageComplete(this.status.getLastErrMsg() == null);
            }
            finally {
                this.isValidating = false;
            }
        }
    }

    protected abstract void validateControls();

    protected void updateControls() {
    }

    protected boolean isFirstTimeToPage() {
        return this.isFirstTimeToPage;
    }

    protected void setJavaStatusMessage(IStatus javaStatus, Integer statusKey, String message) {
        if (javaStatus.getSeverity() == 2) {
            this.setWarningStatus(statusKey, message);
        } else {
            this.setErrorStatus(statusKey, message);
        }
    }

    public void setFirstTimeToPage(boolean b) {
        this.isFirstTimeToPage = b;
    }
}

