/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.ui;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ProjectLocationSelectionDialog
extends SelectionDialog {
    protected Text projectNameField;
    protected Text locationPathField;
    protected Label locationLabel;
    protected IProject project;
    private Label statusMessageLabel;
    protected Button browseButton;
    private static String PROJECT_NAME_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_nameLabel;
    private static String LOCATION_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationLabel;
    private static String BROWSE_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_browseLabel;
    private static String DIRECTORY_DIALOG_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel;
    private static String INVALID_LOCATION_MESSAGE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationError;
    private static String PROJECT_LOCATION_SELECTION_TITLE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_selectionTitle;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    protected boolean useDefaults = true;

    public ProjectLocationSelectionDialog(Shell parentShell, IProject existingProject) {
        super(parentShell);
        this.setTitle(PROJECT_LOCATION_SELECTION_TITLE);
        this.project = existingProject;
        try {
            this.useDefaults = this.getProject().getDescription().getLocation() == null;
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void applyValidationResult(String errorMsg) {
        if (errorMsg == null) {
            this.statusMessageLabel.setText("");
            this.getOkButton().setEnabled(true);
        } else {
            this.statusMessageLabel.setForeground(JFaceColors.getErrorText((Display)this.statusMessageLabel.getDisplay()));
            this.statusMessageLabel.setText(errorMsg);
            this.getOkButton().setEnabled(false);
        }
    }

    protected String checkValid() {
        String valid = this.checkValidName();
        if (valid != null) {
            return valid;
        }
        return this.checkValidLocation();
    }

    private String checkValidLocation() {
        if (this.useDefaults) {
            return null;
        }
        String locationFieldContents = this.locationPathField.getText();
        if (locationFieldContents.equals("")) {
            return IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            return INVALID_LOCATION_MESSAGE;
        }
        IStatus locationStatus = this.project.getWorkspace().validateProjectLocation(this.project, (IPath)new Path(locationFieldContents));
        if (!locationStatus.isOK()) {
            return locationStatus.getMessage();
        }
        return null;
    }

    private String checkValidName() {
        String name = this.projectNameField.getText();
        IWorkspace workspace = this.getProject().getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 4);
        if (!nameStatus.isOK()) {
            return nameStatus.getMessage();
        }
        IProject newProject = workspace.getRoot().getProject(name);
        if (newProject.exists()) {
            return NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_alreadyExists, (Object[])new Object[]{name});
        }
        return null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.statusMessageLabel = new Label(composite, 0);
        this.statusMessageLabel.setLayoutData((Object)new GridData(1808));
        this.statusMessageLabel.setFont(parent.getFont());
        return composite;
    }

    private void createLocationListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ProjectLocationSelectionDialog.this.applyValidationResult(ProjectLocationSelectionDialog.this.checkValid());
            }
        };
        this.locationPathField.addListener(24, listener);
    }

    private void createNameListener() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ProjectLocationSelectionDialog.this.setLocationForSelection();
                ProjectLocationSelectionDialog.this.applyValidationResult(ProjectLocationSelectionDialog.this.checkValid());
            }
        };
        this.projectNameField.addListener(24, listener);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_useDefaultLabel);
        useDefaultsButton.setSelection(this.useDefaults);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectLocationSelectionDialog.this.useDefaults = useDefaultsButton.getSelection();
                ProjectLocationSelectionDialog.this.browseButton.setEnabled(!ProjectLocationSelectionDialog.this.useDefaults);
                ProjectLocationSelectionDialog.this.locationPathField.setEnabled(!ProjectLocationSelectionDialog.this.useDefaults);
                ProjectLocationSelectionDialog.this.locationLabel.setEnabled(!ProjectLocationSelectionDialog.this.useDefaults);
                ProjectLocationSelectionDialog.this.setLocationForSelection();
                if (!ProjectLocationSelectionDialog.this.useDefaults) {
                    ProjectLocationSelectionDialog.this.locationPathField.setText("");
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(PROJECT_NAME_LABEL);
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setText(this.getCopyNameFor(this.getProject().getName()));
        this.projectNameField.selectAll();
        this.createNameListener();
    }

    private Composite createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(LOCATION_LABEL);
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectLocationSelectionDialog.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        try {
            IPath location = this.getProject().getDescription().getLocation();
            if (location == null) {
                this.setLocationForSelection();
            } else {
                this.locationPathField.setText(location.toString());
            }
        }
        catch (CoreException exception) {
            this.setLocationForSelection();
        }
        this.createLocationListener();
        return projectGroup;
    }

    private String getCopyNameFor(String projectName) {
        IWorkspace workspace = this.getProject().getWorkspace();
        if (!workspace.getRoot().getProject(projectName).exists()) {
            return projectName;
        }
        int counter = 1;
        while (true) {
            String nameSegment = counter > 1 ? NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_copyNameTwoArgs, (Object[])new Object[]{new Integer(counter), projectName}) : NLS.bind((String)IDEWorkbenchMessages.CopyProjectAction_copyNameOneArg, (Object[])new Object[]{projectName});
            if (!workspace.getRoot().getProject(nameSegment).exists()) {
                return nameSegment;
            }
            ++counter;
        }
    }

    protected IProject getProject() {
        return this.project;
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(DIRECTORY_DIALOG_LABEL);
        String dirName = this.locationPathField.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.locationPathField.setText(selectedDirectory);
        }
    }

    protected void okPressed() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.projectNameField.getText());
        if (this.useDefaults) {
            list.add(Platform.getLocation().toString());
        } else {
            list.add(this.locationPathField.getText());
        }
        this.setResult(list);
        super.okPressed();
    }

    protected void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.projectNameField.getText());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }
}

